/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BIngredients;
import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.BrewDefect;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.brew.BrewModifyEvent;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.lore.Base91DecoderStream;
import com.dre.brewery.lore.Base91EncoderStream;
import com.dre.brewery.lore.BrewLore;
import com.dre.brewery.lore.LoreLoadStream;
import com.dre.brewery.lore.LoreSaveStream;
import com.dre.brewery.lore.NBTLoadStream;
import com.dre.brewery.lore.NBTSaveStream;
import com.dre.brewery.lore.XORScrambleStream;
import com.dre.brewery.lore.XORUnscrambleStream;
import com.dre.brewery.recipe.BEffect;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.BestRecipeResult;
import com.dre.brewery.recipe.PotionColor;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BukkitConstants;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class Brew
implements Cloneable {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final Config config = ConfigManager.getConfig(Config.class);
    private static final Lang lang = ConfigManager.getConfig(Lang.class);
    public static final byte SAVE_VER = 1;
    private static long saveSeed;
    private static List<Long> prevSaveSeeds;
    public static Map<Integer, Brew> legacyPotions;
    public static long installTime;
    private BIngredients ingredients;
    private int quality;
    private int alc;
    private byte distillRuns;
    private float ageTime;
    private BarrelWoodType wood = BarrelWoodType.ANY;
    private BRecipe currentRecipe;
    private boolean unlabeled;
    private boolean persistent;
    private boolean immutable;
    private boolean stripped;
    private int lastUpdate;
    private boolean needsSave;
    private boolean hasGlint;

    public Brew(BIngredients ingredients) {
        this.ingredients = ingredients;
        this.touch();
    }

    public Brew(int quality, int alc, BRecipe recipe, BIngredients ingredients) {
        this.ingredients = ingredients;
        this.quality = quality;
        this.alc = alc;
        this.currentRecipe = recipe;
        this.touch();
    }

    public Brew(BIngredients ingredients, int quality, int alc, byte distillRuns, float ageTime, BarrelWoodType wood, String recipe, boolean unlabeled, boolean immutable, int lastUpdate) {
        this.ingredients = ingredients;
        this.quality = quality;
        this.alc = alc;
        this.distillRuns = distillRuns;
        this.ageTime = ageTime;
        this.wood = wood;
        this.unlabeled = unlabeled;
        this.immutable = immutable;
        this.lastUpdate = lastUpdate;
        this.setRecipeFromString(recipe);
    }

    private Brew() {
    }

    @Nullable
    public static Brew get(ItemMeta meta) {
        if (!MinecraftVersion.isUseNBT() && !meta.hasLore()) {
            return null;
        }
        Brew brew = Brew.load(meta);
        if (brew == null && meta instanceof PotionMeta && ((PotionMeta)meta).hasCustomEffect(BukkitConstants.REGENERATION)) {
            return Brew.getFromPotionEffect((PotionMeta)meta, false);
        }
        return brew;
    }

    @Nullable
    public static Brew get(ItemStack item) {
        if (item.getType() != Material.POTION) {
            return null;
        }
        if (!item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (!MinecraftVersion.isUseNBT() && !meta.hasLore()) {
            return null;
        }
        Brew brew = Brew.load(meta);
        if (brew == null && meta instanceof PotionMeta && ((PotionMeta)meta).hasCustomEffect(BukkitConstants.REGENERATION)) {
            brew = Brew.getFromPotionEffect((PotionMeta)meta, true);
            if (brew == null) {
                return null;
            }
            new BrewLore(brew, (PotionMeta)meta).removeLegacySpacing();
            brew.save(meta);
            item.setItemMeta(meta);
        } else if (brew != null && brew.needsSave) {
            if (MinecraftVersion.isUseNBT()) {
                new BrewLore(brew, (PotionMeta)meta).removeLoreData();
                Logging.debugLog("removed Data from Lore");
            }
            brew.save(meta);
            item.setItemMeta(meta);
        }
        return brew;
    }

    private static Brew getFromPotionEffect(PotionMeta potionMeta, boolean remove) {
        for (PotionEffect effect : potionMeta.getCustomEffects()) {
            if (!effect.getType().equals(BukkitConstants.REGENERATION) || effect.getDuration() >= -1) continue;
            if (remove) {
                Brew b = legacyPotions.get(effect.getDuration());
                if (b != null) {
                    potionMeta.removeCustomEffect(BukkitConstants.REGENERATION);
                    if (b.persistent) {
                        return b;
                    }
                    return legacyPotions.remove(effect.getDuration());
                }
                return null;
            }
            return legacyPotions.get(effect.getDuration());
        }
        return null;
    }

    @Deprecated
    public static Brew get(int uid) {
        if (uid < -1) {
            if (!legacyPotions.containsKey(uid)) {
                Logging.errorLog("Database failure! unable to find UID " + uid + " of a custom Potion!");
                return null;
            }
        } else {
            return null;
        }
        return legacyPotions.get(uid);
    }

    @Deprecated
    public static int getUID(ItemStack item) {
        return Brew.getUID((PotionMeta)item.getItemMeta());
    }

    @Deprecated
    public static int getUID(PotionMeta potionMeta) {
        if (potionMeta.hasCustomEffect(BukkitConstants.REGENERATION)) {
            for (PotionEffect effect : potionMeta.getCustomEffects()) {
                if (!effect.getType().equals(BukkitConstants.REGENERATION) || effect.getDuration() >= -1) continue;
                return effect.getDuration();
            }
        }
        return 0;
    }

    public boolean setRecipeFromString(String name) {
        this.currentRecipe = null;
        if (name != null && !name.equals("")) {
            for (BRecipe recipe : BRecipe.getAllRecipes()) {
                if (!recipe.getRecipeName().equalsIgnoreCase(name)) continue;
                this.currentRecipe = recipe;
                return true;
            }
            if (this.quality > 0) {
                this.currentRecipe = this.ingredients.getBestRecipe(this.wood, this.ageTime, this.distillRuns > 0);
                if (this.currentRecipe != null) {
                    Logging.log("A Brew was made from Recipe: '" + name + "' which could not be found. '" + this.currentRecipe.getRecipeName() + "' used instead!");
                    return true;
                }
                Logging.errorLog("A Brew was made from Recipe: '" + name + "' which could not be found!");
            }
        }
        return false;
    }

    public boolean reloadRecipe() {
        return this.currentRecipe == null || this.setRecipeFromString(this.currentRecipe.getRecipeName());
    }

    public boolean isSimilar(Brew brew) {
        if (brew == null) {
            return false;
        }
        if (this.equals(brew)) {
            return true;
        }
        return this.quality == brew.quality && this.alc == brew.alc && this.distillRuns == brew.distillRuns && Float.compare(brew.ageTime, this.ageTime) == 0 && brew.wood == this.wood && this.unlabeled == brew.unlabeled && this.persistent == brew.persistent && this.immutable == brew.immutable && this.stripped == brew.stripped && this.ingredients.equals(brew.ingredients) && Objects.equals(this.currentRecipe, brew.currentRecipe);
    }

    public Brew clone() {
        try {
            Brew brew = (Brew)super.clone();
            brew.ingredients = this.ingredients.copy();
            return brew;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public String toString() {
        return "Brew{ingredients=" + String.valueOf(this.ingredients) + ", quality=" + this.quality + ", alc=" + this.alc + ", distillRuns=" + this.distillRuns + ", ageTime=" + this.ageTime + ", wood=" + String.valueOf((Object)this.wood) + ", currentRecipe=" + String.valueOf(this.currentRecipe) + ", unlabeled=" + this.unlabeled + ", immutable=" + this.immutable + ", stripped=" + this.stripped + "}";
    }

    @Contract(pure=true)
    public int calcAlcohol() {
        if (this.quality == 0) {
            int badAlc = 0;
            if (this.distillRuns > 1) {
                badAlc = this.distillRuns;
            }
            if (this.ageTime > 10.0f) {
                badAlc += 5;
            } else if (this.ageTime > 2.0f) {
                badAlc += 3;
            }
            if (this.currentRecipe != null) {
                return badAlc;
            }
            return badAlc / 2;
        }
        if (this.currentRecipe != null) {
            int alc = this.currentRecipe.getAlcohol();
            if (this.currentRecipe.needsDistilling()) {
                if (this.distillRuns == 0) {
                    return 0;
                }
                alc = (int)((float)alc * (1.0f - (float)(10 - this.quality) * 0.04f));
                alc /= 2;
                alc = (int)((float)alc * (1.0f + (float)this.distillRuns / (float)this.currentRecipe.getDistillruns()));
            } else {
                alc = (int)((float)alc * ((float)this.quality / 10.0f));
            }
            return alc;
        }
        return 0;
    }

    @Contract(pure=true)
    public int calcQuality() {
        float quality = this.ingredients.getIngredientQuality(this.currentRecipe) + this.ingredients.getCookingQuality(this.currentRecipe, this.distillRuns > 0);
        if (this.currentRecipe.needsToAge() || (double)this.ageTime > 0.5) {
            quality += (float)(this.ingredients.getWoodQuality(this.currentRecipe, this.wood) + this.ingredients.getAgeQuality(this.currentRecipe, this.ageTime));
            quality /= 4.0f;
        } else {
            quality /= 2.0f;
        }
        return Math.round(quality);
    }

    public boolean canDistill() {
        if (this.immutable) {
            return false;
        }
        if (this.currentRecipe != null) {
            return this.currentRecipe.getDistillruns() > this.distillRuns;
        }
        return this.distillRuns < 6;
    }

    public void updateCustomModelData(ItemMeta meta) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            return;
        }
        if (this.currentRecipe != null && this.currentRecipe.getCmData() != null) {
            int cm = this.quality > 7 ? this.currentRecipe.getCmData()[2] : (this.quality > 3 ? this.currentRecipe.getCmData()[1] : this.currentRecipe.getCmData()[0]);
            if (cm == 0) {
                meta.setCustomModelData(null);
            } else {
                meta.setCustomModelData(Integer.valueOf(cm));
            }
        } else {
            meta.setCustomModelData(null);
        }
    }

    public List<BEffect> getEffects() {
        if (this.currentRecipe != null && this.quality > 0) {
            return this.currentRecipe.getEffects();
        }
        return null;
    }

    public void unLabel(ItemStack item) {
        if (this.unlabeled) {
            return;
        }
        this.unlabeled = true;
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof PotionMeta && meta.hasLore()) {
            BrewLore lore = new BrewLore(this, (PotionMeta)meta);
            if (this.distillRuns > 0) {
                lore.updateDistillLore(false);
            }
            if (this.ageTime >= 1.0f) {
                lore.updateAgeLore(false);
            }
            lore.updateIngredientLore(false);
            lore.updateCookLore(false);
            lore.updateDistillLore(false);
            lore.updateAgeLore(false);
            lore.updateWoodLore(false);
            lore.updateQualityStars(false);
            lore.updateAlc(false);
            lore.write();
            item.setItemMeta(meta);
        }
    }

    public void seal(ItemStack potion, @Nullable Player player) {
        if (this.stripped) {
            return;
        }
        ItemMeta origMeta = potion.getItemMeta();
        if (!(origMeta instanceof PotionMeta)) {
            return;
        }
        if (this.quality == 1) {
            this.quality = 2;
        } else if (this.quality % 2 == 1) {
            --this.quality;
        }
        this.alc = this.calcAlcohol();
        this.setStatic(true, potion);
        this.unLabel(potion);
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        BrewLore lore = new BrewLore(this, meta);
        lore.updateQualityStars(false, true);
        lore.write();
        this.stripped = true;
        this.ingredients = new BIngredients();
        this.ageTime = 0.0f;
        this.wood = BarrelWoodType.NONE;
        this.touch();
        BrewModifyEvent modifyEvent = new BrewModifyEvent(this, (ItemMeta)meta, BrewModifyEvent.Type.SEAL, player);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)modifyEvent);
        if (modifyEvent.isCancelled()) {
            potion.setItemMeta(origMeta);
            return;
        }
        this.save((ItemMeta)meta);
        potion.setItemMeta((ItemMeta)meta);
    }

    public void touch() {
        this.lastUpdate = (int)((double)(System.currentTimeMillis() - installTime) / 3600000.0);
    }

    public int getOrCalcAlc() {
        if (this.alc == 0) {
            this.alc = this.calcAlcohol();
        }
        return this.alc;
    }

    public boolean hasRecipe() {
        return this.currentRecipe != null;
    }

    public boolean isSealed() {
        return this.stripped && this.immutable;
    }

    public boolean isStatic() {
        return this.immutable;
    }

    public void setStatic(boolean immutable, ItemStack potion) {
        if (!immutable && this.isStripped()) {
            throw new IllegalStateException("Cannot make stripped Brews non-static");
        }
        if (BreweryPlugin.getMCVersion().isOrEarlier(MinecraftVersion.V1_9) && this.currentRecipe != null && this.canDistill()) {
            this.currentRecipe.getColor().colorBrew((PotionMeta)potion.getItemMeta(), potion, !immutable);
        }
        this.immutable = immutable;
    }

    public static void distillAll(BrewerInventory inv, Brew[] contents) {
        for (int slot = 0; slot < 3; ++slot) {
            if (contents[slot] == null) continue;
            ItemStack slotItem = inv.getItem(slot);
            PotionMeta potionMeta = (PotionMeta)slotItem.getItemMeta();
            contents[slot].distillSlot(slotItem, potionMeta);
        }
    }

    public void distillSlot(ItemStack slotItem, PotionMeta potionMeta) {
        if (this.immutable) {
            return;
        }
        this.distillRuns = (byte)(this.distillRuns + 1);
        BrewLore lore = new BrewLore(this, potionMeta);
        BestRecipeResult result = this.ingredients.getDistillRecipeFull(this.wood, this.ageTime);
        if (result instanceof BestRecipeResult.Found) {
            BestRecipeResult.Found found = (BestRecipeResult.Found)result;
            this.currentRecipe = found.recipe();
            this.quality = this.calcQuality();
            lore.addOrReplaceEffects(this.getEffects(), this.quality);
            potionMeta.setDisplayName(BUtil.color("&f" + this.currentRecipe.getName(this.quality)));
            this.currentRecipe.getColor().colorBrew(potionMeta, slotItem, this.canDistill());
        } else {
            this.quality = 0;
            lore.removeEffects();
            Logging.debugLog("Distill brew ruined! " + String.valueOf(result));
            if (config.isShowRuinedBrewHints()) {
                BrewDefect defect = result.getWorstDefect();
                assert (defect != null);
                lore.updateDefect(BUtil.choose(defect.getMessages(lang)));
            }
            potionMeta.setDisplayName(BUtil.color("&f" + lang.getEntry("Brew_DistillUndefined", new Object[0])));
            PotionColor.GREY.colorBrew(potionMeta, slotItem, this.canDistill());
        }
        this.alc = this.calcAlcohol();
        this.updateCustomModelData((ItemMeta)potionMeta);
        if (this.currentRecipe != null && config.isColorInBrewer() != BrewLore.hasColorLore(potionMeta)) {
            lore.convertLore(config.isColorInBrewer());
        } else {
            lore.updateQualityStars(config.isColorInBrewer());
            lore.updateCustomLore();
            lore.updateDistillLore(config.isColorInBrewer());
        }
        lore.updateAlc(true);
        lore.write();
        this.touch();
        BrewModifyEvent modifyEvent = new BrewModifyEvent(this, (ItemMeta)potionMeta, BrewModifyEvent.Type.DISTILL);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)modifyEvent);
        if (modifyEvent.isCancelled()) {
            return;
        }
        this.save((ItemMeta)potionMeta);
        slotItem.setItemMeta((ItemMeta)potionMeta);
    }

    public int getDistillTimeNextRun() {
        if (!this.canDistill()) {
            return -1;
        }
        if (this.currentRecipe != null) {
            return this.currentRecipe.getDistillTime();
        }
        BRecipe recipe = this.ingredients.getDistillRecipe(this.wood, this.ageTime);
        if (recipe != null) {
            return recipe.getDistillTime();
        }
        return 0;
    }

    public void age(ItemStack item, float time, BarrelWoodType woodType) {
        if (this.immutable) {
            return;
        }
        PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
        BrewLore lore = new BrewLore(this, potionMeta);
        this.ageTime += time;
        if ((double)this.ageTime > 0.5) {
            this.woodShift(time, woodType);
            BestRecipeResult result = this.ingredients.getAgeRecipeFull(this.wood, this.ageTime, this.distillRuns > 0);
            if (result instanceof BestRecipeResult.Found) {
                BestRecipeResult.Found found = (BestRecipeResult.Found)result;
                this.currentRecipe = found.recipe();
                this.quality = this.calcQuality();
                lore.addOrReplaceEffects(this.getEffects(), this.quality);
                potionMeta.setDisplayName(BUtil.color("&f" + this.currentRecipe.getName(this.quality)));
                this.currentRecipe.getColor().colorBrew(potionMeta, item, this.canDistill());
                if (this.currentRecipe.isGlint()) {
                    potionMeta.addEnchant(Enchantment.MENDING, 1, true);
                    potionMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
            } else {
                this.quality = 0;
                lore.convertLore(false);
                lore.removeEffects();
                Logging.debugLog("Aging brew ruined! " + String.valueOf(result));
                if (config.isShowRuinedBrewHints()) {
                    BrewDefect defect = result.getWorstDefect();
                    assert (defect != null);
                    lore.updateDefect(BUtil.choose(defect.getMessages(lang)));
                }
                this.currentRecipe = null;
                potionMeta.setDisplayName(BUtil.color("&f" + lang.getEntry("Brew_BadPotion", new Object[0])));
                PotionColor.GREY.colorBrew(potionMeta, item, this.canDistill());
            }
        }
        this.alc = this.calcAlcohol();
        this.updateCustomModelData((ItemMeta)potionMeta);
        if (this.currentRecipe != null && config.isColorInBarrels() != BrewLore.hasColorLore(potionMeta)) {
            lore.convertLore(config.isColorInBarrels());
        } else {
            if (this.ageTime >= 1.0f) {
                lore.updateAgeLore(config.isColorInBarrels());
            }
            if ((double)this.ageTime > 0.5) {
                if (config.isColorInBarrels()) {
                    lore.updateWoodLore(true);
                    lore.updateIngredientLore(true);
                    lore.updateCookLore(true);
                }
                lore.updateQualityStars(config.isColorInBarrels());
                lore.updateCustomLore();
                lore.updateAlc(false);
            }
        }
        lore.write();
        this.touch();
        BrewModifyEvent modifyEvent = new BrewModifyEvent(this, (ItemMeta)potionMeta, BrewModifyEvent.Type.AGE);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)modifyEvent);
        if (modifyEvent.isCancelled()) {
            return;
        }
        this.save((ItemMeta)potionMeta);
        item.setItemMeta((ItemMeta)potionMeta);
    }

    public void woodShift(float time, BarrelWoodType to) {
        if (this.immutable || this.wood == to) {
            return;
        }
        if (this.wood == BarrelWoodType.ANY) {
            this.wood = to;
            return;
        }
        if (config.isNewBarrelTypeAlgorithm()) {
            this.woodShiftNew(time, to);
            return;
        }
        int fromIndex = this.wood.getIndex();
        int toIndex = to.getIndex();
        float factor = this.woodShiftFactor();
        if (fromIndex > toIndex) {
            if ((fromIndex -= (int)(time / factor)) < toIndex) {
                this.wood = to;
            }
        } else if ((fromIndex += (int)(time / factor)) > toIndex) {
            this.wood = to;
        }
    }

    private void woodShiftNew(float time, BarrelWoodType to) {
        BarrelWoodType old = this.wood;
        float factor = this.woodShiftFactor();
        float shift = time / factor;
        int steps = (int)(2.0f * shift);
        this.wood = this.wood.stepTowards(to, steps);
        Logging.debugLog(String.format("Shifted wood from %s to %s by %s steps", new Object[]{old, this.wood, steps}));
        Logging.debugLog(String.format("time=%.3f, factor=%.3f, shift=%.3f", Float.valueOf(time), Float.valueOf(factor), Float.valueOf(shift)));
    }

    private float woodShiftFactor() {
        float factor = 1.0f;
        if (this.ageTime > 5.0f) {
            factor = 2.0f;
        }
        if (this.ageTime > 10.0f) {
            factor += this.ageTime / 10.0f;
        }
        return factor;
    }

    public ItemStack createItem() {
        return this.createItem(null, true, null);
    }

    public ItemStack createItem(@Nullable BRecipe recipe) {
        return this.createItem(recipe, true, null);
    }

    public ItemStack createItem(@Nullable BRecipe recipe, @Nullable Player player) {
        return this.createItem(recipe, true, player);
    }

    public ItemStack createItem(@Nullable BRecipe recipe, boolean event) {
        return this.createItem(recipe, true, null);
    }

    @Contract(value="_, false -> !null")
    public ItemStack createItem(@Nullable BRecipe recipe, boolean event, @Nullable Player player) {
        if (recipe == null) {
            recipe = this.getCurrentRecipe();
        }
        if (recipe == null) {
            throw new IllegalArgumentException("Argument recipe can't be null if the brew doesn't have a currentRecipe");
        }
        ItemStack potion = new ItemStack(Material.POTION);
        PotionMeta potionMeta = (PotionMeta)potion.getItemMeta();
        recipe.getColor().colorBrew(potionMeta, potion, false);
        this.updateCustomModelData((ItemMeta)potionMeta);
        if (recipe.isGlint()) {
            potionMeta.addEnchant(Enchantment.MENDING, 1, true);
            potionMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        potionMeta.setDisplayName(BUtil.color("&f" + recipe.getName(this.quality)));
        BrewLore lore = new BrewLore(this, potionMeta);
        lore.convertLore(false);
        lore.addOrReplaceEffects(recipe.getEffects(), this.quality);
        lore.write();
        this.touch();
        if (event) {
            BrewModifyEvent modifyEvent = new BrewModifyEvent(this, (ItemMeta)potionMeta, BrewModifyEvent.Type.CREATE, player);
            BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)modifyEvent);
            if (modifyEvent.isCancelled()) {
                return null;
            }
        }
        this.save((ItemMeta)potionMeta);
        potion.setItemMeta((ItemMeta)potionMeta);
        BreweryPlugin.getInstance().getBreweryStats().metricsForCreate(true);
        return potion;
    }

    public static boolean isBrew(ItemStack item) {
        if (item == null || item.getType() != Material.POTION) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (!MinecraftVersion.isUseNBT() && !meta.hasLore()) {
            return false;
        }
        if (MinecraftVersion.isUseNBT() && NBTLoadStream.hasDataInMeta(meta)) {
            return true;
        }
        if (meta.hasLore()) {
            return BUtil.indexOfStart(meta.getLore(), "\u00a7%") > -1;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Brew load(ItemMeta meta) {
        NBTLoadStream nbtStream;
        InputStream itemLoadStream = null;
        if (MinecraftVersion.isUseNBT() && (nbtStream = new NBTLoadStream(meta)).hasData()) {
            itemLoadStream = nbtStream;
        }
        if (itemLoadStream == null) {
            try {
                itemLoadStream = new Base91DecoderStream(new LoreLoadStream(meta, 0));
            }
            catch (IllegalArgumentException ignored) {
                return null;
            }
        }
        XORUnscrambleStream unscrambler = new XORUnscrambleStream(itemLoadStream, saveSeed, prevSaveSeeds);
        try (DataInputStream in = new DataInputStream(unscrambler);){
            boolean parityFailed = false;
            if (in.readByte() != 86) {
                Logging.errorLog("Parity check failed on Brew while loading, trying to load anyways!");
                parityFailed = true;
            }
            Brew brew = new Brew();
            byte ver = in.readByte();
            switch (ver) {
                case 1: {
                    unscrambler.start();
                    brew.loadFromStream(in, ver);
                    break;
                }
                default: {
                    if (parityFailed) {
                        Logging.errorLog("Failed to load Brew. Maybe something corrupted the Lore of the Item?");
                    } else {
                        Logging.errorLog("Brew has data stored in v" + ver + " this Plugin version supports up to v1");
                    }
                    Brew brew2 = null;
                    return brew2;
                }
            }
            XORUnscrambleStream.SuccessType successType = unscrambler.getSuccessType();
            if (successType == XORUnscrambleStream.SuccessType.PREV_SEED) {
                Logging.debugLog("Converting Brew from previous Seed");
                brew.setNeedsSave(true);
            } else if ((config.isEnableEncode() && !brew.isStripped()) != (successType == XORUnscrambleStream.SuccessType.MAIN_SEED)) {
                Logging.debugLog("Converting Brew to new encode setting");
                brew.setNeedsSave(true);
            } else if (MinecraftVersion.isUseNBT() && itemLoadStream instanceof Base91DecoderStream) {
                Logging.debugLog("Converting Brew to NBT");
                brew.setNeedsSave(true);
            }
            Brew brew3 = brew;
            return brew3;
        }
        catch (IOException e) {
            Logging.errorLog("IO Error while loading Brew", e);
            return null;
        }
        catch (InvalidKeyException e) {
            Logging.errorLog("Failed to load Brew, has the data key 'encodeKey' in the config.yml been changed?", e);
        }
        return null;
    }

    private void loadFromStream(DataInputStream in, byte dataVersion) throws IOException {
        this.quality = in.readByte();
        int bools = in.readUnsignedByte();
        if ((bools & 0x40) != 0) {
            this.alc = in.readShort();
        }
        if ((bools & 1) != 0) {
            this.distillRuns = in.readByte();
        }
        if ((bools & 2) != 0) {
            this.ageTime = in.readFloat();
        }
        if ((bools & 4) != 0) {
            this.wood = BarrelWoodType.fromAny(Float.valueOf(in.readFloat()));
        }
        String recipe = null;
        if ((bools & 8) != 0) {
            recipe = in.readUTF();
        }
        this.unlabeled = (bools & 0x10) != 0;
        this.immutable = (bools & 0x20) != 0;
        this.stripped = (bools & 0x80) != 0;
        this.ingredients = BIngredients.load(in, dataVersion);
        this.setRecipeFromString(recipe);
    }

    public void save(ItemMeta meta) {
        OutputStream itemSaveStream = MinecraftVersion.isUseNBT() ? new NBTSaveStream(meta) : new Base91EncoderStream(new LoreSaveStream(meta, 0));
        XORScrambleStream scrambler = new XORScrambleStream(itemSaveStream, saveSeed);
        try (DataOutputStream out = new DataOutputStream(scrambler);){
            out.writeByte(86);
            out.writeByte(1);
            if (config.isEnableEncode() && !this.isStripped()) {
                scrambler.start();
            } else {
                scrambler.startUnscrambled();
            }
            this.saveToStream(out);
        }
        catch (IOException e) {
            Logging.errorLog("IO Error while saving Brew", e);
        }
    }

    public void save(ItemStack item) {
        ItemMeta meta = !item.hasItemMeta() ? BreweryPlugin.getInstance().getServer().getItemFactory().getItemMeta(item.getType()) : item.getItemMeta();
        this.save(meta);
        item.setItemMeta(meta);
    }

    public void saveToStream(DataOutputStream out) throws IOException {
        if (this.quality > 10) {
            this.quality = 10;
        }
        this.alc = Math.min(this.alc, Short.MAX_VALUE);
        this.alc = Math.max(this.alc, Short.MIN_VALUE);
        out.writeByte((byte)this.quality);
        int bools = 0;
        bools |= this.distillRuns != 0 ? 1 : 0;
        bools |= this.ageTime > 0.0f ? 2 : 0;
        bools |= this.wood != BarrelWoodType.NONE ? 4 : 0;
        bools |= this.currentRecipe != null ? 8 : 0;
        bools |= this.unlabeled ? 16 : 0;
        bools |= this.immutable ? 32 : 0;
        bools |= this.alc != 0 ? 64 : 0;
        out.writeByte(bools |= this.stripped ? 128 : 0);
        if (this.alc != 0) {
            out.writeShort(this.alc);
        }
        if (this.distillRuns != 0) {
            out.writeByte(this.distillRuns);
        }
        if (this.ageTime > 0.0f) {
            out.writeFloat(this.ageTime);
        }
        if (this.wood != BarrelWoodType.NONE) {
            out.writeFloat(this.wood != null ? (float)this.wood.getIndex() : 0.0f);
        }
        if (this.currentRecipe != null) {
            out.writeUTF(this.currentRecipe.getRecipeName());
        }
        this.ingredients.save(out);
    }

    public static void loadSeed(long seed) {
        saveSeed = seed;
        Brew.updatePrevSeeds();
    }

    public static void loadPrevSeeds(ConfigurationSection section) {
        if (section.contains("prevSaveSeeds")) {
            prevSaveSeeds = section.getLongList("prevSaveSeeds");
            Brew.updatePrevSeeds();
        }
    }

    public static void loadPrevSeeds(List<Long> list) {
        prevSaveSeeds = list;
        Brew.updatePrevSeeds();
    }

    private static void updatePrevSeeds() {
        if (!prevSaveSeeds.contains(saveSeed)) {
            prevSaveSeeds.add(saveSeed);
        }
    }

    public static List<Long> getPrevSeeds() {
        return prevSaveSeeds;
    }

    public static boolean noLegacy() {
        return legacyPotions.isEmpty();
    }

    public static void loadLegacy(BIngredients ingredients, int uid, int quality, int alc, byte distillRuns, float ageTime, BarrelWoodType wood, String recipe, boolean unlabeled, boolean persistent, boolean stat, int lastUpdate) {
        Brew brew = new Brew(ingredients, quality, alc, distillRuns, ageTime, wood, recipe, unlabeled, stat, lastUpdate);
        brew.persistent = persistent;
        if (brew.lastUpdate <= 0) {
            brew.touch();
        }
        legacyPotions.put(uid, brew);
    }

    public static void removeLegacy(ItemStack item) {
        if (legacyPotions.isEmpty()) {
            return;
        }
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof PotionMeta)) {
            return;
        }
        Brew.getFromPotionEffect((PotionMeta)meta, true);
    }

    public void convertPre1_9(ItemStack item) {
        Brew.removeLegacy(item);
        PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
        assert (potionMeta != null);
        BrewLore lore = new BrewLore(this, potionMeta);
        lore.removeEffects();
        if (this.hasRecipe()) {
            this.currentRecipe.getColor().colorBrew(potionMeta, item, this.canDistill());
        } else {
            PotionColor.GREY.colorBrew(potionMeta, item, this.canDistill());
        }
        lore.removeLegacySpacing();
        this.save((ItemMeta)potionMeta);
        item.setItemMeta((ItemMeta)potionMeta);
    }

    public void convertPre1_11(ItemStack item) {
        Brew.removeLegacy(item);
        PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
        assert (potionMeta != null);
        potionMeta.setBasePotionType(PotionType.THICK);
        BrewLore lore = new BrewLore(this, potionMeta);
        lore.removeEffects();
        if (this.hasRecipe()) {
            lore.addOrReplaceEffects(this.currentRecipe.getEffects(), this.getQuality());
            this.currentRecipe.getColor().colorBrew(potionMeta, item, this.canDistill());
        } else {
            PotionColor.GREY.colorBrew(potionMeta, item, this.canDistill());
        }
        lore.removeLegacySpacing();
        this.save((ItemMeta)potionMeta);
        item.setItemMeta((ItemMeta)potionMeta);
    }

    public static void saveLegacy(ConfigurationSection config) {
        for (Map.Entry<Integer, Brew> entry : legacyPotions.entrySet()) {
            int uid = entry.getKey();
            Brew brew = entry.getValue();
            ConfigurationSection idConfig = config.createSection("" + uid);
            if (brew.quality != 0) {
                idConfig.set("quality", (Object)brew.quality);
            }
            if (brew.alc != 0) {
                idConfig.set("alc", (Object)brew.alc);
            }
            if (brew.distillRuns != 0) {
                idConfig.set("distillRuns", (Object)brew.distillRuns);
            }
            if (brew.ageTime != 0.0f) {
                idConfig.set("ageTime", (Object)Float.valueOf(brew.ageTime));
            }
            if (brew.wood != BarrelWoodType.NONE) {
                idConfig.set("wood", (Object)brew.wood);
            }
            if (brew.currentRecipe != null) {
                idConfig.set("recipe", (Object)brew.currentRecipe.getRecipeName());
            }
            if (brew.unlabeled) {
                idConfig.set("unlabeled", (Object)true);
            }
            if (brew.persistent) {
                idConfig.set("persist", (Object)true);
            }
            if (brew.immutable) {
                idConfig.set("stat", (Object)true);
            }
            if (brew.lastUpdate > 0) {
                idConfig.set("lastUpdate", (Object)brew.lastUpdate);
            }
            idConfig.set("ingId", (Object)brew.ingredients.saveLegacy(config.getParent()));
        }
    }

    public BIngredients getIngredients() {
        return this.ingredients;
    }

    public int getQuality() {
        return this.quality;
    }

    public int getAlc() {
        return this.alc;
    }

    public byte getDistillRuns() {
        return this.distillRuns;
    }

    public float getAgeTime() {
        return this.ageTime;
    }

    public BarrelWoodType getWood() {
        return this.wood;
    }

    public BRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public boolean isUnlabeled() {
        return this.unlabeled;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isStripped() {
        return this.stripped;
    }

    public int getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean isNeedsSave() {
        return this.needsSave;
    }

    public boolean isHasGlint() {
        return this.hasGlint;
    }

    public void setIngredients(BIngredients ingredients) {
        this.ingredients = ingredients;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void setAlc(int alc) {
        this.alc = alc;
    }

    public void setDistillRuns(byte distillRuns) {
        this.distillRuns = distillRuns;
    }

    public void setAgeTime(float ageTime) {
        this.ageTime = ageTime;
    }

    public void setWood(BarrelWoodType wood) {
        this.wood = wood;
    }

    public void setCurrentRecipe(BRecipe currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    public void setUnlabeled(boolean unlabeled) {
        this.unlabeled = unlabeled;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public void setStripped(boolean stripped) {
        this.stripped = stripped;
    }

    public void setLastUpdate(int lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setNeedsSave(boolean needsSave) {
        this.needsSave = needsSave;
    }

    public void setHasGlint(boolean hasGlint) {
        this.hasGlint = hasGlint;
    }

    static {
        prevSaveSeeds = new ArrayList<Long>();
        legacyPotions = new HashMap<Integer, Brew>();
        installTime = System.currentTimeMillis();
    }
}

