/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.addons;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonConfigFile;
import com.dre.brewery.api.addons.BreweryAddon;
import com.dre.brewery.configuration.ConfigHead;
import com.dre.brewery.configuration.annotation.OkaeriConfigFileOptions;
import com.dre.brewery.depend.okaeri.configs.configurer.Configurer;
import com.dre.brewery.depend.okaeri.configs.serdes.BidirectionalTransformer;
import com.dre.brewery.depend.okaeri.configs.serdes.OkaeriSerdesPack;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class AddonConfigManager {
    private final ConfigHead INSTANCE;

    public AddonConfigManager(BreweryAddon addon) {
        this.INSTANCE = new ConfigHead(BreweryPlugin.getInstance().getDataFolder().toPath().resolve("addons").resolve(addon.getAddonInfo().name()));
    }

    public AddonConfigManager(Path addonDataFolder) {
        this.INSTANCE = new ConfigHead(addonDataFolder);
    }

    public <T extends AddonConfigFile> T getConfig(Class<T> configClass) {
        return (T)((AddonConfigFile)this.INSTANCE.getConfig(configClass));
    }

    public <T extends AddonConfigFile> void newInstance(Class<T> configClass, boolean overwrite) {
        this.INSTANCE.newInstance(configClass, overwrite);
    }

    public <T extends AddonConfigFile> Path getFilePath(Class<T> configClass) {
        return this.INSTANCE.getFilePath(configClass);
    }

    public Collection<AddonConfigFile> getLoadedConfigs() {
        return this.INSTANCE.LOADED_CONFIGS.values().stream().map(AddonConfigFile.class::cast).toList();
    }

    private <T extends AddonConfigFile> T createConfig(Class<T> configClass, Path file, Configurer configurer, OkaeriSerdesPack serdesPack, boolean update, boolean removeOrphans) {
        return (T)((AddonConfigFile)this.INSTANCE.createConfig(configClass, file, configurer, serdesPack, update, removeOrphans));
    }

    public <T extends AddonConfigFile> T createConfig(Class<T> configClass) {
        return (T)((AddonConfigFile)this.INSTANCE.createConfig(configClass));
    }

    @Nullable
    public <T extends AddonConfigFile> T createBlankConfigInstance(Class<T> configClass) {
        return (T)((AddonConfigFile)this.INSTANCE.createBlankConfigInstance(configClass));
    }

    public void addSerdesPacks(OkaeriSerdesPack ... serdesPacks) {
        this.INSTANCE.addSerdesPacks(serdesPacks);
    }

    public void addBiDirectionalTransformers(BidirectionalTransformer<?, ?> ... transformers) {
        this.INSTANCE.addBidirectionalTransformers(transformers);
    }

    public void addConfigurer(Configurer configurer) {
        this.INSTANCE.addConfigurer(configurer);
    }

    public void createFileFromResources(String resourcesPath, Path destination) {
        this.INSTANCE.createFileFromResources(resourcesPath, destination);
    }

    public OkaeriConfigFileOptions getOkaeriConfigFileOptions(Class<? extends AddonConfigFile> configClass) {
        return this.INSTANCE.getOkaeriConfigFileOptions(configClass);
    }

    public Path getDataFolder() {
        return this.INSTANCE.DATA_FOLDER;
    }
}

