/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.BIngredients;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.BestRecipeResult;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.RecipeEvaluation;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DebugInfoCommand
implements SubCommand {
    @Override
    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        this.debugInfo(sender, args.length > 1 ? args[1] : null);
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.debuginfo";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    public void debugInfo(CommandSender sender, String recipeName) {
        if (BreweryPlugin.getMCVersion().isOrEarlier(MinecraftVersion.V1_9) || !sender.isOp()) {
            return;
        }
        Player player = (Player)sender;
        ItemStack hand = player.getInventory().getItemInMainHand();
        if (hand != null) {
            Brew brew = Brew.get(hand);
            if (brew == null) {
                return;
            }
            Logging.log(brew.toString());
            BIngredients ingredients = brew.getIngredients();
            if (recipeName == null) {
                Logging.log("&lIngredients:");
                for (Ingredient ing : ingredients.getIngredientList()) {
                    Logging.log(ing.toString());
                }
                Logging.log("&lTesting Recipes");
                for (BRecipe recipe : BRecipe.getAllRecipes()) {
                    DebugInfoCommand.logRecipe(recipe, brew);
                }
                BestRecipeResult distill = ingredients.getBestRecipeFull(brew.getWood(), brew.getAgeTime(), true);
                Logging.log("&lDistill-Recipe: &r" + ChatColor.stripColor((String)distill.toString()));
                BestRecipeResult nonDistill = ingredients.getBestRecipeFull(brew.getWood(), brew.getAgeTime(), false);
                Logging.log("&lRecipe: &r" + ChatColor.stripColor((String)nonDistill.toString()));
            } else {
                BRecipe recipe = BRecipe.getMatching(recipeName);
                if (recipe == null) {
                    Logging.msg((CommandSender)player, "Could not find Recipe " + recipeName);
                    return;
                }
                Logging.log("&lIngredients in Recipe " + recipe.getRecipeName() + "&r&l:&r");
                for (RecipeItem ri : recipe.getIngredients()) {
                    Logging.log(ri.toString());
                }
                Logging.log("&lIngredients in Brew:");
                for (Ingredient ingredient : ingredients.getIngredientList()) {
                    int amountInRecipe = recipe.amountOf(ingredient);
                    Logging.log(ingredient.toString() + ": " + amountInRecipe + " of this are in the Recipe");
                }
                DebugInfoCommand.logRecipe(recipe, brew);
            }
            Logging.msg((CommandSender)player, "Debug Info for item written into Log");
        }
    }

    private static void logRecipe(BRecipe recipe, Brew brew) {
        BIngredients ingredients = brew.getIngredients();
        RecipeEvaluation ingQ = ingredients.getIngredientQualityFull(recipe);
        Logging.log(String.format("%s&r ingQlty: %s", recipe.getRecipeName(), ingQ));
        RecipeEvaluation cookQ = ingredients.getCookingQualityFull(recipe, false);
        Logging.log(String.format("%s&r cookQlty: %s", recipe.getRecipeName(), cookQ));
        RecipeEvaluation cookDistQ = ingredients.getCookingQualityFull(recipe, true);
        Logging.log(String.format("%s&r cook+DistQlty: %s", recipe.getRecipeName(), cookDistQ));
        RecipeEvaluation ageQ = ingredients.getAgeQualityFull(recipe, brew.getAgeTime());
        Logging.log(String.format("%s&r ageQlty: %s", recipe.getRecipeName(), ageQ));
        RecipeEvaluation woodQ = ingredients.getWoodQualityFull(recipe, brew.getWood());
        Logging.log(String.format("%s&r woodQlty: %s", recipe.getRecipeName(), woodQ));
    }
}

