/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.brew.BrewModifyEvent;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.configuration.files.Lang;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UnLabelCommand
implements SubCommand {
    @Override
    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        Brew brew;
        Player player = (Player)sender;
        ItemStack hand = player.getInventory().getItemInMainHand();
        if (hand.getType() != Material.AIR && (brew = Brew.get(hand)) != null) {
            if (!brew.isUnlabeled()) {
                ItemMeta origMeta = hand.getItemMeta();
                brew.unLabel(hand);
                brew.touch();
                ItemMeta meta = hand.getItemMeta();
                assert (meta != null);
                BrewModifyEvent modifyEvent = new BrewModifyEvent(brew, meta, BrewModifyEvent.Type.UNLABEL);
                BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)modifyEvent);
                if (modifyEvent.isCancelled()) {
                    hand.setItemMeta(origMeta);
                    return;
                }
                brew.save(meta);
                hand.setItemMeta(meta);
                lang.sendEntry(sender, "CMD_UnLabel", new Object[0]);
            } else {
                lang.sendEntry(sender, "Error_AlreadyUnlabeled", new Object[0]);
            }
            return;
        }
        lang.sendEntry(sender, "Error_ItemNotPotion", new Object[0]);
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.unlabel";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }
}

