/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration;

import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.depend.okaeri.configs.OkaeriConfig;
import com.dre.brewery.depend.okaeri.configs.annotation.Exclude;
import com.dre.brewery.depend.okaeri.configs.exception.OkaeriException;
import com.dre.brewery.utility.Logging;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractOkaeriConfigFile
extends OkaeriConfig {
    @Exclude
    protected transient boolean update = false;
    @Exclude
    protected transient boolean firstCreation = false;
    @Exclude
    protected transient boolean blankInstance = false;

    public void reload() {
        if (this.blankInstance) {
            ConfigManager.newInstance(this.getClass(), true);
            return;
        }
        this.bindFileExists(true);
        this.load(this.update);
    }

    public boolean bindFileExists(boolean createIfNotExist) throws IOException {
        if (this.blankInstance) {
            return false;
        }
        boolean b = this.getBindFile().toFile().exists();
        if (!b && createIfNotExist) {
            return this.getBindFile().toFile().createNewFile();
        }
        return b;
    }

    public void saveAsync() throws OkaeriException {
        CompletableFuture.runAsync(this::save);
    }

    public void onFirstCreation() {
        Logging.log("Created a new configurable file: &6" + String.valueOf(this.getBindFile().getFileName()));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{file=" + String.valueOf(this.getBindFile().getFileName()) + ", update=" + this.update + ", firstCreation=" + this.firstCreation + "}";
    }

    public boolean isUpdate() {
        return this.update;
    }

    public boolean isFirstCreation() {
        return this.firstCreation;
    }

    public boolean isBlankInstance() {
        return this.blankInstance;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public void setFirstCreation(boolean firstCreation) {
        this.firstCreation = firstCreation;
    }

    public void setBlankInstance(boolean blankInstance) {
        this.blankInstance = blankInstance;
    }
}

