/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.AbstractOkaeriConfigFile;
import com.dre.brewery.configuration.annotation.OkaeriConfigFileOptions;
import com.dre.brewery.configuration.configurer.BreweryXConfigurer;
import com.dre.brewery.configuration.configurer.TranslationManager;
import com.dre.brewery.depend.okaeri.configs.ConfigManager;
import com.dre.brewery.depend.okaeri.configs.configurer.Configurer;
import com.dre.brewery.depend.okaeri.configs.serdes.BidirectionalTransformer;
import com.dre.brewery.depend.okaeri.configs.serdes.OkaeriSerdesPack;
import com.dre.brewery.depend.okaeri.configs.serdes.standard.StandardSerdes;
import com.dre.brewery.depend.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import com.dre.brewery.utility.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigHead {
    private final Map<Class<? extends Configurer>, Supplier<Configurer>> configurerSupplierMap = new HashMap<Class<YamlSnakeYamlConfigurer>, Supplier<Configurer>>(Map.of(BreweryXConfigurer.class, BreweryXConfigurer::new, YamlSnakeYamlConfigurer.class, YamlSnakeYamlConfigurer::new));
    private final Set<OkaeriSerdesPack> preparedSerdesPacks = new HashSet<OkaeriSerdesPack>();
    private final Set<BidirectionalTransformer<?, ?>> preparedBiDirectionalTransformers = new HashSet();
    public final Map<Class<? extends AbstractOkaeriConfigFile>, AbstractOkaeriConfigFile> LOADED_CONFIGS = new HashMap<Class<? extends AbstractOkaeriConfigFile>, AbstractOkaeriConfigFile>();
    public Path DATA_FOLDER;

    public ConfigHead() {
        this.DATA_FOLDER = BreweryPlugin.getInstance().getDataFolder().toPath();
    }

    public ConfigHead(Path dataFolder) {
        this.DATA_FOLDER = dataFolder;
    }

    @NotNull
    public <T extends Configurer> T getConfigurer(Class<T> configurerClass) {
        if (!this.configurerSupplierMap.containsKey(configurerClass)) {
            Logging.errorLog("Tried to get a Configurer that doesn't exist to this ConfigHead: " + configurerClass.getCanonicalName());
            return (T)this.configurerSupplierMap.get(BreweryXConfigurer.class).get();
        }
        Configurer configurer = this.configurerSupplierMap.get(configurerClass).get();
        for (OkaeriSerdesPack okaeriSerdesPack : this.preparedSerdesPacks) {
            configurer.register(okaeriSerdesPack);
        }
        for (BidirectionalTransformer bidirectionalTransformer : this.preparedBiDirectionalTransformers) {
            configurer.register(registry -> registry.register(transformer));
        }
        return (T)configurer;
    }

    public <T extends AbstractOkaeriConfigFile> T getConfig(Class<T> configClass) {
        try {
            for (Map.Entry<Class<? extends AbstractOkaeriConfigFile>, AbstractOkaeriConfigFile> mapEntry : this.LOADED_CONFIGS.entrySet()) {
                if (!mapEntry.getKey().equals(configClass)) continue;
                return (T)mapEntry.getValue();
            }
            return this.createConfig(configClass);
        }
        catch (Throwable e) {
            Logging.errorLog("Something went wrong trying to load a config file! &e(Class: " + configClass.getSimpleName() + ")", e);
            Logging.warningLog("Resolve the issue in the file and run &6/brewery reload");
            return this.createBlankConfigInstance(configClass);
        }
    }

    public <T extends AbstractOkaeriConfigFile> void newInstance(Class<T> configClass, boolean overwrite) {
        if (!overwrite && this.LOADED_CONFIGS.containsKey(configClass)) {
            return;
        }
        try {
            this.createConfig(configClass);
        }
        catch (Throwable e) {
            Logging.errorLog("Something went wrong trying to load a config file! &e(Class: " + configClass.getSimpleName() + ")", e);
            Logging.warningLog("Resolve the issue in the file and run &6/brewery reload");
            this.createBlankConfigInstance(configClass);
        }
    }

    public <T extends AbstractOkaeriConfigFile> Path getFilePath(Class<T> configClass) {
        OkaeriConfigFileOptions options = this.getOkaeriConfigFileOptions(configClass);
        if (!options.useLangFileName()) {
            return this.DATA_FOLDER.resolve(options.value());
        }
        return this.DATA_FOLDER.resolve("languages/" + TranslationManager.getInstance().getActiveTranslation().fileName());
    }

    public <T extends AbstractOkaeriConfigFile> T createConfig(Class<T> configClass, Path file, Configurer configurer, OkaeriSerdesPack serdesPack, boolean update, boolean removeOrphans) {
        boolean firstCreation = !Files.exists(file, new LinkOption[0]);
        AbstractOkaeriConfigFile instance = (AbstractOkaeriConfigFile)ConfigManager.create(configClass, it -> {
            it.withConfigurer(configurer, serdesPack);
            it.withRemoveOrphans(removeOrphans);
            it.withBindFile(file);
            it.saveDefaults();
            it.load(update);
        });
        instance.setUpdate(update);
        instance.setFirstCreation(firstCreation);
        this.LOADED_CONFIGS.put(configClass, instance);
        return (T)instance;
    }

    public <T extends AbstractOkaeriConfigFile> T createConfig(Class<T> configClass, Path file) {
        OkaeriConfigFileOptions options = this.getOkaeriConfigFileOptions(configClass);
        Configurer configurer = this.getConfigurer(options.configurer());
        return this.createConfig(configClass, file, configurer, new StandardSerdes(), options.update(), options.removeOrphans());
    }

    public <T extends AbstractOkaeriConfigFile> T createConfig(Class<T> configClass) {
        return this.createConfig(configClass, this.getFilePath(configClass));
    }

    @Nullable
    public <T extends AbstractOkaeriConfigFile> T createBlankConfigInstance(Class<T> configClass) {
        try {
            AbstractOkaeriConfigFile inst = (AbstractOkaeriConfigFile)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            inst.setBlankInstance(true);
            this.LOADED_CONFIGS.put(configClass, inst);
            return (T)inst;
        }
        catch (Exception e) {
            Logging.errorLog("Failed to create a blank config instance for " + configClass.getSimpleName(), e);
            return null;
        }
    }

    public void addSerdesPacks(OkaeriSerdesPack ... packs) {
        this.preparedSerdesPacks.addAll(Arrays.asList(packs));
    }

    public void addBidirectionalTransformers(BidirectionalTransformer<?, ?> ... transformers) {
        this.preparedBiDirectionalTransformers.addAll(Arrays.asList(transformers));
    }

    public void addConfigurer(Configurer configurer) {
        this.configurerSupplierMap.put(configurer.getClass(), () -> configurer);
    }

    public void createFileFromResources(String resourcesPath, Path destination) {
        Path targetDir = destination.getParent();
        try {
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
            }
            if (Files.exists(destination, new LinkOption[0])) {
                return;
            }
            try (InputStream inputStream = BreweryPlugin.class.getClassLoader().getResourceAsStream(resourcesPath);){
                if (inputStream != null) {
                    Files.copy(inputStream, destination, new CopyOption[0]);
                } else {
                    Logging.warningLog("Could not find resource file for " + resourcesPath);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating or copying file", e);
        }
    }

    public OkaeriConfigFileOptions getOkaeriConfigFileOptions(final Class<? extends AbstractOkaeriConfigFile> configClass) {
        OkaeriConfigFileOptions options = configClass.getAnnotation(OkaeriConfigFileOptions.class);
        if (options == null) {
            options = new OkaeriConfigFileOptions(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return OkaeriConfigFileOptions.class;
                }

                @Override
                public Class<? extends Configurer> configurer() {
                    return BreweryXConfigurer.class;
                }

                @Override
                public boolean useLangFileName() {
                    return false;
                }

                @Override
                public boolean update() {
                    return false;
                }

                @Override
                public boolean removeOrphans() {
                    return false;
                }

                @Override
                public String value() {
                    return configClass.getSimpleName().toLowerCase() + ".yml";
                }
            };
        }
        return options;
    }

    public Map<Class<? extends Configurer>, Supplier<Configurer>> getConfigurerSupplierMap() {
        return this.configurerSupplierMap;
    }

    public Set<OkaeriSerdesPack> getPreparedSerdesPacks() {
        return this.preparedSerdesPacks;
    }

    public Set<BidirectionalTransformer<?, ?>> getPreparedBiDirectionalTransformers() {
        return this.preparedBiDirectionalTransformers;
    }
}

