/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.configurer;

import com.dre.brewery.configuration.annotation.CommentSpace;
import com.dre.brewery.configuration.annotation.DefaultCommentSpace;
import com.dre.brewery.configuration.annotation.Footer;
import com.dre.brewery.configuration.annotation.LocalizedComment;
import com.dre.brewery.configuration.configurer.TranslationManager;
import com.dre.brewery.configuration.serdes.BreweryXSerdesPack;
import com.dre.brewery.depend.okaeri.configs.postprocessor.ConfigLineInfo;
import com.dre.brewery.depend.okaeri.configs.postprocessor.ConfigPostprocessor;
import com.dre.brewery.depend.okaeri.configs.postprocessor.format.YamlSectionWalker;
import com.dre.brewery.depend.okaeri.configs.schema.ConfigDeclaration;
import com.dre.brewery.depend.okaeri.configs.schema.FieldDeclaration;
import com.dre.brewery.depend.okaeri.configs.schema.GenericsDeclaration;
import com.dre.brewery.depend.okaeri.configs.serdes.SerdesContext;
import com.dre.brewery.depend.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.NonNull;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class BreweryXConfigurer
extends YamlSnakeYamlConfigurer {
    private final Yaml yaml;
    private Map<String, Object> map;
    private String commentPrefix;

    public BreweryXConfigurer(@NonNull Yaml yaml, @NonNull Map<String, Object> map) {
        this.register(new BreweryXSerdesPack());
        this.map = new LinkedHashMap<String, Object>();
        this.commentPrefix = "# ";
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        this.yaml = yaml;
        this.map = map;
    }

    public BreweryXConfigurer(@NonNull Yaml yaml) {
        this.register(new BreweryXSerdesPack());
        this.map = new LinkedHashMap<String, Object>();
        this.commentPrefix = "# ";
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        this.yaml = yaml;
    }

    public BreweryXConfigurer() {
        this(BreweryXConfigurer.createYaml());
    }

    private static Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        Constructor constructor = new Constructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setIndent(2);
        dumperOptions.setWidth(80);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        Representer representer = new Representer(dumperOptions);
        representer.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Resolver resolver = new Resolver();
        return new Yaml((BaseConstructor)constructor, representer, dumperOptions, loaderOptions, resolver);
    }

    private static <T> T apply(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("yml", "yaml");
    }

    @Override
    public void setValue(@NonNull String key, Object value, GenericsDeclaration type, FieldDeclaration field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Object simplified = this.simplify(value, type, SerdesContext.of(this, field), true);
        this.map.put(key, simplified);
    }

    @Override
    public void setValueUnsafe(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.map.put(key, value);
    }

    @Override
    public Object getValue(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.get(key);
    }

    @Override
    public Object remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.remove(key);
    }

    @Override
    public boolean keyExists(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.map.containsKey(key);
    }

    @Override
    public List<String> getAllKeys() {
        return Collections.unmodifiableList(new ArrayList<String>(this.map.keySet()));
    }

    @Override
    public void load(@NonNull InputStream inputStream, @NonNull ConfigDeclaration declaration) throws Exception {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (declaration == null) {
            throw new NullPointerException("declaration is marked non-null but is null");
        }
        this.map = (Map)this.yaml.load(inputStream);
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Object>();
        }
    }

    @Override
    public void write(@NonNull OutputStream outputStream, final @NonNull ConfigDeclaration declaration) throws Exception {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        if (declaration == null) {
            throw new NullPointerException("declaration is marked non-null but is null");
        }
        LinkedHashMap<String, Object> mapCopy = new LinkedHashMap<String, Object>(this.map);
        this.removeNullValues(mapCopy);
        String contents = this.yaml.dump(mapCopy);
        Footer footer = declaration.getType().getAnnotation(Footer.class);
        String[] footerLines = footer != null ? footer.value() : new String[]{};
        ConfigPostprocessor.of(contents).removeLines(line -> line.startsWith(this.commentPrefix.trim())).updateLinesKeys(new YamlSectionWalker(){

            @Override
            public String update(String line, ConfigLineInfo lineInfo, List<ConfigLineInfo> path) {
                int space;
                String[] localizedComment;
                ConfigDeclaration currentDeclaration = declaration;
                for (int i = 0; i < path.size() - 1; ++i) {
                    ConfigLineInfo pathElement = path.get(i);
                    Optional<FieldDeclaration> field = currentDeclaration.getField(pathElement.getName());
                    if (field.isEmpty()) {
                        return line;
                    }
                    GenericsDeclaration fieldType = field.get().getType();
                    if (!fieldType.isConfig()) {
                        return line;
                    }
                    currentDeclaration = ConfigDeclaration.of(fieldType.getType());
                }
                Optional<FieldDeclaration> lineDeclaration = currentDeclaration.getField(lineInfo.getName());
                if (lineDeclaration.isEmpty()) {
                    return line;
                }
                String[] fieldComment = lineDeclaration.get().getComment();
                String[] finalComment = (String[])Stream.of(fieldComment, localizedComment = BreweryXConfigurer.this.getFieldComments(lineDeclaration.get())).filter(Objects::nonNull).flatMap(Arrays::stream).toArray(String[]::new);
                if (finalComment.length == 0) {
                    return line;
                }
                StringBuilder comment = new StringBuilder();
                int n = space = declaration.getType().isAnnotationPresent(DefaultCommentSpace.class) ? declaration.getType().getAnnotation(DefaultCommentSpace.class).value() : 0;
                if (lineDeclaration.get().getField().isAnnotationPresent(CommentSpace.class)) {
                    space = lineDeclaration.get().getField().getAnnotation(CommentSpace.class).value();
                }
                if (space > 0) {
                    comment.append("\n".repeat(space));
                }
                comment.append(ConfigPostprocessor.createComment(BreweryXConfigurer.this.commentPrefix, finalComment));
                return ConfigPostprocessor.addIndent(comment.toString(), lineInfo.getIndent()) + line;
            }
        }).prependContextComment(this.commentPrefix, declaration.getHeader()).appendContextComment(this.commentPrefix, footerLines).write(outputStream);
    }

    @Override
    public YamlSnakeYamlConfigurer setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
        return this;
    }

    public String[] getFieldComments(FieldDeclaration fieldDeclaration) {
        LocalizedComment localizedComment = fieldDeclaration.getField().getAnnotation(LocalizedComment.class);
        if (localizedComment == null || localizedComment.value().length == 0) {
            return null;
        }
        TranslationManager translationManager = TranslationManager.getInstance();
        return (String[])Arrays.stream(localizedComment.value()).map(translationManager::getTranslationWithFallback).filter(Objects::nonNull).flatMap(translation -> Arrays.stream(translation.split("\n"))).toArray(String[]::new);
    }

    public void removeNullValues(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            Object value = entry.getValue();
            if (value == null) {
                iterator.remove();
                continue;
            }
            if (value instanceof Map) {
                this.removeNullValues((Map)value);
                if (!((Map)value).isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (!(value instanceof Collection)) continue;
            this.removeNullValuesFromCollection((Collection)value);
            if (((Collection)value).isEmpty()) {
                iterator.remove();
            }
            if (!(value instanceof List)) continue;
            this.removeNullValuesFromListOfMaps((List)value);
        }
    }

    private void removeNullValuesFromCollection(Collection<?> collection) {
        if (collection == null) {
            return;
        }
        collection.removeIf(Objects::isNull);
    }

    private void removeNullValuesFromListOfMaps(List<?> list) {
        if (list == null) {
            return;
        }
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!(element instanceof Map)) continue;
            this.removeNullValues((Map)element);
            if (!((Map)element).isEmpty()) continue;
            iterator.remove();
        }
    }
}

