/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.configurer;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.ConfigHead;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.configurer.ConfigTranslations;
import com.dre.brewery.configuration.configurer.Translation;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.Logging;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class TranslationManager {
    private static final Translation fallbackTranslation = Translation.EN;
    private static TranslationManager singleton;
    private Translation activeTranslation;
    private final File dataFolder;
    private final ConfigTranslations translations;
    private final ConfigTranslations fallbackTranslations;

    private TranslationManager(File dataFolder) {
        Yaml yaml = new Yaml();
        this.dataFolder = dataFolder;
        this.activeTranslation = Translation.EN;
        try (InputStream inputStream = Files.newInputStream(ConfigManager.getFilePath(Config.class), new OpenOption[0]);){
            Map data = (Map)yaml.loadAs(inputStream, Map.class);
            if (data != null) {
                this.activeTranslation = Translation.getTranslation((String)data.get("language"));
            }
        }
        catch (IOException e) {
            Logging.debugLog("Error reading YAML file: " + e.getMessage());
        }
        File languageFile = new File(dataFolder, "languages/" + this.activeTranslation.fileName());
        if (TranslationManager.class.getResource("/languages/" + this.activeTranslation.fileName()) == null && !languageFile.exists()) {
            Logging.errorLog("Translation could not be found internally or as a file externally: " + this.activeTranslation.fileName());
            Logging.errorLog("You need to either change translation or provide one at: " + String.valueOf(languageFile));
            throw new IllegalStateException("Language file not found: languages/" + this.activeTranslation.fileName());
        }
        this.translations = new ConfigTranslations(this.activeTranslation, yaml);
        this.fallbackTranslations = new ConfigTranslations(fallbackTranslation, yaml);
        for (Translation translation : Translation.getDefaultTranslations()) {
            this.createLanguageFile(translation);
        }
    }

    @Nullable
    public String getTranslationWithFallback(String key) {
        String activeTranslationString = this.translations.getTranslation(key);
        if (activeTranslationString != null) {
            return activeTranslationString;
        }
        String fallbackTranslationString = this.fallbackTranslations.getTranslation(key);
        if (fallbackTranslationString == null) {
            Logging.warningLog("No translation found for key: " + key);
        }
        return fallbackTranslationString;
    }

    public void createLanguageFile(Translation translation) {
        Path languageFile = this.dataFolder.toPath().resolve("languages").resolve(translation.fileName());
        if (!Files.exists(languageFile, new LinkOption[0]) && TranslationManager.class.getResource("/languages/" + translation.fileName()) == null) {
            throw new IllegalStateException("Translation could not be found internally or as a file externally: " + String.valueOf(translation));
        }
        ConfigManager.createFileFromResources("languages/" + translation.fileName(), languageFile);
    }

    public void updateTranslationFiles() {
        ConfigHead tempHead = new ConfigHead();
        Lang fallback = this.loadFromResources(tempHead, Translation.EN);
        for (Translation trans : Translation.getDefaultTranslations()) {
            String langFilePathStr = "languages/" + trans.fileName();
            Path langFilePath = this.dataFolder.toPath().resolve(langFilePathStr);
            Lang langFromFile = tempHead.createConfig(Lang.class, langFilePath);
            Lang langFromResources = this.loadFromResources(tempHead, trans);
            langFromFile.updateMissingValuesFrom(langFromResources);
            if (trans != Translation.EN) {
                langFromFile.updateMissingValuesFrom(fallback);
            }
            langFromFile.save();
        }
    }

    @Nullable
    private Lang loadFromResources(ConfigHead tempHead, Translation translation) {
        Lang lang;
        block9: {
            String langFilePathStr = "languages/" + translation.fileName();
            Path langFilePath = this.dataFolder.toPath().resolve(langFilePathStr);
            InputStream inputStream = BreweryPlugin.class.getResourceAsStream("/" + langFilePathStr);
            try {
                if (inputStream == null || !Files.exists(langFilePath, new LinkOption[0])) {
                    throw new IOException("Lang file not found: " + langFilePathStr);
                }
                Lang langFromResources = tempHead.createConfig(Lang.class, langFilePath);
                langFromResources.load(inputStream);
                lang = langFromResources;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logging.errorLog("Failed to load " + langFilePathStr + " from resources", e);
                    return null;
                }
            }
            inputStream.close();
        }
        return lang;
    }

    public static void newInstance(File dataFolder) {
        TranslationManager.newInstance(dataFolder, false);
    }

    public static void newInstance(File dataFolder, boolean respectAlreadyExisting) {
        if (singleton != null && respectAlreadyExisting) {
            return;
        }
        singleton = new TranslationManager(dataFolder);
    }

    public static TranslationManager getInstance() {
        if (singleton == null) {
            singleton = new TranslationManager(BreweryPlugin.getInstance().getDataFolder());
        }
        return singleton;
    }

    public Translation getActiveTranslation() {
        return this.activeTranslation;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public ConfigTranslations getTranslations() {
        return this.translations;
    }

    public ConfigTranslations getFallbackTranslations() {
        return this.fallbackTranslations;
    }

    public static Translation getFallbackTranslation() {
        return fallbackTranslation;
    }
}

