/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.sector.capsule;

import com.dre.brewery.configuration.annotation.CommentSpace;
import com.dre.brewery.configuration.annotation.LocalizedComment;
import com.dre.brewery.depend.okaeri.configs.OkaeriConfig;
import com.dre.brewery.storage.DataManagerType;

public class ConfiguredDataManager
extends OkaeriConfig {
    @CommentSpace(value=0)
    @LocalizedComment(value={"config.storage.type"})
    private DataManagerType type;
    @CommentSpace(value=0)
    @LocalizedComment(value={"config.storage.database"})
    private String database;
    private String tablePrefix;
    private String address;
    private String username;
    private String password;

    public static ConfiguredDataManagerBuilder builder() {
        return new ConfiguredDataManagerBuilder();
    }

    public DataManagerType getType() {
        return this.type;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getAddress() {
        return this.address;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setType(DataManagerType type) {
        this.type = type;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "ConfiguredDataManager(type=" + String.valueOf((Object)this.getType()) + ", database=" + this.getDatabase() + ", tablePrefix=" + this.getTablePrefix() + ", address=" + this.getAddress() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public ConfiguredDataManager(DataManagerType type, String database, String tablePrefix, String address, String username, String password) {
        this.type = type;
        this.database = database;
        this.tablePrefix = tablePrefix;
        this.address = address;
        this.username = username;
        this.password = password;
    }

    public static class ConfiguredDataManagerBuilder {
        private DataManagerType type;
        private String database;
        private String tablePrefix;
        private String address;
        private String username;
        private String password;

        ConfiguredDataManagerBuilder() {
        }

        public ConfiguredDataManagerBuilder type(DataManagerType type) {
            this.type = type;
            return this;
        }

        public ConfiguredDataManagerBuilder database(String database) {
            this.database = database;
            return this;
        }

        public ConfiguredDataManagerBuilder tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            return this;
        }

        public ConfiguredDataManagerBuilder address(String address) {
            this.address = address;
            return this;
        }

        public ConfiguredDataManagerBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ConfiguredDataManagerBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConfiguredDataManager build() {
            return new ConfiguredDataManager(this.type, this.database, this.tablePrefix, this.address, this.username, this.password);
        }

        public String toString() {
            return "ConfiguredDataManager.ConfiguredDataManagerBuilder(type=" + String.valueOf((Object)this.type) + ", database=" + this.database + ", tablePrefix=" + this.tablePrefix + ", address=" + this.address + ", username=" + this.username + ", password=" + this.password + ")";
        }
    }
}

