/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb;

import com.dre.brewery.depend.bson.UuidRepresentation;
import com.dre.brewery.depend.mongodb.AuthenticationMechanism;
import com.dre.brewery.depend.mongodb.MongoCompressor;
import com.dre.brewery.depend.mongodb.MongoConfigurationException;
import com.dre.brewery.depend.mongodb.MongoCredential;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.ReadConcernLevel;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.Tag;
import com.dre.brewery.depend.mongodb.TagSet;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.annotations.Alpha;
import com.dre.brewery.depend.mongodb.annotations.Reason;
import com.dre.brewery.depend.mongodb.connection.ServerMonitoringMode;
import com.dre.brewery.depend.mongodb.internal.connection.OidcAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.ServerMonitoringModeUtil;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Logger;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Loggers;
import com.dre.brewery.depend.mongodb.internal.dns.DefaultDnsResolver;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import com.dre.brewery.depend.mongodb.spi.dns.DnsClient;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConnectionString {
    private static final String MONGODB_PREFIX = "mongodb://";
    private static final String MONGODB_SRV_PREFIX = "mongodb+srv://";
    private static final Set<String> ALLOWED_OPTIONS_IN_TXT_RECORD = new HashSet<String>(Arrays.asList("authsource", "replicaset", "loadbalanced"));
    private static final Logger LOGGER = Loggers.getLogger("uri");
    private static final List<String> MECHANISM_KEYS_DISALLOWED_IN_CONNECTION_STRING = Stream.of("ALLOWED_HOSTS").map(k -> k.toLowerCase()).collect(Collectors.toList());
    private final MongoCredential credential;
    private final boolean isSrvProtocol;
    private final List<String> hosts;
    private final String database;
    private final String collection;
    private final String connectionString;
    private Integer srvMaxHosts;
    private String srvServiceName;
    private Boolean directConnection;
    private Boolean loadBalanced;
    private ReadPreference readPreference;
    private WriteConcern writeConcern;
    private Boolean retryWrites;
    private Boolean retryReads;
    private ReadConcern readConcern;
    private Integer minConnectionPoolSize;
    private Integer maxConnectionPoolSize;
    private Integer maxWaitTime;
    private Integer maxConnectionIdleTime;
    private Integer maxConnectionLifeTime;
    private Integer maxConnecting;
    private Integer connectTimeout;
    private Long timeout;
    private Integer socketTimeout;
    private Boolean sslEnabled;
    private Boolean sslInvalidHostnameAllowed;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String requiredReplicaSetName;
    private Integer serverSelectionTimeout;
    private Integer localThreshold;
    private Integer heartbeatFrequency;
    private ServerMonitoringMode serverMonitoringMode;
    private String applicationName;
    private List<MongoCompressor> compressorList;
    private UuidRepresentation uuidRepresentation;
    private static final Set<String> GENERAL_OPTIONS_KEYS = new LinkedHashSet<String>();
    private static final Set<String> AUTH_KEYS = new HashSet<String>();
    private static final Set<String> READ_PREFERENCE_KEYS = new HashSet<String>();
    private static final Set<String> WRITE_CONCERN_KEYS = new HashSet<String>();
    private static final Set<String> COMPRESSOR_KEYS = new HashSet<String>();
    private static final Set<String> ALL_KEYS = new HashSet<String>();
    private static final Set<String> DEPRECATED_TIMEOUT_KEYS = new HashSet<String>();
    private static final Set<String> TRUE_VALUES;
    private static final Set<String> FALSE_VALUES;

    public ConnectionString(String connectionString) {
        this(connectionString, null);
    }

    public ConnectionString(String connectionString, @Nullable DnsClient dnsClient) {
        String nsPart;
        String hostIdentifier;
        String userAndHostInformation;
        this.connectionString = connectionString;
        boolean isMongoDBProtocol = connectionString.startsWith(MONGODB_PREFIX);
        this.isSrvProtocol = connectionString.startsWith(MONGODB_SRV_PREFIX);
        if (!isMongoDBProtocol && !this.isSrvProtocol) {
            throw new IllegalArgumentException(String.format("The connection string is invalid. Connection strings must start with either '%s' or '%s", MONGODB_PREFIX, MONGODB_SRV_PREFIX));
        }
        String unprocessedConnectionString = isMongoDBProtocol ? connectionString.substring(MONGODB_PREFIX.length()) : connectionString.substring(MONGODB_SRV_PREFIX.length());
        int firstForwardSlashIdx = unprocessedConnectionString.indexOf("/");
        int firstQuestionMarkIdx = unprocessedConnectionString.indexOf("?");
        if (firstQuestionMarkIdx == -1 && firstForwardSlashIdx == -1) {
            userAndHostInformation = unprocessedConnectionString;
            unprocessedConnectionString = "";
        } else if (firstQuestionMarkIdx != -1 && (firstForwardSlashIdx == -1 || firstQuestionMarkIdx < firstForwardSlashIdx)) {
            userAndHostInformation = unprocessedConnectionString.substring(0, firstQuestionMarkIdx);
            unprocessedConnectionString = unprocessedConnectionString.substring(firstQuestionMarkIdx);
        } else {
            userAndHostInformation = unprocessedConnectionString.substring(0, firstForwardSlashIdx);
            unprocessedConnectionString = unprocessedConnectionString.substring(firstForwardSlashIdx + 1);
        }
        String userName = null;
        char[] password = null;
        int idx = userAndHostInformation.lastIndexOf("@");
        if (idx > 0) {
            String userInfo = userAndHostInformation.substring(0, idx).replace("+", "%2B");
            hostIdentifier = userAndHostInformation.substring(idx + 1);
            int colonCount = this.countOccurrences(userInfo, ":");
            if (userInfo.contains("@") || colonCount > 1) {
                throw new IllegalArgumentException("The connection string contains invalid user information. If the username or password contains a colon (:) or an at-sign (@) then it must be urlencoded");
            }
            if (colonCount == 0) {
                userName = this.urldecode(userInfo);
            } else {
                idx = userInfo.indexOf(":");
                if (idx == 0) {
                    throw new IllegalArgumentException("No username is provided in the connection string");
                }
                userName = this.urldecode(userInfo.substring(0, idx));
                password = this.urldecode(userInfo.substring(idx + 1), true).toCharArray();
            }
        } else {
            if (idx == 0) {
                throw new IllegalArgumentException("The connection string contains an at-sign (@) without a user name");
            }
            hostIdentifier = userAndHostInformation;
        }
        List<String> unresolvedHosts = Collections.unmodifiableList(this.parseHosts(Arrays.asList(hostIdentifier.split(","))));
        if (this.isSrvProtocol) {
            if (unresolvedHosts.size() > 1) {
                throw new IllegalArgumentException("Only one host allowed when using mongodb+srv protocol");
            }
            if (unresolvedHosts.get(0).contains(":")) {
                throw new IllegalArgumentException("Host for when using mongodb+srv protocol can not contain a port");
            }
        }
        this.hosts = unresolvedHosts;
        idx = unprocessedConnectionString.indexOf("?");
        if (idx == -1) {
            nsPart = unprocessedConnectionString;
            unprocessedConnectionString = "";
        } else {
            nsPart = unprocessedConnectionString.substring(0, idx);
            unprocessedConnectionString = unprocessedConnectionString.substring(idx + 1);
        }
        if (nsPart.length() > 0) {
            idx = (nsPart = this.urldecode(nsPart)).indexOf(".");
            if (idx < 0) {
                this.database = nsPart;
                this.collection = null;
            } else {
                this.database = nsPart.substring(0, idx);
                this.collection = nsPart.substring(idx + 1);
            }
            MongoNamespace.checkDatabaseNameValidity(this.database);
        } else {
            this.database = null;
            this.collection = null;
        }
        String txtRecordsQueryParameters = this.isSrvProtocol ? new DefaultDnsResolver(dnsClient).resolveAdditionalQueryParametersFromTxtRecords(unresolvedHosts.get(0)) : "";
        String connectionStringQueryParameters = unprocessedConnectionString;
        Map<String, List<String>> connectionStringOptionsMap = this.parseOptions(connectionStringQueryParameters);
        Map<String, List<String>> txtRecordsOptionsMap = this.parseOptions(txtRecordsQueryParameters);
        if (!ALLOWED_OPTIONS_IN_TXT_RECORD.containsAll(txtRecordsOptionsMap.keySet())) {
            throw new MongoConfigurationException(String.format("A TXT record is only permitted to contain the keys %s, but the TXT record for '%s' contains the keys %s", ALLOWED_OPTIONS_IN_TXT_RECORD, unresolvedHosts.get(0), txtRecordsOptionsMap.keySet()));
        }
        Map<String, List<String>> combinedOptionsMaps = this.combineOptionsMaps(txtRecordsOptionsMap, connectionStringOptionsMap);
        if (this.isSrvProtocol && !combinedOptionsMaps.containsKey("tls") && !combinedOptionsMaps.containsKey("ssl")) {
            combinedOptionsMaps.put("tls", Collections.singletonList("true"));
        }
        this.translateOptions(combinedOptionsMaps);
        if (!this.isSrvProtocol && this.srvMaxHosts != null) {
            throw new IllegalArgumentException("srvMaxHosts can only be specified with mongodb+srv protocol");
        }
        if (!this.isSrvProtocol && this.srvServiceName != null) {
            throw new IllegalArgumentException("srvServiceName can only be specified with mongodb+srv protocol");
        }
        if (this.directConnection != null && this.directConnection.booleanValue()) {
            if (this.isSrvProtocol) {
                throw new IllegalArgumentException("Direct connections are not supported when using mongodb+srv protocol");
            }
            if (this.hosts.size() > 1) {
                throw new IllegalArgumentException("Direct connections are not supported when using multiple hosts");
            }
        }
        if (this.loadBalanced != null && this.loadBalanced.booleanValue()) {
            if (this.directConnection != null && this.directConnection.booleanValue()) {
                throw new IllegalArgumentException("directConnection=true can not be specified with loadBalanced=true");
            }
            if (this.requiredReplicaSetName != null) {
                throw new IllegalArgumentException("replicaSet can not be specified with loadBalanced=true");
            }
            if (this.hosts.size() > 1) {
                throw new IllegalArgumentException("Only one host can be specified with loadBalanced=true");
            }
            if (this.srvMaxHosts != null && this.srvMaxHosts > 0) {
                throw new IllegalArgumentException("srvMaxHosts can not be specified with loadBalanced=true");
            }
        }
        if (this.requiredReplicaSetName != null && this.srvMaxHosts != null && this.srvMaxHosts > 0) {
            throw new IllegalArgumentException("srvMaxHosts can not be specified with replica set name");
        }
        this.validateProxyParameters();
        this.credential = this.createCredentials(combinedOptionsMaps, userName, password);
        this.warnOnUnsupportedOptions(combinedOptionsMaps);
        this.warnDeprecatedTimeouts(combinedOptionsMaps);
    }

    private Map<String, List<String>> combineOptionsMaps(Map<String, List<String>> txtRecordsOptionsMap, Map<String, List<String>> connectionStringOptionsMap) {
        HashMap<String, List<String>> combinedOptionsMaps = new HashMap<String, List<String>>(txtRecordsOptionsMap);
        combinedOptionsMaps.putAll(connectionStringOptionsMap);
        return combinedOptionsMaps;
    }

    private void warnOnUnsupportedOptions(Map<String, List<String>> optionsMap) {
        if (LOGGER.isWarnEnabled()) {
            optionsMap.keySet().stream().filter(k -> !ALL_KEYS.contains(k)).forEach(k -> LOGGER.warn(String.format("Connection string contains unsupported option '%s'.", k)));
        }
    }

    private void warnDeprecatedTimeouts(Map<String, List<String>> optionsMap) {
        if (LOGGER.isWarnEnabled()) {
            optionsMap.keySet().stream().filter(DEPRECATED_TIMEOUT_KEYS::contains).forEach(k -> LOGGER.warn(String.format("Use of deprecated timeout option: '%s'. Prefer 'timeoutMS' instead.", k)));
        }
    }

    private void translateOptions(Map<String, List<String>> optionsMap) {
        boolean tlsInsecureSet = false;
        boolean tlsAllowInvalidHostnamesSet = false;
        for (String key : GENERAL_OPTIONS_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            switch (key) {
                case "maxpoolsize": {
                    this.maxConnectionPoolSize = this.parseInteger(value, "maxpoolsize");
                    break;
                }
                case "minpoolsize": {
                    this.minConnectionPoolSize = this.parseInteger(value, "minpoolsize");
                    break;
                }
                case "maxidletimems": {
                    this.maxConnectionIdleTime = this.parseInteger(value, "maxidletimems");
                    break;
                }
                case "maxlifetimems": {
                    this.maxConnectionLifeTime = this.parseInteger(value, "maxlifetimems");
                    break;
                }
                case "maxconnecting": {
                    this.maxConnecting = this.parseInteger(value, "maxConnecting");
                    break;
                }
                case "waitqueuetimeoutms": {
                    this.maxWaitTime = this.parseInteger(value, "waitqueuetimeoutms");
                    break;
                }
                case "connecttimeoutms": {
                    this.connectTimeout = this.parseInteger(value, "connecttimeoutms");
                    break;
                }
                case "sockettimeoutms": {
                    this.socketTimeout = this.parseInteger(value, "sockettimeoutms");
                    break;
                }
                case "timeoutms": {
                    this.timeout = this.parseLong(value, "timeoutms");
                    break;
                }
                case "proxyhost": {
                    this.proxyHost = value;
                    break;
                }
                case "proxyport": {
                    this.proxyPort = this.parseInteger(value, "proxyPort");
                    break;
                }
                case "proxyusername": {
                    this.proxyUsername = value;
                    break;
                }
                case "proxypassword": {
                    this.proxyPassword = value;
                    break;
                }
                case "tlsallowinvalidhostnames": {
                    this.sslInvalidHostnameAllowed = this.parseBoolean(value, "tlsAllowInvalidHostnames");
                    tlsAllowInvalidHostnamesSet = true;
                    break;
                }
                case "sslinvalidhostnameallowed": {
                    this.sslInvalidHostnameAllowed = this.parseBoolean(value, "sslinvalidhostnameallowed");
                    tlsAllowInvalidHostnamesSet = true;
                    break;
                }
                case "tlsinsecure": {
                    this.sslInvalidHostnameAllowed = this.parseBoolean(value, "tlsinsecure");
                    tlsInsecureSet = true;
                    break;
                }
                case "ssl": {
                    this.initializeSslEnabled("ssl", value);
                    break;
                }
                case "tls": {
                    this.initializeSslEnabled("tls", value);
                    break;
                }
                case "replicaset": {
                    this.requiredReplicaSetName = value;
                    break;
                }
                case "readconcernlevel": {
                    this.readConcern = new ReadConcern(ReadConcernLevel.fromString(value));
                    break;
                }
                case "serverselectiontimeoutms": {
                    this.serverSelectionTimeout = this.parseInteger(value, "serverselectiontimeoutms");
                    break;
                }
                case "localthresholdms": {
                    this.localThreshold = this.parseInteger(value, "localthresholdms");
                    break;
                }
                case "heartbeatfrequencyms": {
                    this.heartbeatFrequency = this.parseInteger(value, "heartbeatfrequencyms");
                    break;
                }
                case "servermonitoringmode": {
                    this.serverMonitoringMode = ServerMonitoringModeUtil.fromString(value);
                    break;
                }
                case "appname": {
                    this.applicationName = value;
                    break;
                }
                case "retrywrites": {
                    this.retryWrites = this.parseBoolean(value, "retrywrites");
                    break;
                }
                case "retryreads": {
                    this.retryReads = this.parseBoolean(value, "retryreads");
                    break;
                }
                case "uuidrepresentation": {
                    this.uuidRepresentation = this.createUuidRepresentation(value);
                    break;
                }
                case "directconnection": {
                    this.directConnection = this.parseBoolean(value, "directconnection");
                    break;
                }
                case "loadbalanced": {
                    this.loadBalanced = this.parseBoolean(value, "loadbalanced");
                    break;
                }
                case "srvmaxhosts": {
                    this.srvMaxHosts = this.parseInteger(value, "srvmaxhosts");
                    if (this.srvMaxHosts >= 0) break;
                    throw new IllegalArgumentException("srvMaxHosts must be >= 0");
                }
                case "srvservicename": {
                    this.srvServiceName = value;
                    break;
                }
            }
        }
        if (tlsInsecureSet && tlsAllowInvalidHostnamesSet) {
            throw new IllegalArgumentException("tlsAllowInvalidHostnames or sslInvalidHostnameAllowed set along with tlsInsecure is not allowed");
        }
        this.writeConcern = this.createWriteConcern(optionsMap);
        this.readPreference = this.createReadPreference(optionsMap);
        this.compressorList = this.createCompressors(optionsMap);
    }

    private void initializeSslEnabled(String key, String value) {
        Boolean booleanValue = this.parseBoolean(value, key);
        if (this.sslEnabled != null && !this.sslEnabled.equals(booleanValue)) {
            throw new IllegalArgumentException("Conflicting tls and ssl parameter values are not allowed");
        }
        this.sslEnabled = booleanValue;
    }

    private List<MongoCompressor> createCompressors(Map<String, List<String>> optionsMap) {
        String compressors = "";
        Integer zlibCompressionLevel = null;
        for (String key : COMPRESSOR_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            if (key.equals("compressors")) {
                compressors = value;
                continue;
            }
            if (!key.equals("zlibcompressionlevel")) continue;
            zlibCompressionLevel = Integer.parseInt(value);
        }
        return this.buildCompressors(compressors, zlibCompressionLevel);
    }

    private List<MongoCompressor> buildCompressors(String compressors, @Nullable Integer zlibCompressionLevel) {
        ArrayList<MongoCompressor> compressorsList = new ArrayList<MongoCompressor>();
        for (String cur : compressors.split(",")) {
            if (cur.equals("zlib")) {
                MongoCompressor zlibCompressor = MongoCompressor.createZlibCompressor();
                if (zlibCompressionLevel != null) {
                    zlibCompressor = zlibCompressor.withProperty("LEVEL", zlibCompressionLevel);
                }
                compressorsList.add(zlibCompressor);
                continue;
            }
            if (cur.equals("snappy")) {
                compressorsList.add(MongoCompressor.createSnappyCompressor());
                continue;
            }
            if (cur.equals("zstd")) {
                compressorsList.add(MongoCompressor.createZstdCompressor());
                continue;
            }
            if (cur.isEmpty()) continue;
            throw new IllegalArgumentException("Unsupported compressor '" + cur + "'");
        }
        return Collections.unmodifiableList(compressorsList);
    }

    @Nullable
    private WriteConcern createWriteConcern(Map<String, List<String>> optionsMap) {
        String w = null;
        Integer wTimeout = null;
        Boolean safe = null;
        Boolean journal = null;
        for (String key : WRITE_CONCERN_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            switch (key) {
                case "safe": {
                    safe = this.parseBoolean(value, "safe");
                    break;
                }
                case "w": {
                    w = value;
                    break;
                }
                case "wtimeoutms": {
                    wTimeout = Integer.parseInt(value);
                    break;
                }
                case "journal": {
                    journal = this.parseBoolean(value, "journal");
                    break;
                }
            }
        }
        return this.buildWriteConcern(safe, w, wTimeout, journal);
    }

    @Nullable
    private ReadPreference createReadPreference(Map<String, List<String>> optionsMap) {
        String readPreferenceType = null;
        ArrayList<TagSet> tagSetList = new ArrayList<TagSet>();
        long maxStalenessSeconds = -1L;
        block10: for (String key : READ_PREFERENCE_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            switch (key) {
                case "readpreference": {
                    readPreferenceType = value;
                    break;
                }
                case "maxstalenessseconds": {
                    maxStalenessSeconds = this.parseInteger(value, "maxstalenessseconds");
                    break;
                }
                case "readpreferencetags": {
                    for (String cur : optionsMap.get(key)) {
                        TagSet tagSet = this.getTags(cur.trim());
                        tagSetList.add(tagSet);
                    }
                    continue block10;
                }
            }
        }
        return this.buildReadPreference(readPreferenceType, tagSetList, maxStalenessSeconds);
    }

    private UuidRepresentation createUuidRepresentation(String value) {
        if (value.equalsIgnoreCase("unspecified")) {
            return UuidRepresentation.UNSPECIFIED;
        }
        if (value.equalsIgnoreCase("javaLegacy")) {
            return UuidRepresentation.JAVA_LEGACY;
        }
        if (value.equalsIgnoreCase("csharpLegacy")) {
            return UuidRepresentation.C_SHARP_LEGACY;
        }
        if (value.equalsIgnoreCase("pythonLegacy")) {
            return UuidRepresentation.PYTHON_LEGACY;
        }
        if (value.equalsIgnoreCase("standard")) {
            return UuidRepresentation.STANDARD;
        }
        throw new IllegalArgumentException("Unknown uuid representation: " + value);
    }

    @Nullable
    private MongoCredential createCredentials(Map<String, List<String>> optionsMap, @Nullable String userName, @Nullable char[] password) {
        AuthenticationMechanism mechanism = null;
        String authSource = null;
        String gssapiServiceName = null;
        String authMechanismProperties = null;
        for (String key : AUTH_KEYS) {
            String value = this.getLastValue(optionsMap, key);
            if (value == null) continue;
            switch (key) {
                case "authmechanism": {
                    if (value.equals("MONGODB-CR")) {
                        if (userName == null) {
                            throw new IllegalArgumentException("username can not be null");
                        }
                        LOGGER.warn("Deprecated MONGDOB-CR authentication mechanism used in connection string");
                        break;
                    }
                    mechanism = AuthenticationMechanism.fromMechanismName(value);
                    break;
                }
                case "authsource": {
                    if (value.equals("")) {
                        throw new IllegalArgumentException("authSource can not be an empty string");
                    }
                    authSource = value;
                    break;
                }
                case "gssapiservicename": {
                    gssapiServiceName = value;
                    break;
                }
                case "authmechanismproperties": {
                    authMechanismProperties = value;
                    break;
                }
            }
        }
        MongoCredential credential = null;
        if (mechanism != null) {
            credential = this.createMongoCredentialWithMechanism(mechanism, userName, password, authSource, gssapiServiceName);
        } else if (userName != null) {
            credential = MongoCredential.createCredential(userName, this.getAuthSourceOrDefault(authSource, this.database != null ? this.database : "admin"), password);
        }
        if (credential != null && authMechanismProperties != null) {
            for (String part : authMechanismProperties.split(",")) {
                String[] mechanismPropertyKeyValue = part.split(":", 2);
                if (mechanismPropertyKeyValue.length != 2) {
                    throw new IllegalArgumentException(String.format("The connection string contains invalid authentication properties. '%s' is not a key value pair", part));
                }
                String key = mechanismPropertyKeyValue[0].trim().toLowerCase();
                String value = mechanismPropertyKeyValue[1].trim();
                if (MECHANISM_KEYS_DISALLOWED_IN_CONNECTION_STRING.contains(key)) {
                    throw new IllegalArgumentException(String.format("The connection string contains disallowed mechanism properties. '%s' must be set on the credential programmatically.", key));
                }
                credential = key.equals("canonicalize_host_name") ? credential.withMechanismProperty(key, Boolean.valueOf(value)) : credential.withMechanismProperty(key, value);
            }
        }
        return credential;
    }

    private MongoCredential createMongoCredentialWithMechanism(AuthenticationMechanism mechanism, String userName, @Nullable char[] password, @Nullable String authSource, @Nullable String gssapiServiceName) {
        MongoCredential credential;
        String mechanismAuthSource;
        switch (mechanism) {
            case PLAIN: {
                mechanismAuthSource = this.getAuthSourceOrDefault(authSource, this.database != null ? this.database : "$external");
                break;
            }
            case GSSAPI: 
            case MONGODB_X509: {
                mechanismAuthSource = this.getAuthSourceOrDefault(authSource, "$external");
                if (mechanismAuthSource.equals("$external")) break;
                throw new IllegalArgumentException(String.format("Invalid authSource for %s, it must be '$external'", new Object[]{mechanism}));
            }
            default: {
                mechanismAuthSource = this.getAuthSourceOrDefault(authSource, this.database != null ? this.database : "admin");
            }
        }
        switch (mechanism) {
            case GSSAPI: {
                credential = MongoCredential.createGSSAPICredential(userName);
                if (gssapiServiceName != null) {
                    credential = credential.withMechanismProperty("SERVICE_NAME", gssapiServiceName);
                }
                if (password == null || !LOGGER.isWarnEnabled()) break;
                LOGGER.warn("Password in connection string not used with MONGODB_X509 authentication mechanism.");
                break;
            }
            case PLAIN: {
                credential = MongoCredential.createPlainCredential(userName, mechanismAuthSource, password);
                break;
            }
            case MONGODB_X509: {
                if (password != null) {
                    throw new IllegalArgumentException("Invalid mechanism, MONGODB_x509 does not support passwords");
                }
                credential = MongoCredential.createMongoX509Credential(userName);
                break;
            }
            case SCRAM_SHA_1: {
                credential = MongoCredential.createScramSha1Credential(userName, mechanismAuthSource, password);
                break;
            }
            case SCRAM_SHA_256: {
                credential = MongoCredential.createScramSha256Credential(userName, mechanismAuthSource, password);
                break;
            }
            case MONGODB_AWS: {
                credential = MongoCredential.createAwsCredential(userName, password);
                break;
            }
            case MONGODB_OIDC: {
                OidcAuthenticator.OidcValidator.validateCreateOidcCredential(password);
                credential = MongoCredential.createOidcCredential(userName);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The connection string contains an invalid authentication mechanism'. '%s' is not a supported authentication mechanism", new Object[]{mechanism}));
            }
        }
        return credential;
    }

    private String getAuthSourceOrDefault(@Nullable String authSource, String defaultAuthSource) {
        if (authSource != null) {
            return authSource;
        }
        return defaultAuthSource;
    }

    @Nullable
    private String getLastValue(Map<String, List<String>> optionsMap, String key) {
        List<String> valueList = optionsMap.get(key);
        if (valueList == null) {
            return null;
        }
        return valueList.get(valueList.size() - 1);
    }

    private Map<String, List<String>> parseOptions(String optionsPart) {
        HashMap<String, List<String>> optionsMap = new HashMap<String, List<String>>();
        if (optionsPart.isEmpty()) {
            return optionsMap;
        }
        for (String part : optionsPart.split("&|;")) {
            if (part.isEmpty()) continue;
            int idx = part.indexOf("=");
            if (idx >= 0) {
                String key = part.substring(0, idx).toLowerCase();
                String value = part.substring(idx + 1);
                ArrayList<String> valueList = (ArrayList<String>)optionsMap.get(key);
                if (valueList == null) {
                    valueList = new ArrayList<String>(1);
                }
                valueList.add(this.urldecode(value));
                optionsMap.put(key, valueList);
                continue;
            }
            throw new IllegalArgumentException(String.format("The connection string contains an invalid option '%s'. '%s' is missing the value delimiter eg '%s=value'", optionsPart, part, part));
        }
        if (optionsMap.containsKey("wtimeout") && !optionsMap.containsKey("wtimeoutms")) {
            optionsMap.put("wtimeoutms", (List)optionsMap.remove("wtimeout"));
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Uri option 'wtimeout' has been deprecated, use 'wtimeoutms' instead.");
            }
        }
        if (optionsMap.containsKey("j") && !optionsMap.containsKey("journal")) {
            optionsMap.put("journal", (List)optionsMap.remove("j"));
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Uri option 'j' has been deprecated, use 'journal' instead.");
            }
        }
        return optionsMap;
    }

    @Nullable
    private ReadPreference buildReadPreference(@Nullable String readPreferenceType, List<TagSet> tagSetList, long maxStalenessSeconds) {
        if (readPreferenceType != null) {
            if (tagSetList.isEmpty() && maxStalenessSeconds == -1L) {
                return ReadPreference.valueOf(readPreferenceType);
            }
            if (maxStalenessSeconds == -1L) {
                return ReadPreference.valueOf(readPreferenceType, tagSetList);
            }
            return ReadPreference.valueOf(readPreferenceType, tagSetList, maxStalenessSeconds, TimeUnit.SECONDS);
        }
        if (!tagSetList.isEmpty() || maxStalenessSeconds != -1L) {
            throw new IllegalArgumentException("Read preference mode must be specified if either read preference tags or max staleness is specified");
        }
        return null;
    }

    @Nullable
    private WriteConcern buildWriteConcern(@Nullable Boolean safe, @Nullable String w, @Nullable Integer wTimeout, @Nullable Boolean journal) {
        WriteConcern retVal = null;
        if (w != null || wTimeout != null || journal != null) {
            if (w == null) {
                retVal = WriteConcern.ACKNOWLEDGED;
            } else {
                try {
                    retVal = new WriteConcern(Integer.parseInt(w));
                }
                catch (NumberFormatException e) {
                    retVal = new WriteConcern(w);
                }
            }
            if (wTimeout != null) {
                retVal = retVal.withWTimeout(wTimeout.intValue(), TimeUnit.MILLISECONDS);
            }
            if (journal != null) {
                retVal = retVal.withJournal(journal);
            }
            return retVal;
        }
        if (safe != null) {
            retVal = safe != false ? WriteConcern.ACKNOWLEDGED : WriteConcern.UNACKNOWLEDGED;
        }
        return retVal;
    }

    private TagSet getTags(String tagSetString) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        if (tagSetString.length() > 0) {
            for (String tag : tagSetString.split(",")) {
                String[] tagKeyValuePair = tag.split(":");
                if (tagKeyValuePair.length != 2) {
                    throw new IllegalArgumentException(String.format("The connection string contains an invalid read preference tag. '%s' is not a key value pair", tagSetString));
                }
                tagList.add(new Tag(tagKeyValuePair[0].trim(), tagKeyValuePair[1].trim()));
            }
        }
        return new TagSet(tagList);
    }

    @Nullable
    private Boolean parseBoolean(String input, String key) {
        String trimmedInput = input.trim().toLowerCase();
        if (TRUE_VALUES.contains(trimmedInput)) {
            if (!trimmedInput.equals("true")) {
                LOGGER.warn(String.format("Deprecated boolean value '%s' in the connection string for '%s'. Replace with 'true'", trimmedInput, key));
            }
            return true;
        }
        if (FALSE_VALUES.contains(trimmedInput)) {
            if (!trimmedInput.equals("false")) {
                LOGGER.warn(String.format("Deprecated boolean value '%s' in the connection string for '%s'. Replace with'false'", trimmedInput, key));
            }
            return false;
        }
        LOGGER.warn(String.format("Ignoring unrecognized boolean value '%s' in the connection string for '%s'. Replace with either 'true' or 'false'", trimmedInput, key));
        return null;
    }

    private int parseInteger(String input, String key) {
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("The connection string contains an invalid value for '%s'. '%s' is not a valid integer", key, input));
        }
    }

    private long parseLong(String input, String key) {
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("The connection string contains an invalid value for '%s'. '%s' is not a valid long", key, input));
        }
    }

    private List<String> parseHosts(List<String> rawHosts) {
        if (rawHosts.size() == 0) {
            throw new IllegalArgumentException("The connection string must contain at least one host");
        }
        ArrayList<String> hosts = new ArrayList<String>();
        for (String host : rawHosts) {
            if (host.length() == 0) {
                throw new IllegalArgumentException(String.format("The connection string contains an empty host '%s'. ", rawHosts));
            }
            if (host.endsWith(".sock")) {
                host = this.urldecode(host);
            } else if (host.startsWith("[")) {
                if (!host.contains("]")) {
                    throw new IllegalArgumentException(String.format("The connection string contains an invalid host '%s'. IPv6 address literals must be enclosed in '[' and ']' according to RFC 2732", host));
                }
                int idx = host.indexOf("]:");
                if (idx != -1) {
                    this.validatePort(host.substring(idx + 2));
                }
            } else {
                int colonCount = this.countOccurrences(host, ":");
                if (colonCount > 1) {
                    throw new IllegalArgumentException(String.format("The connection string contains an invalid host '%s'. Reserved characters such as ':' must be escaped according RFC 2396. Any IPv6 address literal must be enclosed in '[' and ']' according to RFC 2732.", host));
                }
                if (colonCount == 1) {
                    this.validatePort(host.substring(host.indexOf(":") + 1));
                }
            }
            hosts.add(host);
        }
        Collections.sort(hosts);
        return hosts;
    }

    private void validatePort(String port) {
        try {
            int portInt = Integer.parseInt(port);
            if (portInt <= 0 || portInt > 65535) {
                throw new IllegalArgumentException("The connection string contains an invalid host and port. The port must be an integer between 0 and 65535.");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The connection string contains an invalid host and port. The port contains non-digit characters, it must be an integer between 0 and 65535. Hint: username and password must be escaped according to RFC 3986.");
        }
    }

    private void validateProxyParameters() {
        if (this.proxyHost == null) {
            if (this.proxyPort != null) {
                throw new IllegalArgumentException("proxyPort can only be specified with proxyHost");
            }
            if (this.proxyUsername != null) {
                throw new IllegalArgumentException("proxyUsername can only be specified with proxyHost");
            }
            if (this.proxyPassword != null) {
                throw new IllegalArgumentException("proxyPassword can only be specified with proxyHost");
            }
        }
        if (this.proxyPort != null && (this.proxyPort < 0 || this.proxyPort > 65535)) {
            throw new IllegalArgumentException("proxyPort should be within the valid range (0 to 65535)");
        }
        if (this.proxyUsername != null) {
            if (this.proxyUsername.isEmpty()) {
                throw new IllegalArgumentException("proxyUsername cannot be empty");
            }
            if (this.proxyUsername.getBytes(StandardCharsets.UTF_8).length >= 255) {
                throw new IllegalArgumentException("username's length in bytes cannot be greater than 255");
            }
        }
        if (this.proxyPassword != null) {
            if (this.proxyPassword.isEmpty()) {
                throw new IllegalArgumentException("proxyPassword cannot be empty");
            }
            if (this.proxyPassword.getBytes(StandardCharsets.UTF_8).length >= 255) {
                throw new IllegalArgumentException("password's length in bytes cannot be greater than 255");
            }
        }
        if (this.proxyUsername == null ^ this.proxyPassword == null) {
            throw new IllegalArgumentException("Both proxyUsername and proxyPassword must be set together. They cannot be set individually");
        }
    }

    private int countOccurrences(String haystack, String needle) {
        return haystack.length() - haystack.replace(needle, "").length();
    }

    private String urldecode(String input) {
        return this.urldecode(input, false);
    }

    private String urldecode(String input, boolean password) {
        try {
            return URLDecoder.decode(input, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            if (password) {
                throw new IllegalArgumentException("The connection string contained unsupported characters in the password.");
            }
            throw new IllegalArgumentException(String.format("The connection string contained unsupported characters: '%s'.Decoding produced the following error: %s", input, e.getMessage()));
        }
    }

    @Nullable
    public String getUsername() {
        return this.credential != null ? this.credential.getUserName() : null;
    }

    @Nullable
    public char[] getPassword() {
        return this.credential != null ? this.credential.getPassword() : null;
    }

    public boolean isSrvProtocol() {
        return this.isSrvProtocol;
    }

    @Nullable
    public Integer getSrvMaxHosts() {
        return this.srvMaxHosts;
    }

    @Nullable
    public String getSrvServiceName() {
        return this.srvServiceName;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getCollection() {
        return this.collection;
    }

    @Nullable
    public Boolean isDirectConnection() {
        return this.directConnection;
    }

    @Nullable
    public Boolean isLoadBalanced() {
        return this.loadBalanced;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Nullable
    public MongoCredential getCredential() {
        return this.credential;
    }

    @Nullable
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Nullable
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Nullable
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Nullable
    public Boolean getRetryWritesValue() {
        return this.retryWrites;
    }

    @Nullable
    public Boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public Integer getMinConnectionPoolSize() {
        return this.minConnectionPoolSize;
    }

    @Nullable
    public Integer getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    @Nullable
    public Integer getMaxWaitTime() {
        return this.maxWaitTime;
    }

    @Nullable
    public Integer getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    @Nullable
    public Integer getMaxConnectionLifeTime() {
        return this.maxConnectionLifeTime;
    }

    @Nullable
    public Integer getMaxConnecting() {
        return this.maxConnecting;
    }

    @Nullable
    @Alpha(value={Reason.CLIENT})
    public Long getTimeout() {
        return this.timeout;
    }

    @Nullable
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Nullable
    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    @Nullable
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    @Nullable
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Nullable
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Nullable
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Nullable
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Nullable
    public Boolean getSslInvalidHostnameAllowed() {
        return this.sslInvalidHostnameAllowed;
    }

    @Nullable
    public String getRequiredReplicaSetName() {
        return this.requiredReplicaSetName;
    }

    @Nullable
    public Integer getServerSelectionTimeout() {
        return this.serverSelectionTimeout;
    }

    @Nullable
    public Integer getLocalThreshold() {
        return this.localThreshold;
    }

    @Nullable
    public Integer getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    @Nullable
    public ServerMonitoringMode getServerMonitoringMode() {
        return this.serverMonitoringMode;
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    public List<MongoCompressor> getCompressorList() {
        return this.compressorList;
    }

    @Nullable
    public UuidRepresentation getUuidRepresentation() {
        return this.uuidRepresentation;
    }

    public String toString() {
        return this.connectionString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionString that = (ConnectionString)o;
        return this.isSrvProtocol == that.isSrvProtocol && Objects.equals(this.directConnection, that.directConnection) && Objects.equals(this.credential, that.credential) && Objects.equals(this.hosts, that.hosts) && Objects.equals(this.database, that.database) && Objects.equals(this.collection, that.collection) && Objects.equals(this.readPreference, that.readPreference) && Objects.equals(this.writeConcern, that.writeConcern) && Objects.equals(this.retryWrites, that.retryWrites) && Objects.equals(this.retryReads, that.retryReads) && Objects.equals(this.readConcern, that.readConcern) && Objects.equals(this.minConnectionPoolSize, that.minConnectionPoolSize) && Objects.equals(this.maxConnectionPoolSize, that.maxConnectionPoolSize) && Objects.equals(this.maxWaitTime, that.maxWaitTime) && Objects.equals(this.maxConnectionIdleTime, that.maxConnectionIdleTime) && Objects.equals(this.maxConnectionLifeTime, that.maxConnectionLifeTime) && Objects.equals(this.maxConnecting, that.maxConnecting) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.socketTimeout, that.socketTimeout) && Objects.equals(this.proxyHost, that.proxyHost) && Objects.equals(this.proxyPort, that.proxyPort) && Objects.equals(this.proxyUsername, that.proxyUsername) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.sslEnabled, that.sslEnabled) && Objects.equals(this.sslInvalidHostnameAllowed, that.sslInvalidHostnameAllowed) && Objects.equals(this.requiredReplicaSetName, that.requiredReplicaSetName) && Objects.equals(this.serverSelectionTimeout, that.serverSelectionTimeout) && Objects.equals(this.localThreshold, that.localThreshold) && Objects.equals(this.heartbeatFrequency, that.heartbeatFrequency) && Objects.equals((Object)this.serverMonitoringMode, (Object)that.serverMonitoringMode) && Objects.equals(this.applicationName, that.applicationName) && Objects.equals(this.compressorList, that.compressorList) && Objects.equals((Object)this.uuidRepresentation, (Object)that.uuidRepresentation) && Objects.equals(this.srvServiceName, that.srvServiceName) && Objects.equals(this.srvMaxHosts, that.srvMaxHosts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.credential, this.isSrvProtocol, this.hosts, this.database, this.collection, this.directConnection, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.minConnectionPoolSize, this.maxConnectionPoolSize, this.maxWaitTime, this.maxConnectionIdleTime, this.maxConnectionLifeTime, this.maxConnecting, this.connectTimeout, this.timeout, this.socketTimeout, this.sslEnabled, this.sslInvalidHostnameAllowed, this.requiredReplicaSetName, this.serverSelectionTimeout, this.localThreshold, this.heartbeatFrequency, this.serverMonitoringMode, this.applicationName, this.compressorList, this.uuidRepresentation, this.srvServiceName, this.srvMaxHosts, this.proxyHost, this.proxyPort, this.proxyUsername, this.proxyPassword});
    }

    static {
        GENERAL_OPTIONS_KEYS.add("minpoolsize");
        GENERAL_OPTIONS_KEYS.add("maxpoolsize");
        GENERAL_OPTIONS_KEYS.add("timeoutms");
        GENERAL_OPTIONS_KEYS.add("sockettimeoutms");
        GENERAL_OPTIONS_KEYS.add("waitqueuetimeoutms");
        GENERAL_OPTIONS_KEYS.add("connecttimeoutms");
        GENERAL_OPTIONS_KEYS.add("maxidletimems");
        GENERAL_OPTIONS_KEYS.add("maxlifetimems");
        GENERAL_OPTIONS_KEYS.add("maxconnecting");
        GENERAL_OPTIONS_KEYS.add("ssl");
        GENERAL_OPTIONS_KEYS.add("tls");
        GENERAL_OPTIONS_KEYS.add("tlsinsecure");
        GENERAL_OPTIONS_KEYS.add("sslinvalidhostnameallowed");
        GENERAL_OPTIONS_KEYS.add("tlsallowinvalidhostnames");
        GENERAL_OPTIONS_KEYS.add("proxyhost");
        GENERAL_OPTIONS_KEYS.add("proxyport");
        GENERAL_OPTIONS_KEYS.add("proxyusername");
        GENERAL_OPTIONS_KEYS.add("proxypassword");
        GENERAL_OPTIONS_KEYS.add("replicaset");
        GENERAL_OPTIONS_KEYS.add("readconcernlevel");
        GENERAL_OPTIONS_KEYS.add("serverselectiontimeoutms");
        GENERAL_OPTIONS_KEYS.add("localthresholdms");
        GENERAL_OPTIONS_KEYS.add("heartbeatfrequencyms");
        GENERAL_OPTIONS_KEYS.add("servermonitoringmode");
        GENERAL_OPTIONS_KEYS.add("retrywrites");
        GENERAL_OPTIONS_KEYS.add("retryreads");
        GENERAL_OPTIONS_KEYS.add("appname");
        GENERAL_OPTIONS_KEYS.add("uuidrepresentation");
        GENERAL_OPTIONS_KEYS.add("directconnection");
        GENERAL_OPTIONS_KEYS.add("loadbalanced");
        GENERAL_OPTIONS_KEYS.add("srvmaxhosts");
        GENERAL_OPTIONS_KEYS.add("srvservicename");
        COMPRESSOR_KEYS.add("compressors");
        COMPRESSOR_KEYS.add("zlibcompressionlevel");
        READ_PREFERENCE_KEYS.add("readpreference");
        READ_PREFERENCE_KEYS.add("readpreferencetags");
        READ_PREFERENCE_KEYS.add("maxstalenessseconds");
        WRITE_CONCERN_KEYS.add("safe");
        WRITE_CONCERN_KEYS.add("w");
        WRITE_CONCERN_KEYS.add("wtimeoutms");
        WRITE_CONCERN_KEYS.add("journal");
        AUTH_KEYS.add("authmechanism");
        AUTH_KEYS.add("authsource");
        AUTH_KEYS.add("gssapiservicename");
        AUTH_KEYS.add("authmechanismproperties");
        ALL_KEYS.addAll(GENERAL_OPTIONS_KEYS);
        ALL_KEYS.addAll(AUTH_KEYS);
        ALL_KEYS.addAll(READ_PREFERENCE_KEYS);
        ALL_KEYS.addAll(WRITE_CONCERN_KEYS);
        ALL_KEYS.addAll(COMPRESSOR_KEYS);
        DEPRECATED_TIMEOUT_KEYS.add("sockettimeoutms");
        DEPRECATED_TIMEOUT_KEYS.add("waitqueuetimeoutms");
        DEPRECATED_TIMEOUT_KEYS.add("wtimeoutms");
        TRUE_VALUES = new HashSet<String>(Arrays.asList("true", "yes", "1"));
        FALSE_VALUES = new HashSet<String>(Arrays.asList("false", "no", "0"));
    }
}

