/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.gridfs;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonObjectId;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.Document;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistries;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.bson.types.ObjectId;
import com.dre.brewery.depend.mongodb.MongoClientSettings;
import com.dre.brewery.depend.mongodb.MongoGridFSException;
import com.dre.brewery.depend.mongodb.MongoOperationTimeoutException;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.ClientSession;
import com.dre.brewery.depend.mongodb.client.FindIterable;
import com.dre.brewery.depend.mongodb.client.ListIndexesIterable;
import com.dre.brewery.depend.mongodb.client.MongoCollection;
import com.dre.brewery.depend.mongodb.client.MongoDatabase;
import com.dre.brewery.depend.mongodb.client.cursor.TimeoutMode;
import com.dre.brewery.depend.mongodb.client.gridfs.GridFSBucket;
import com.dre.brewery.depend.mongodb.client.gridfs.GridFSDownloadStream;
import com.dre.brewery.depend.mongodb.client.gridfs.GridFSDownloadStreamImpl;
import com.dre.brewery.depend.mongodb.client.gridfs.GridFSFindIterable;
import com.dre.brewery.depend.mongodb.client.gridfs.GridFSFindIterableImpl;
import com.dre.brewery.depend.mongodb.client.gridfs.GridFSUploadStream;
import com.dre.brewery.depend.mongodb.client.gridfs.GridFSUploadStreamImpl;
import com.dre.brewery.depend.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.dre.brewery.depend.mongodb.client.gridfs.model.GridFSFile;
import com.dre.brewery.depend.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.dre.brewery.depend.mongodb.client.internal.TimeoutHelper;
import com.dre.brewery.depend.mongodb.client.model.IndexOptions;
import com.dre.brewery.depend.mongodb.client.result.DeleteResult;
import com.dre.brewery.depend.mongodb.client.result.UpdateResult;
import com.dre.brewery.depend.mongodb.internal.TimeoutContext;
import com.dre.brewery.depend.mongodb.internal.time.Timeout;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class GridFSBucketImpl
implements GridFSBucket {
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private static final String TIMEOUT_MESSAGE = "GridFS operation exceeded the timeout limit.";
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<BsonDocument> chunksCollection;
    private volatile boolean checkedIndexes;

    GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this(Assertions.notNull("bucketName", bucketName), 261120, GridFSBucketImpl.getFilesCollection(Assertions.notNull("database", database), bucketName), GridFSBucketImpl.getChunksCollection(database, bucketName));
    }

    GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<BsonDocument> chunksCollection) {
        this.bucketName = Assertions.notNull("bucketName", bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = Assertions.notNull("filesCollection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunksCollection", chunksCollection);
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        return this.filesCollection.getTimeout(timeUnit);
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public GridFSBucket withTimeout(long timeout, TimeUnit timeUnit) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withTimeout(timeout, timeUnit), this.chunksCollection.withTimeout(timeout, timeUnit));
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename) {
        return this.openUploadStream(new BsonObjectId(), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options) {
        return this.openUploadStream(new BsonObjectId(), filename, options);
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename) {
        return this.openUploadStream(id, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename, GridFSUploadOptions options) {
        return this.createGridFSUploadStream(null, id, filename, options);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename) {
        return this.openUploadStream(clientSession, new BsonObjectId(), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename, GridFSUploadOptions options) {
        return this.openUploadStream(clientSession, new BsonObjectId(), filename, options);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, ObjectId id, String filename) {
        return this.openUploadStream(clientSession, new BsonObjectId(id), filename);
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename) {
        return this.openUploadStream(clientSession, id, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSUploadStream(clientSession, id, filename, options);
    }

    private GridFSUploadStream createGridFSUploadStream(@Nullable ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        Timeout operationTimeout = this.startTimeout();
        Assertions.notNull("options", options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        this.checkCreateIndex(clientSession, operationTimeout);
        return new GridFSUploadStreamImpl(clientSession, this.filesCollection, this.chunksCollection, id, filename, chunkSize, options.getMetadata(), operationTimeout);
    }

    @Override
    public ObjectId uploadFromStream(String filename, InputStream source) {
        return this.uploadFromStream(filename, source, new GridFSUploadOptions());
    }

    @Override
    public ObjectId uploadFromStream(String filename, InputStream source, GridFSUploadOptions options) {
        ObjectId id = new ObjectId();
        this.uploadFromStream(new BsonObjectId(id), filename, source, options);
        return id;
    }

    @Override
    public void uploadFromStream(BsonValue id, String filename, InputStream source) {
        this.uploadFromStream(id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public void uploadFromStream(BsonValue id, String filename, InputStream source, GridFSUploadOptions options) {
        this.executeUploadFromStream(null, id, filename, source, options);
    }

    @Override
    public ObjectId uploadFromStream(ClientSession clientSession, String filename, InputStream source) {
        return this.uploadFromStream(clientSession, filename, source, new GridFSUploadOptions());
    }

    @Override
    public ObjectId uploadFromStream(ClientSession clientSession, String filename, InputStream source, GridFSUploadOptions options) {
        ObjectId id = new ObjectId();
        this.uploadFromStream(clientSession, new BsonObjectId(id), filename, source, options);
        return id;
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue id, String filename, InputStream source) {
        this.uploadFromStream(clientSession, id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public void uploadFromStream(ClientSession clientSession, BsonValue id, String filename, InputStream source, GridFSUploadOptions options) {
        Assertions.notNull("clientSession", clientSession);
        this.executeUploadFromStream(clientSession, id, filename, source, options);
    }

    private void executeUploadFromStream(@Nullable ClientSession clientSession, BsonValue id, String filename, InputStream source, GridFSUploadOptions options) {
        GridFSUploadStream uploadStream = this.createGridFSUploadStream(clientSession, id, filename, options);
        Integer chunkSizeBytes = options.getChunkSizeBytes();
        int chunkSize = chunkSizeBytes == null ? this.chunkSizeBytes : chunkSizeBytes;
        byte[] buffer = new byte[chunkSize];
        try {
            int len;
            while ((len = source.read(buffer)) != -1) {
                uploadStream.write(buffer, 0, len);
            }
            uploadStream.close();
        }
        catch (IOException e) {
            uploadStream.abort();
            throw new MongoGridFSException("IOException when reading from the InputStream", e);
        }
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ObjectId id) {
        return this.openDownloadStream(new BsonObjectId(id));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(BsonValue id) {
        Timeout operationTimeout = this.startTimeout();
        GridFSFile fileInfo = this.getFileInfoById(null, id, operationTimeout);
        return this.createGridFSDownloadStream(null, fileInfo, operationTimeout);
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename) {
        return this.openDownloadStream(filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename, GridFSDownloadOptions options) {
        Timeout operationTimeout = this.startTimeout();
        GridFSFile file = this.getFileByName(null, filename, options, operationTimeout);
        return this.createGridFSDownloadStream(null, file, operationTimeout);
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, ObjectId id) {
        return this.openDownloadStream(clientSession, new BsonObjectId(id));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, BsonValue id) {
        Assertions.notNull("clientSession", clientSession);
        Timeout operationTimeout = this.startTimeout();
        GridFSFile fileInfoById = this.getFileInfoById(clientSession, id, operationTimeout);
        return this.createGridFSDownloadStream(clientSession, fileInfoById, operationTimeout);
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename) {
        return this.openDownloadStream(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        Assertions.notNull("clientSession", clientSession);
        Timeout operationTimeout = this.startTimeout();
        GridFSFile file = this.getFileByName(clientSession, filename, options, operationTimeout);
        return this.createGridFSDownloadStream(clientSession, file, operationTimeout);
    }

    private GridFSDownloadStream createGridFSDownloadStream(@Nullable ClientSession clientSession, GridFSFile gridFSFile, @Nullable Timeout operationTimeout) {
        return new GridFSDownloadStreamImpl(clientSession, gridFSFile, this.chunksCollection, operationTimeout);
    }

    @Override
    public void downloadToStream(ObjectId id, OutputStream destination) {
        this.downloadToStream(new BsonObjectId(id), destination);
    }

    @Override
    public void downloadToStream(BsonValue id, OutputStream destination) {
        this.downloadToStream(this.openDownloadStream(id), destination);
    }

    @Override
    public void downloadToStream(String filename, OutputStream destination) {
        this.downloadToStream(filename, destination, new GridFSDownloadOptions());
    }

    @Override
    public void downloadToStream(String filename, OutputStream destination, GridFSDownloadOptions options) {
        this.downloadToStream(this.openDownloadStream(filename, options), destination);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, ObjectId id, OutputStream destination) {
        this.downloadToStream(clientSession, new BsonObjectId(id), destination);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, BsonValue id, OutputStream destination) {
        Assertions.notNull("clientSession", clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, id), destination);
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String filename, OutputStream destination) {
        this.downloadToStream(clientSession, filename, destination, new GridFSDownloadOptions());
    }

    @Override
    public void downloadToStream(ClientSession clientSession, String filename, OutputStream destination, GridFSDownloadOptions options) {
        Assertions.notNull("clientSession", clientSession);
        this.downloadToStream(this.openDownloadStream(clientSession, filename, options), destination);
    }

    @Override
    public GridFSFindIterable find() {
        return this.createGridFSFindIterable(null, null);
    }

    @Override
    public GridFSFindIterable find(Bson filter) {
        Assertions.notNull("filter", filter);
        return this.createGridFSFindIterable(null, filter);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createGridFSFindIterable(clientSession, null);
    }

    @Override
    public GridFSFindIterable find(ClientSession clientSession, Bson filter) {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("filter", filter);
        return this.createGridFSFindIterable(clientSession, filter);
    }

    private GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter) {
        return new GridFSFindIterableImpl(this.createFindIterable(clientSession, filter, this.startTimeout()));
    }

    private GridFSFindIterable createGridFSFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter, @Nullable Timeout operationTimeout) {
        return new GridFSFindIterableImpl(this.createFindIterable(clientSession, filter, operationTimeout));
    }

    @Override
    public void delete(ObjectId id) {
        this.delete(new BsonObjectId(id));
    }

    @Override
    public void delete(BsonValue id) {
        this.executeDelete(null, id);
    }

    @Override
    public void delete(ClientSession clientSession, ObjectId id) {
        this.delete(clientSession, new BsonObjectId(id));
    }

    @Override
    public void delete(ClientSession clientSession, BsonValue id) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDelete(clientSession, id);
    }

    private void executeDelete(@Nullable ClientSession clientSession, BsonValue id) {
        DeleteResult result;
        Timeout operationTimeout = this.startTimeout();
        if (clientSession != null) {
            result = GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTimeout).deleteOne(clientSession, new BsonDocument("_id", id));
            GridFSBucketImpl.withNullableTimeout(this.chunksCollection, operationTimeout).deleteMany(clientSession, new BsonDocument("files_id", id));
        } else {
            result = GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTimeout).deleteOne(new BsonDocument("_id", id));
            GridFSBucketImpl.withNullableTimeout(this.chunksCollection, operationTimeout).deleteMany(new BsonDocument("files_id", id));
        }
        if (result.wasAcknowledged() && result.getDeletedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id));
        }
    }

    @Override
    public void rename(ObjectId id, String newFilename) {
        this.rename(new BsonObjectId(id), newFilename);
    }

    @Override
    public void rename(BsonValue id, String newFilename) {
        this.executeRename(null, id, newFilename);
    }

    @Override
    public void rename(ClientSession clientSession, ObjectId id, String newFilename) {
        this.rename(clientSession, new BsonObjectId(id), newFilename);
    }

    @Override
    public void rename(ClientSession clientSession, BsonValue id, String newFilename) {
        Assertions.notNull("clientSession", clientSession);
        this.executeRename(clientSession, id, newFilename);
    }

    private void executeRename(@Nullable ClientSession clientSession, BsonValue id, String newFilename) {
        Timeout operationTimeout = this.startTimeout();
        UpdateResult updateResult = clientSession != null ? GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTimeout).updateOne(clientSession, (Bson)new BsonDocument("_id", id), new BsonDocument("$set", new BsonDocument("filename", new BsonString(newFilename)))) : GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTimeout).updateOne((Bson)new BsonDocument("_id", id), new BsonDocument("$set", new BsonDocument("filename", new BsonString(newFilename))));
        if (updateResult.wasAcknowledged() && updateResult.getMatchedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id));
        }
    }

    @Override
    public void drop() {
        Timeout operationTimeout = this.startTimeout();
        GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTimeout).drop();
        GridFSBucketImpl.withNullableTimeout(this.chunksCollection, operationTimeout).drop();
    }

    @Override
    public void drop(ClientSession clientSession) {
        Timeout operationTimeout = this.startTimeout();
        Assertions.notNull("clientSession", clientSession);
        GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTimeout).drop(clientSession);
        GridFSBucketImpl.withNullableTimeout(this.chunksCollection, operationTimeout).drop(clientSession);
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries(database.getCodecRegistry(), MongoClientSettings.getDefaultCodecRegistry()));
    }

    private static MongoCollection<BsonDocument> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks", BsonDocument.class).withCodecRegistry(MongoClientSettings.getDefaultCodecRegistry());
    }

    private void checkCreateIndex(@Nullable ClientSession clientSession, @Nullable Timeout operationTimeout) {
        if (!this.checkedIndexes) {
            if (this.collectionIsEmpty(clientSession, this.filesCollection.withDocumentClass(Document.class).withReadPreference(ReadPreference.primary()), operationTimeout)) {
                Document filesIndex = new Document("filename", 1).append("uploadDate", 1);
                if (!this.hasIndex(clientSession, this.filesCollection.withReadPreference(ReadPreference.primary()), filesIndex, operationTimeout)) {
                    this.createIndex(clientSession, this.filesCollection, filesIndex, new IndexOptions(), operationTimeout);
                }
                Document chunksIndex = new Document("files_id", 1).append("n", 1);
                if (!this.hasIndex(clientSession, this.chunksCollection.withReadPreference(ReadPreference.primary()), chunksIndex, operationTimeout)) {
                    this.createIndex(clientSession, this.chunksCollection, chunksIndex, new IndexOptions().unique(true), operationTimeout);
                }
            }
            this.checkedIndexes = true;
        }
    }

    private <T> boolean collectionIsEmpty(@Nullable ClientSession clientSession, MongoCollection<T> collection, @Nullable Timeout operationTimeout) {
        if (clientSession != null) {
            return GridFSBucketImpl.withNullableTimeout(collection, operationTimeout).find(clientSession).projection(new Document("_id", 1)).first() == null;
        }
        return GridFSBucketImpl.withNullableTimeout(collection, operationTimeout).find().projection(new Document("_id", 1)).first() == null;
    }

    private <T> boolean hasIndex(@Nullable ClientSession clientSession, MongoCollection<T> collection, Document index, @Nullable Timeout operationTimeout) {
        boolean hasIndex = false;
        ListIndexesIterable<Document> listIndexesIterable = clientSession != null ? GridFSBucketImpl.withNullableTimeout(collection, operationTimeout).listIndexes(clientSession) : GridFSBucketImpl.withNullableTimeout(collection, operationTimeout).listIndexes();
        ArrayList indexes = listIndexesIterable.into(new ArrayList());
        for (Document result : indexes) {
            Document indexDoc = result.get((Object)"key", new Document());
            for (Map.Entry<String, Object> entry : indexDoc.entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                entry.setValue(((Number)entry.getValue()).intValue());
            }
            if (!indexDoc.equals(index)) continue;
            hasIndex = true;
            break;
        }
        return hasIndex;
    }

    private <T> void createIndex(@Nullable ClientSession clientSession, MongoCollection<T> collection, Document index, IndexOptions indexOptions, @Nullable Timeout operationTimeout) {
        if (clientSession != null) {
            GridFSBucketImpl.withNullableTimeout(collection, operationTimeout).createIndex(clientSession, index, indexOptions);
        } else {
            GridFSBucketImpl.withNullableTimeout(collection, operationTimeout).createIndex(index, indexOptions);
        }
    }

    private GridFSFile getFileByName(@Nullable ClientSession clientSession, String filename, GridFSDownloadOptions options, @Nullable Timeout operationTimeout) {
        int sort;
        int skip;
        int revision = options.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        GridFSFile fileInfo = (GridFSFile)this.createGridFSFindIterable(clientSession, new Document("filename", filename), operationTimeout).skip(skip).sort(new Document("uploadDate", sort)).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the filename: %s and revision: %s", filename, revision));
        }
        return fileInfo;
    }

    private GridFSFile getFileInfoById(@Nullable ClientSession clientSession, BsonValue id, @Nullable Timeout operationTImeout) {
        Assertions.notNull("id", id);
        GridFSFile fileInfo = (GridFSFile)this.createFindIterable(clientSession, new Document("_id", id), operationTImeout).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id));
        }
        return fileInfo;
    }

    private FindIterable<GridFSFile> createFindIterable(@Nullable ClientSession clientSession, @Nullable Bson filter, @Nullable Timeout operationTImeout) {
        FindIterable<GridFSFile> findIterable = clientSession != null ? GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTImeout).find(clientSession) : GridFSBucketImpl.withNullableTimeout(this.filesCollection, operationTImeout).find();
        if (filter != null) {
            findIterable = findIterable.filter(filter);
        }
        if (this.filesCollection.getTimeout(TimeUnit.MILLISECONDS) != null) {
            findIterable.timeoutMode(TimeoutMode.CURSOR_LIFETIME);
        }
        return findIterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadToStream(GridFSDownloadStream downloadStream, OutputStream destination) {
        block17: {
            byte[] buffer = new byte[downloadStream.getGridFSFile().getChunkSize()];
            MongoGridFSException savedThrowable = null;
            try {
                int len;
                while ((len = downloadStream.read(buffer)) != -1) {
                    destination.write(buffer, 0, len);
                }
            }
            catch (MongoOperationTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                savedThrowable = new MongoGridFSException("IOException when reading from the OutputStream", e);
            }
            catch (Exception e) {
                savedThrowable = new MongoGridFSException("Unexpected Exception when reading GridFS and writing to the Stream", e);
            }
            finally {
                try {
                    downloadStream.close();
                }
                catch (Exception e) {}
                if (savedThrowable == null) break block17;
                throw savedThrowable;
            }
        }
    }

    private static <T> MongoCollection<T> withNullableTimeout(MongoCollection<T> chunksCollection, @Nullable Timeout timeout) {
        return TimeoutHelper.collectionWithTimeout(chunksCollection, TIMEOUT_MESSAGE, timeout);
    }

    @Nullable
    private Timeout startTimeout() {
        return TimeoutContext.startTimeout(this.filesCollection.getTimeout(TimeUnit.MILLISECONDS));
    }
}

