/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.internal;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBinary;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonNull;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.bson.internal.BsonUtil;
import com.dre.brewery.depend.mongodb.ClientEncryptionSettings;
import com.dre.brewery.depend.mongodb.MongoConfigurationException;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.MongoUpdatedEncryptedFieldsException;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.bulk.BulkWriteResult;
import com.dre.brewery.depend.mongodb.client.FindIterable;
import com.dre.brewery.depend.mongodb.client.MongoClient;
import com.dre.brewery.depend.mongodb.client.MongoClients;
import com.dre.brewery.depend.mongodb.client.MongoCollection;
import com.dre.brewery.depend.mongodb.client.MongoDatabase;
import com.dre.brewery.depend.mongodb.client.internal.Crypt;
import com.dre.brewery.depend.mongodb.client.internal.Crypts;
import com.dre.brewery.depend.mongodb.client.internal.TimeoutHelper;
import com.dre.brewery.depend.mongodb.client.model.CreateCollectionOptions;
import com.dre.brewery.depend.mongodb.client.model.CreateEncryptedCollectionParams;
import com.dre.brewery.depend.mongodb.client.model.Filters;
import com.dre.brewery.depend.mongodb.client.model.UpdateOneModel;
import com.dre.brewery.depend.mongodb.client.model.Updates;
import com.dre.brewery.depend.mongodb.client.model.vault.DataKeyOptions;
import com.dre.brewery.depend.mongodb.client.model.vault.EncryptOptions;
import com.dre.brewery.depend.mongodb.client.model.vault.RewrapManyDataKeyOptions;
import com.dre.brewery.depend.mongodb.client.model.vault.RewrapManyDataKeyResult;
import com.dre.brewery.depend.mongodb.client.result.DeleteResult;
import com.dre.brewery.depend.mongodb.client.vault.ClientEncryption;
import com.dre.brewery.depend.mongodb.internal.TimeoutContext;
import com.dre.brewery.depend.mongodb.internal.capi.MongoCryptHelper;
import com.dre.brewery.depend.mongodb.internal.time.Timeout;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ClientEncryptionImpl
implements ClientEncryption {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final MongoClient keyVaultClient;
    private final MongoCollection<BsonDocument> collection;

    public ClientEncryptionImpl(ClientEncryptionSettings options) {
        this(MongoClients.create(options.getKeyVaultMongoClientSettings()), options);
    }

    public ClientEncryptionImpl(MongoClient keyVaultClient, ClientEncryptionSettings options) {
        this.keyVaultClient = keyVaultClient;
        this.crypt = Crypts.create(keyVaultClient, options);
        this.options = options;
        MongoNamespace namespace = new MongoNamespace(options.getKeyVaultNamespace());
        this.collection = ClientEncryptionImpl.getVaultCollection(keyVaultClient, options, namespace);
    }

    private static MongoCollection<BsonDocument> getVaultCollection(MongoClient keyVaultClient, ClientEncryptionSettings options, MongoNamespace namespace) {
        MongoCollection<BsonDocument> vaultCollection = keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).withReadConcern(ReadConcern.MAJORITY);
        Long timeoutMs = options.getTimeout(TimeUnit.MILLISECONDS);
        if (timeoutMs != null) {
            vaultCollection = vaultCollection.withTimeout(timeoutMs, TimeUnit.MILLISECONDS);
        }
        return vaultCollection;
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions) {
        Timeout operationTimeout = this.startTimeout();
        return this.createDataKey(kmsProvider, dataKeyOptions, operationTimeout);
    }

    public BsonBinary createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions, @Nullable Timeout operationTimeout) {
        BsonDocument dataKeyDocument = this.crypt.createDataKey(kmsProvider, dataKeyOptions, operationTimeout);
        TimeoutHelper.collectionWithTimeout(this.collection, "Data key insertion exceeded the timeout limit.", operationTimeout).insertOne(dataKeyDocument);
        return dataKeyDocument.getBinary("_id");
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptOptions options) {
        Timeout operationTimeout = this.startTimeout();
        return this.crypt.encryptExplicitly(value, options, operationTimeout);
    }

    @Override
    public BsonDocument encryptExpression(Bson expression, EncryptOptions options) {
        Timeout operationTimeout = this.startTimeout();
        return this.crypt.encryptExpression(expression.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options, operationTimeout);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        Timeout operationTimeout = this.startTimeout();
        return this.crypt.decryptExplicitly(value, operationTimeout);
    }

    @Override
    public DeleteResult deleteKey(BsonBinary id) {
        return TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).deleteOne(Filters.eq("_id", id));
    }

    @Override
    public BsonDocument getKey(BsonBinary id) {
        return (BsonDocument)TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).find(Filters.eq("_id", id)).first();
    }

    @Override
    public FindIterable<BsonDocument> getKeys() {
        return TimeoutHelper.collectionWithTimeout(this.collection, this.startTimeout()).find();
    }

    @Override
    public BsonDocument addKeyAltName(BsonBinary id, String keyAltName) {
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Updates.addToSet("keyAltNames", keyAltName));
    }

    @Override
    public BsonDocument removeKeyAltName(BsonBinary id, String keyAltName) {
        BsonDocument updateDocument = new BsonDocument().append("$set", new BsonDocument().append("keyAltNames", new BsonDocument().append("$cond", new BsonArray(Arrays.asList(new BsonDocument().append("$eq", new BsonArray(Arrays.asList(new BsonString("$keyAltNames"), new BsonArray(Collections.singletonList(new BsonString(keyAltName)))))), new BsonString("$$REMOVE"), new BsonDocument().append("$filter", new BsonDocument().append("input", new BsonString("$keyAltNames")).append("cond", new BsonDocument().append("$ne", new BsonArray(Arrays.asList(new BsonString("$$this"), new BsonString(keyAltName)))))))))));
        return this.collection.findOneAndUpdate(Filters.eq("_id", id), Collections.singletonList(updateDocument));
    }

    @Override
    public BsonDocument getKeyByAltName(String keyAltName) {
        return (BsonDocument)this.collection.find(Filters.eq("keyAltNames", keyAltName)).first();
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson filter) {
        return this.rewrapManyDataKey(filter, new RewrapManyDataKeyOptions());
    }

    @Override
    public RewrapManyDataKeyResult rewrapManyDataKey(Bson filter, RewrapManyDataKeyOptions options) {
        MongoCryptHelper.validateRewrapManyDataKeyOptions(options);
        Timeout operationTimeout = this.startTimeout();
        BsonDocument results = this.crypt.rewrapManyDataKey(filter.toBsonDocument(BsonDocument.class, this.collection.getCodecRegistry()), options, operationTimeout);
        if (results.isEmpty()) {
            return new RewrapManyDataKeyResult();
        }
        List updateModels = results.getArray("v", new BsonArray()).stream().map(v -> {
            BsonDocument updateDocument = v.asDocument();
            return new UpdateOneModel(Filters.eq(updateDocument.get("_id")), Updates.combine(Updates.set("masterKey", updateDocument.get("masterKey")), Updates.set("keyMaterial", updateDocument.get("keyMaterial")), Updates.currentDate("updateDate")));
        }).collect(Collectors.toList());
        BulkWriteResult bulkWriteResult = TimeoutHelper.collectionWithTimeout(this.collection, operationTimeout).bulkWrite(updateModels);
        return new RewrapManyDataKeyResult(bulkWriteResult);
    }

    @Override
    public BsonDocument createEncryptedCollection(MongoDatabase database, String collectionName, CreateCollectionOptions createCollectionOptions, CreateEncryptedCollectionParams createEncryptedCollectionParams) {
        Assertions.notNull("collectionName", collectionName);
        Assertions.notNull("createCollectionOptions", createCollectionOptions);
        Assertions.notNull("createEncryptedCollectionParams", createEncryptedCollectionParams);
        Timeout operationTimeout = this.startTimeout();
        MongoNamespace namespace = new MongoNamespace(database.getName(), collectionName);
        Bson rawEncryptedFields = createCollectionOptions.getEncryptedFields();
        if (rawEncryptedFields == null) {
            throw new MongoConfigurationException(String.format("`encryptedFields` is not configured for the collection %s.", namespace));
        }
        CodecRegistry codecRegistry = this.options.getKeyVaultMongoClientSettings().getCodecRegistry();
        BsonDocument encryptedFields = rawEncryptedFields.toBsonDocument(BsonDocument.class, codecRegistry);
        BsonValue fields = encryptedFields.get("fields");
        if (fields != null && fields.isArray()) {
            String kmsProvider = createEncryptedCollectionParams.getKmsProvider();
            DataKeyOptions dataKeyOptions = new DataKeyOptions();
            BsonDocument masterKey = createEncryptedCollectionParams.getMasterKey();
            if (masterKey != null) {
                dataKeyOptions.masterKey(masterKey);
            }
            String keyIdBsonKey = "keyId";
            BsonDocument maybeUpdatedEncryptedFields = BsonUtil.mutableDeepCopy(encryptedFields);
            AtomicBoolean dataKeyMightBeCreated = new AtomicBoolean();
            try {
                maybeUpdatedEncryptedFields.get("fields").asArray().stream().filter(BsonValue::isDocument).map(BsonValue::asDocument).filter(field -> field.containsKey(keyIdBsonKey)).filter(field -> Objects.equals(field.get(keyIdBsonKey), BsonNull.VALUE)).forEachOrdered(field -> {
                    dataKeyMightBeCreated.set(true);
                    BsonBinary dataKeyId = this.createDataKey(kmsProvider, dataKeyOptions, operationTimeout);
                    field.put(keyIdBsonKey, dataKeyId);
                });
                TimeoutHelper.databaseWithTimeout(database, operationTimeout).createCollection(collectionName, new CreateCollectionOptions(createCollectionOptions).encryptedFields(maybeUpdatedEncryptedFields));
                return maybeUpdatedEncryptedFields;
            }
            catch (Exception e) {
                if (dataKeyMightBeCreated.get()) {
                    throw new MongoUpdatedEncryptedFieldsException(maybeUpdatedEncryptedFields, String.format("Failed to create %s.", namespace), (Throwable)e);
                }
                throw e;
            }
        }
        TimeoutHelper.databaseWithTimeout(database, operationTimeout).createCollection(collectionName, createCollectionOptions);
        return encryptedFields;
    }

    @Override
    public void close() {
        this.crypt.close();
        this.keyVaultClient.close();
    }

    @Nullable
    private Timeout startTimeout() {
        return TimeoutContext.startTimeout(this.options.getTimeout(TimeUnit.MILLISECONDS));
    }
}

