/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.internal;

import com.dre.brewery.depend.mongodb.Function;
import com.dre.brewery.depend.mongodb.client.MongoCursor;
import com.dre.brewery.depend.mongodb.client.MongoIterable;
import com.dre.brewery.depend.mongodb.client.internal.MongoMappingCursor;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.function.Consumer;

public class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    public MappingIterable(MongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = iterable;
        this.mapper = mapper;
    }

    @Override
    public MongoCursor<V> iterator() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    @Override
    public MongoCursor<V> cursor() {
        return this.iterator();
    }

    @Override
    @Nullable
    public V first() {
        U first = this.iterable.first();
        if (first == null) {
            return null;
        }
        return this.mapper.apply(first);
    }

    @Override
    public void forEach(Consumer<? super V> block) {
        this.iterable.forEach((? super T document) -> block.accept((V)this.mapper.apply(document)));
    }

    @Override
    public <A extends Collection<? super V>> A into(A target) {
        this.forEach((Consumer<? super V>)((Consumer<Object>)v -> target.add(v)));
        return target;
    }

    public MappingIterable<U, V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public <W> MongoIterable<W> map(Function<V, W> newMap) {
        return new MappingIterable<V, W>(this, newMap);
    }

    MongoIterable<U> getMapped() {
        return this.iterable;
    }
}

