/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.internal;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.Document;
import com.dre.brewery.depend.bson.UuidRepresentation;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistries;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.mongodb.AutoEncryptionSettings;
import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.AggregateIterable;
import com.dre.brewery.depend.mongodb.client.ChangeStreamIterable;
import com.dre.brewery.depend.mongodb.client.ClientSession;
import com.dre.brewery.depend.mongodb.client.ListCollectionNamesIterable;
import com.dre.brewery.depend.mongodb.client.ListCollectionsIterable;
import com.dre.brewery.depend.mongodb.client.MongoCollection;
import com.dre.brewery.depend.mongodb.client.MongoDatabase;
import com.dre.brewery.depend.mongodb.client.internal.AggregateIterableImpl;
import com.dre.brewery.depend.mongodb.client.internal.ChangeStreamIterableImpl;
import com.dre.brewery.depend.mongodb.client.internal.ListCollectionNamesIterableImpl;
import com.dre.brewery.depend.mongodb.client.internal.ListCollectionsIterableImpl;
import com.dre.brewery.depend.mongodb.client.internal.MongoCollectionImpl;
import com.dre.brewery.depend.mongodb.client.internal.OperationExecutor;
import com.dre.brewery.depend.mongodb.client.model.CreateCollectionOptions;
import com.dre.brewery.depend.mongodb.client.model.CreateViewOptions;
import com.dre.brewery.depend.mongodb.internal.TimeoutSettings;
import com.dre.brewery.depend.mongodb.internal.client.model.AggregationLevel;
import com.dre.brewery.depend.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperations;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MongoDatabaseImpl
implements MongoDatabase {
    private final String name;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;
    private final ReadConcern readConcern;
    private final UuidRepresentation uuidRepresentation;
    @Nullable
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final TimeoutSettings timeoutSettings;
    private final OperationExecutor executor;
    private final SyncOperations<BsonDocument> operations;

    public MongoDatabaseImpl(String name, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, ReadConcern readConcern, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, TimeoutSettings timeoutSettings, OperationExecutor executor) {
        MongoNamespace.checkDatabaseNameValidity(name);
        this.name = Assertions.notNull("name", name);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.retryReads = retryReads;
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.timeoutSettings = timeoutSettings;
        this.executor = Assertions.notNull("executor", executor);
        this.operations = new SyncOperations<BsonDocument>(new MongoNamespace(name, "$cmd"), BsonDocument.class, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads, timeoutSettings);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long timeoutMS = this.timeoutSettings.getTimeoutMS();
        return timeoutMS == null ? null : Long.valueOf(Assertions.notNull("timeUnit", timeUnit).convert(timeoutMS, TimeUnit.MILLISECONDS));
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.name, CodecRegistries.withUuidRepresentation(codecRegistry, this.uuidRepresentation), this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public MongoDatabase withTimeout(long timeout, TimeUnit timeUnit) {
        return new MongoDatabaseImpl(this.name, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings.withTimeout(timeout, timeUnit), this.executor);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> documentClass) {
        return new MongoCollectionImpl<TDocument>(new MongoNamespace(this.name, collectionName), documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.executor);
    }

    @Override
    public Document runCommand(Bson command) {
        return this.runCommand(command, Document.class);
    }

    @Override
    public Document runCommand(Bson command, ReadPreference readPreference) {
        return this.runCommand(command, readPreference, Document.class);
    }

    @Override
    public <TResult> TResult runCommand(Bson command, Class<TResult> resultClass) {
        return this.runCommand(command, ReadPreference.primary(), resultClass);
    }

    @Override
    public <TResult> TResult runCommand(Bson command, ReadPreference readPreference, Class<TResult> resultClass) {
        return this.executeCommand(null, command, readPreference, resultClass);
    }

    @Override
    public Document runCommand(ClientSession clientSession, Bson command) {
        return this.runCommand(clientSession, command, ReadPreference.primary(), Document.class);
    }

    @Override
    public Document runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference) {
        return this.runCommand(clientSession, command, readPreference, Document.class);
    }

    @Override
    public <TResult> TResult runCommand(ClientSession clientSession, Bson command, Class<TResult> resultClass) {
        return this.runCommand(clientSession, command, ReadPreference.primary(), resultClass);
    }

    @Override
    public <TResult> TResult runCommand(ClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.executeCommand(clientSession, command, readPreference, resultClass);
    }

    private <TResult> TResult executeCommand(@Nullable ClientSession clientSession, Bson command, ReadPreference readPreference, Class<TResult> resultClass) {
        Assertions.notNull("readPreference", readPreference);
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            throw new MongoClientException("Read preference in a transaction must be primary");
        }
        return this.getExecutor().execute(this.operations.commandRead(command, resultClass), readPreference, this.readConcern, clientSession);
    }

    @Override
    public void drop() {
        this.executeDrop(null);
    }

    @Override
    public void drop(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        this.executeDrop(clientSession);
    }

    private void executeDrop(@Nullable ClientSession clientSession) {
        this.getExecutor().execute(this.operations.dropDatabase(), this.readConcern, clientSession);
    }

    @Override
    public ListCollectionNamesIterable listCollectionNames() {
        return this.createListCollectionNamesIterable(null);
    }

    @Override
    public ListCollectionNamesIterable listCollectionNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListCollectionNamesIterable(clientSession);
    }

    private ListCollectionNamesIterable createListCollectionNamesIterable(@Nullable ClientSession clientSession) {
        return new ListCollectionNamesIterableImpl(this.createListCollectionsIterable(clientSession, BsonDocument.class, true));
    }

    @Override
    public ListCollectionsIterable<Document> listCollections() {
        return this.listCollections(Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> resultClass) {
        return this.createListCollectionsIterable(null, resultClass, false);
    }

    @Override
    public ListCollectionsIterable<Document> listCollections(ClientSession clientSession) {
        return this.listCollections(clientSession, Document.class);
    }

    @Override
    public <TResult> ListCollectionsIterable<TResult> listCollections(ClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListCollectionsIterable(clientSession, resultClass, false);
    }

    private <TResult> ListCollectionsIterableImpl<TResult> createListCollectionsIterable(@Nullable ClientSession clientSession, Class<TResult> resultClass, boolean collectionNamesOnly) {
        return new ListCollectionsIterableImpl<TResult>(clientSession, this.name, collectionNamesOnly, resultClass, this.codecRegistry, ReadPreference.primary(), this.executor, this.retryReads, this.timeoutSettings);
    }

    @Override
    public void createCollection(String collectionName) {
        this.createCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public void createCollection(String collectionName, CreateCollectionOptions createCollectionOptions) {
        this.executeCreateCollection(null, collectionName, createCollectionOptions);
    }

    @Override
    public void createCollection(ClientSession clientSession, String collectionName) {
        this.createCollection(clientSession, collectionName, new CreateCollectionOptions());
    }

    @Override
    public void createCollection(ClientSession clientSession, String collectionName, CreateCollectionOptions createCollectionOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCreateCollection(clientSession, collectionName, createCollectionOptions);
    }

    private void executeCreateCollection(@Nullable ClientSession clientSession, String collectionName, CreateCollectionOptions createCollectionOptions) {
        this.getExecutor().execute(this.operations.createCollection(collectionName, createCollectionOptions, this.autoEncryptionSettings), this.readConcern, clientSession);
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline) {
        this.createView(viewName, viewOn, pipeline, new CreateViewOptions());
    }

    @Override
    public void createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        this.executeCreateView(null, viewName, viewOn, pipeline, createViewOptions);
    }

    @Override
    public void createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline) {
        this.createView(clientSession, viewName, viewOn, pipeline, new CreateViewOptions());
    }

    @Override
    public void createView(ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        Assertions.notNull("clientSession", clientSession);
        this.executeCreateView(clientSession, viewName, viewOn, pipeline, createViewOptions);
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList(), Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    @Override
    public AggregateIterable<Document> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable(null, pipeline, resultClass);
    }

    @Override
    public AggregateIterable<Document> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull("clientSession", clientSession);
        return this.createAggregateIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> AggregateIterable<TResult> createAggregateIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregateIterableImpl<Document, TResult>(clientSession, this.name, Document.class, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, pipeline, AggregationLevel.DATABASE, this.retryReads, this.timeoutSettings);
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, this.name, this.codecRegistry, this.readPreference, this.readConcern, this.executor, pipeline, resultClass, ChangeStreamLevel.DATABASE, this.retryReads, this.timeoutSettings);
    }

    private void executeCreateView(@Nullable ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        Assertions.notNull("createViewOptions", createViewOptions);
        this.getExecutor().execute(this.operations.createView(viewName, viewOn, pipeline, createViewOptions), this.readConcern, clientSession);
    }

    private OperationExecutor getExecutor() {
        return this.executor.withTimeoutSettings(this.timeoutSettings);
    }
}

