/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.model;

import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.TimeSeriesGranularity;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class TimeSeriesOptions {
    private final String timeField;
    private String metaField;
    private TimeSeriesGranularity granularity;
    private Long bucketMaxSpanSeconds;
    private Long bucketRoundingSeconds;

    public TimeSeriesOptions(String timeField) {
        this.timeField = Assertions.notNull("timeField", timeField);
    }

    public String getTimeField() {
        return this.timeField;
    }

    @Nullable
    public String getMetaField() {
        return this.metaField;
    }

    public TimeSeriesOptions metaField(@Nullable String metaField) {
        this.metaField = metaField;
        return this;
    }

    @Nullable
    public TimeSeriesGranularity getGranularity() {
        return this.granularity;
    }

    public TimeSeriesOptions granularity(@Nullable TimeSeriesGranularity granularity) {
        Assertions.isTrue("granularity is not allowed when bucketMaxSpan is set", this.bucketMaxSpanSeconds == null);
        Assertions.isTrue("granularity is not allowed when bucketRounding is set", this.bucketRoundingSeconds == null);
        this.granularity = granularity;
        return this;
    }

    @Nullable
    public Long getBucketMaxSpan(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.bucketMaxSpanSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.bucketMaxSpanSeconds, TimeUnit.SECONDS);
    }

    public TimeSeriesOptions bucketMaxSpan(@Nullable Long bucketMaxSpan, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (bucketMaxSpan == null) {
            this.bucketMaxSpanSeconds = null;
        } else {
            Assertions.isTrue("bucketMaxSpan is not allowed when granularity is set", this.granularity == null);
            long seconds = TimeUnit.SECONDS.convert(bucketMaxSpan, timeUnit);
            Assertions.isTrueArgument("bucketMaxSpan, after conversion to seconds, must be >= 1", seconds > 0L);
            this.bucketMaxSpanSeconds = seconds;
        }
        return this;
    }

    @Nullable
    public Long getBucketRounding(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.bucketRoundingSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.bucketRoundingSeconds, TimeUnit.SECONDS);
    }

    public TimeSeriesOptions bucketRounding(@Nullable Long bucketRounding, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (bucketRounding == null) {
            this.bucketRoundingSeconds = null;
        } else {
            Assertions.isTrue("bucketRounding is not allowed when granularity is set", this.granularity == null);
            long seconds = TimeUnit.SECONDS.convert(bucketRounding, timeUnit);
            Assertions.isTrueArgument("bucketRounding, after conversion to seconds, must be >= 1", seconds > 0L);
            this.bucketRoundingSeconds = seconds;
        }
        return this;
    }

    public String toString() {
        return "TimeSeriesOptions{timeField='" + this.timeField + '\'' + ", metaField='" + this.metaField + '\'' + ", granularity=" + (Object)((Object)this.granularity) + ", bucketMaxSpanSeconds=" + this.bucketMaxSpanSeconds + ", bucketRoundingSeconds=" + this.bucketRoundingSeconds + '}';
    }
}

