/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.model.search;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonDouble;
import com.dre.brewery.depend.bson.Document;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.mongodb.annotations.Beta;
import com.dre.brewery.depend.mongodb.annotations.Reason;
import com.dre.brewery.depend.mongodb.annotations.Sealed;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.search.ConstantSearchScore;
import com.dre.brewery.depend.mongodb.client.model.search.FieldSearchPath;
import com.dre.brewery.depend.mongodb.client.model.search.FunctionSearchScore;
import com.dre.brewery.depend.mongodb.client.model.search.PathBoostSearchScore;
import com.dre.brewery.depend.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.dre.brewery.depend.mongodb.client.model.search.SearchScoreExpression;
import com.dre.brewery.depend.mongodb.client.model.search.ValueBoostSearchScore;

@Sealed
@Beta(value={Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", path).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", score));
    }
}

