/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.async.function;

import com.dre.brewery.depend.mongodb.annotations.NotThreadSafe;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.function.AsyncCallbackRunnable;
import com.dre.brewery.depend.mongodb.internal.async.function.LoopState;
import com.dre.brewery.depend.mongodb.lang.Nullable;

@NotThreadSafe
public final class AsyncCallbackLoop
implements AsyncCallbackRunnable {
    private final LoopState state;
    private final AsyncCallbackRunnable body;

    public AsyncCallbackLoop(LoopState state, AsyncCallbackRunnable body) {
        this.state = state;
        this.body = body;
    }

    @Override
    public void run(SingleResultCallback<Void> callback) {
        this.body.run(new LoopingCallback(callback));
    }

    @NotThreadSafe
    private class LoopingCallback
    implements SingleResultCallback<Void> {
        private final SingleResultCallback<Void> wrapped;

        LoopingCallback(SingleResultCallback<Void> callback) {
            this.wrapped = callback;
        }

        @Override
        public void onResult(@Nullable Void result, @Nullable Throwable t) {
            if (t != null) {
                this.wrapped.onResult(null, t);
            } else {
                boolean continueLooping;
                try {
                    continueLooping = AsyncCallbackLoop.this.state.advance();
                }
                catch (Throwable e) {
                    this.wrapped.onResult(null, e);
                    return;
                }
                if (continueLooping) {
                    AsyncCallbackLoop.this.body.run(this);
                } else {
                    this.wrapped.onResult(result, null);
                }
            }
        }
    }
}

