/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.binding;

import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.internal.binding.AbstractReferenceCounted;
import com.dre.brewery.depend.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.dre.brewery.depend.mongodb.internal.binding.ConnectionSource;
import com.dre.brewery.depend.mongodb.internal.binding.ReadWriteBinding;
import com.dre.brewery.depend.mongodb.internal.connection.Cluster;
import com.dre.brewery.depend.mongodb.internal.connection.Connection;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.connection.Server;
import com.dre.brewery.depend.mongodb.internal.connection.ServerTuple;
import com.dre.brewery.depend.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.dre.brewery.depend.mongodb.internal.selector.ReadPreferenceWithFallbackServerSelector;
import com.dre.brewery.depend.mongodb.internal.selector.ServerAddressSelector;
import com.dre.brewery.depend.mongodb.internal.selector.WritableServerSelector;
import java.util.concurrent.TimeUnit;

public class ClusterBinding
extends AbstractReferenceCounted
implements ClusterAwareReadWriteBinding {
    private final Cluster cluster;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final OperationContext operationContext;

    public ClusterBinding(Cluster cluster, ReadPreference readPreference, ReadConcern readConcern, OperationContext operationContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.operationContext = Assertions.notNull("operationContext", operationContext);
    }

    @Override
    public ReadWriteBinding retain() {
        super.retain();
        return this;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ReadPreferenceServerSelector(this.readPreference), this.operationContext), this.readPreference);
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        if (this.cluster.getSettings().getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            return this.getReadConnectionSource();
        }
        ReadPreferenceWithFallbackServerSelector readPreferenceWithFallbackServerSelector = new ReadPreferenceWithFallbackServerSelector(this.readPreference, minWireVersion, fallbackReadPreference);
        ServerTuple serverTuple = this.cluster.selectServer(readPreferenceWithFallbackServerSelector, this.operationContext);
        return new ClusterBindingConnectionSource(serverTuple, readPreferenceWithFallbackServerSelector.getAppliedReadPreference());
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new WritableServerSelector(), this.operationContext), this.readPreference);
    }

    @Override
    public ConnectionSource getConnectionSource(ServerAddress serverAddress) {
        return new ClusterBindingConnectionSource(this.cluster.selectServer(new ServerAddressSelector(serverAddress), this.operationContext), this.readPreference);
    }

    private final class ClusterBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final Server server;
        private final ServerDescription serverDescription;
        private final ReadPreference appliedReadPreference;

        private ClusterBindingConnectionSource(ServerTuple serverTuple, ReadPreference appliedReadPreference) {
            this.server = serverTuple.getServer();
            this.serverDescription = serverTuple.getServerDescription();
            this.appliedReadPreference = appliedReadPreference;
            ClusterBinding.this.operationContext.getTimeoutContext().minRoundTripTimeMS(TimeUnit.NANOSECONDS.toMillis(this.serverDescription.getMinRoundTripTimeNanos()));
            ClusterBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public OperationContext getOperationContext() {
            return ClusterBinding.this.operationContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return this.appliedReadPreference;
        }

        @Override
        public Connection getConnection() {
            return this.server.getConnection(ClusterBinding.this.operationContext);
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            ClusterBinding.this.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            ClusterBinding.this.release();
            return count;
        }
    }
}

