/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.binding;

import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.internal.binding.AbstractReferenceCounted;
import com.dre.brewery.depend.mongodb.internal.binding.ConnectionSource;
import com.dre.brewery.depend.mongodb.internal.binding.ReadWriteBinding;
import com.dre.brewery.depend.mongodb.internal.connection.Cluster;
import com.dre.brewery.depend.mongodb.internal.connection.Connection;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.connection.ServerTuple;
import com.dre.brewery.depend.mongodb.internal.selector.ServerAddressSelector;

public class SingleServerBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final Cluster cluster;
    private final ServerAddress serverAddress;
    private final OperationContext operationContext;

    public SingleServerBinding(Cluster cluster, ServerAddress serverAddress, OperationContext operationContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
        this.operationContext = Assertions.notNull("operationContext", operationContext);
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new SingleServerBindingConnectionSource();
    }

    @Override
    public ReadPreference getReadPreference() {
        return ReadPreference.primary();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new SingleServerBindingConnectionSource();
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public SingleServerBinding retain() {
        super.retain();
        return this;
    }

    private final class SingleServerBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final ServerDescription serverDescription;

        private SingleServerBindingConnectionSource() {
            SingleServerBinding.this.retain();
            ServerTuple serverTuple = SingleServerBinding.this.cluster.selectServer(new ServerAddressSelector(SingleServerBinding.this.serverAddress), SingleServerBinding.this.operationContext);
            this.serverDescription = serverTuple.getServerDescription();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public OperationContext getOperationContext() {
            return SingleServerBinding.this.operationContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return ReadPreference.primary();
        }

        @Override
        public Connection getConnection() {
            return SingleServerBinding.this.cluster.selectServer(new ServerAddressSelector(SingleServerBinding.this.serverAddress), SingleServerBinding.this.operationContext).getServer().getConnection(SingleServerBinding.this.operationContext);
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            if (count == 0) {
                SingleServerBinding.this.release();
            }
            return count;
        }
    }
}

