/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.SocketSettings;
import com.dre.brewery.depend.mongodb.connection.SslSettings;
import com.dre.brewery.depend.mongodb.internal.connection.AsynchronousSocketChannelStream;
import com.dre.brewery.depend.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.dre.brewery.depend.mongodb.internal.connection.Stream;
import com.dre.brewery.depend.mongodb.internal.connection.StreamFactory;
import com.dre.brewery.depend.mongodb.spi.dns.InetAddressResolver;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final PowerOfTwoBufferPool bufferProvider = PowerOfTwoBufferPool.DEFAULT;
    private final SocketSettings settings;
    private final InetAddressResolver inetAddressResolver;

    public AsynchronousSocketChannelStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings) {
        Assertions.assertFalse(sslSettings.isEnabled());
        this.inetAddressResolver = inetAddressResolver;
        this.settings = Assertions.notNull("settings", settings);
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.inetAddressResolver, this.settings, this.bufferProvider);
    }
}

