/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.mongodb.MongoCompressor;
import com.dre.brewery.depend.mongodb.MongoCredential;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.MongoSecurityException;
import com.dre.brewery.depend.mongodb.ServerApi;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.connection.ConnectionId;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.connection.Authenticator;
import com.dre.brewery.depend.mongodb.internal.connection.CommandHelper;
import com.dre.brewery.depend.mongodb.internal.connection.DefaultAuthenticator;
import com.dre.brewery.depend.mongodb.internal.connection.DescriptionHelper;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnection;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnectionInitializationDescription;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnectionInitializer;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.connection.SpeculativeAuthenticator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.List;

public class InternalStreamConnectionInitializer
implements InternalConnectionInitializer {
    private static final int INITIAL_MIN_RTT = 0;
    private final ClusterConnectionMode clusterConnectionMode;
    private final Authenticator authenticator;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> requestedCompressors;
    private final boolean checkSaslSupportedMechs;
    private final ServerApi serverApi;

    public InternalStreamConnectionInitializer(ClusterConnectionMode clusterConnectionMode, @Nullable Authenticator authenticator, @Nullable BsonDocument clientMetadataDocument, List<MongoCompressor> requestedCompressors, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.authenticator = authenticator;
        this.clientMetadataDocument = clientMetadataDocument;
        this.requestedCompressors = Assertions.notNull("requestedCompressors", requestedCompressors);
        this.checkSaslSupportedMechs = authenticator instanceof DefaultAuthenticator;
        this.serverApi = serverApi;
    }

    @Override
    public InternalConnectionInitializationDescription startHandshake(InternalConnection internalConnection, OperationContext operationContext) {
        Assertions.notNull("internalConnection", internalConnection);
        return this.initializeConnectionDescription(internalConnection, operationContext);
    }

    @Override
    public InternalConnectionInitializationDescription finishHandshake(InternalConnection internalConnection, InternalConnectionInitializationDescription description, OperationContext operationContext) {
        Assertions.notNull("internalConnection", internalConnection);
        Assertions.notNull("description", description);
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        if (Authenticator.shouldAuthenticate(this.authenticator, connectionDescription)) {
            this.authenticator.authenticate(internalConnection, connectionDescription, operationContext);
        }
        return this.completeConnectionDescriptionInitialization(internalConnection, description, operationContext);
    }

    @Override
    public void startHandshakeAsync(InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        long startTime = System.nanoTime();
        CommandHelper.executeCommandAsync("admin", this.createHelloCommand(this.authenticator, internalConnection), this.clusterConnectionMode, this.serverApi, internalConnection, operationContext, (helloResult, t) -> {
            if (t != null) {
                callback.onResult(null, t instanceof MongoException ? this.mapHelloException((MongoException)t) : t);
            } else {
                InternalConnectionInitializationDescription initializationDescription;
                this.setSpeculativeAuthenticateResponse((BsonDocument)helloResult);
                try {
                    initializationDescription = this.createInitializationDescription((BsonDocument)helloResult, internalConnection, startTime);
                }
                catch (Throwable localThrowable) {
                    callback.onResult(null, localThrowable);
                    return;
                }
                callback.onResult(initializationDescription, null);
            }
        });
    }

    @Override
    public void finishHandshakeAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription description, OperationContext operationContext, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        if (!Authenticator.shouldAuthenticate(this.authenticator, connectionDescription)) {
            this.completeConnectionDescriptionInitializationAsync(internalConnection, description, operationContext, callback);
        } else {
            this.authenticator.authenticateAsync(internalConnection, connectionDescription, operationContext, (result1, t1) -> {
                if (t1 != null) {
                    callback.onResult(null, t1);
                } else {
                    this.completeConnectionDescriptionInitializationAsync(internalConnection, description, operationContext, callback);
                }
            });
        }
    }

    private InternalConnectionInitializationDescription initializeConnectionDescription(InternalConnection internalConnection, OperationContext operationContext) {
        BsonDocument helloResult;
        BsonDocument helloCommandDocument = this.createHelloCommand(this.authenticator, internalConnection);
        long start = System.nanoTime();
        try {
            helloResult = CommandHelper.executeCommand("admin", helloCommandDocument, this.clusterConnectionMode, this.serverApi, internalConnection, operationContext);
        }
        catch (MongoException e) {
            throw this.mapHelloException(e);
        }
        finally {
            operationContext.getTimeoutContext().resetMaintenanceTimeout();
        }
        this.setSpeculativeAuthenticateResponse(helloResult);
        return this.createInitializationDescription(helloResult, internalConnection, start);
    }

    private MongoException mapHelloException(MongoException e) {
        if (this.checkSaslSupportedMechs && e.getCode() == 11) {
            MongoCredential credential = this.authenticator.getMongoCredential();
            return new MongoSecurityException(credential, String.format("Exception authenticating %s", credential), (Throwable)e);
        }
        return e;
    }

    private InternalConnectionInitializationDescription createInitializationDescription(BsonDocument helloResult, InternalConnection internalConnection, long startTime) {
        ConnectionId connectionId = internalConnection.getDescription().getConnectionId();
        ConnectionDescription connectionDescription = DescriptionHelper.createConnectionDescription(this.clusterConnectionMode, connectionId, helloResult);
        ServerDescription serverDescription = DescriptionHelper.createServerDescription(internalConnection.getDescription().getServerAddress(), helloResult, System.nanoTime() - startTime, 0L);
        return new InternalConnectionInitializationDescription(connectionDescription, serverDescription);
    }

    private BsonDocument createHelloCommand(Authenticator authenticator, InternalConnection connection) {
        BsonDocument speculativeAuthenticateDocument;
        BsonDocument helloCommandDocument = new BsonDocument(this.getHandshakeCommandName(), new BsonInt32(1)).append("helloOk", BsonBoolean.TRUE);
        if (this.clientMetadataDocument != null) {
            helloCommandDocument.append("client", this.clientMetadataDocument);
        }
        if (this.clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            helloCommandDocument.append("loadBalanced", BsonBoolean.TRUE);
        }
        if (!this.requestedCompressors.isEmpty()) {
            BsonArray compressors = new BsonArray(this.requestedCompressors.size());
            for (MongoCompressor cur : this.requestedCompressors) {
                compressors.add(new BsonString(cur.getName()));
            }
            helloCommandDocument.append("compression", compressors);
        }
        if (this.checkSaslSupportedMechs) {
            MongoCredential credential = authenticator.getMongoCredential();
            helloCommandDocument.append("saslSupportedMechs", new BsonString(credential.getSource() + "." + credential.getUserName()));
        }
        if (authenticator instanceof SpeculativeAuthenticator && (speculativeAuthenticateDocument = ((SpeculativeAuthenticator)((Object)authenticator)).createSpeculativeAuthenticateCommand(connection)) != null) {
            helloCommandDocument.append("speculativeAuthenticate", speculativeAuthenticateDocument);
        }
        return helloCommandDocument;
    }

    private InternalConnectionInitializationDescription completeConnectionDescriptionInitialization(InternalConnection internalConnection, InternalConnectionInitializationDescription description, OperationContext operationContext) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            return description;
        }
        return this.applyGetLastErrorResult(CommandHelper.executeCommandWithoutCheckingForFailure("admin", new BsonDocument("getlasterror", new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection, operationContext), description);
    }

    private void setSpeculativeAuthenticateResponse(BsonDocument helloResult) {
        if (this.authenticator instanceof SpeculativeAuthenticator) {
            ((SpeculativeAuthenticator)((Object)this.authenticator)).setSpeculativeAuthenticateResponse(helloResult.getDocument("speculativeAuthenticate", null));
        }
    }

    private void completeConnectionDescriptionInitializationAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription description, OperationContext operationContext, SingleResultCallback<InternalConnectionInitializationDescription> callback) {
        if (description.getConnectionDescription().getConnectionId().getServerValue() != null) {
            callback.onResult(description, null);
            return;
        }
        CommandHelper.executeCommandAsync("admin", new BsonDocument("getlasterror", new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection, operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(description, null);
            } else {
                callback.onResult(this.applyGetLastErrorResult((BsonDocument)result, description), null);
            }
        });
    }

    private InternalConnectionInitializationDescription applyGetLastErrorResult(BsonDocument getLastErrorResult, InternalConnectionInitializationDescription description) {
        ConnectionDescription connectionDescription = description.getConnectionDescription();
        ConnectionId connectionId = getLastErrorResult.containsKey("connectionId") ? connectionDescription.getConnectionId().withServerValue(getLastErrorResult.getNumber("connectionId").longValue()) : connectionDescription.getConnectionId();
        return description.withConnectionDescription(connectionDescription.withConnectionId(connectionId));
    }

    private String getHandshakeCommandName() {
        return this.serverApi == null ? "isMaster" : "hello";
    }
}

