/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.bson.types.ObjectId;
import com.dre.brewery.depend.mongodb.MongoCommandException;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.MongoNodeIsRecoveringException;
import com.dre.brewery.depend.mongodb.MongoNotPrimaryException;
import com.dre.brewery.depend.mongodb.MongoSocketException;
import com.dre.brewery.depend.mongodb.MongoSocketReadTimeoutException;
import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ServerConnectionState;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.connection.ServerId;
import com.dre.brewery.depend.mongodb.connection.ServerType;
import com.dre.brewery.depend.mongodb.event.ServerClosedEvent;
import com.dre.brewery.depend.mongodb.event.ServerDescriptionChangedEvent;
import com.dre.brewery.depend.mongodb.event.ServerListener;
import com.dre.brewery.depend.mongodb.event.ServerOpeningEvent;
import com.dre.brewery.depend.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.connection.AbstractProtocolExecutor;
import com.dre.brewery.depend.mongodb.internal.connection.AsyncConnection;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterClock;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterableServer;
import com.dre.brewery.depend.mongodb.internal.connection.CommandProtocol;
import com.dre.brewery.depend.mongodb.internal.connection.Connection;
import com.dre.brewery.depend.mongodb.internal.connection.ConnectionFactory;
import com.dre.brewery.depend.mongodb.internal.connection.ConnectionPool;
import com.dre.brewery.depend.mongodb.internal.connection.InternalConnection;
import com.dre.brewery.depend.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Logger;
import com.dre.brewery.depend.mongodb.internal.diagnostics.logging.Loggers;
import com.dre.brewery.depend.mongodb.internal.session.SessionContext;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class LoadBalancedServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ConnectionFactory connectionFactory;
    private final ServerListener serverListener;
    private final ClusterClock clusterClock;

    public LoadBalancedServer(ServerId serverId, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerListener serverListener, ClusterClock clusterClock) {
        this.serverId = serverId;
        this.connectionPool = connectionPool;
        this.connectionFactory = connectionFactory;
        this.serverListener = serverListener;
        this.clusterClock = clusterClock;
        serverListener.serverOpening(new ServerOpeningEvent(serverId));
        serverListener.serverDescriptionChanged(new ServerDescriptionChangedEvent(serverId, ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(serverId.getAddress()).build(), ServerDescription.builder().address(serverId.getAddress()).state(ServerConnectionState.CONNECTING).build()));
    }

    @Override
    public void resetToConnecting() {
    }

    @Override
    public void invalidate() {
    }

    private void invalidate(Throwable t, @Nullable ObjectId serviceId, int generation) {
        if (!this.isClosed()) {
            if (t instanceof MongoSocketException && !(t instanceof MongoSocketReadTimeoutException)) {
                if (serviceId != null) {
                    this.connectionPool.invalidate(serviceId, generation);
                }
            } else if ((t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) && SHUTDOWN_CODES.contains(((MongoCommandException)t).getErrorCode()) && serviceId != null) {
                this.connectionPool.invalidate(serviceId, generation);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.connectionPool.close();
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void connect() {
    }

    @Override
    public Connection getConnection(OperationContext operationContext) {
        Assertions.isTrue("open", !this.isClosed());
        return this.connectionFactory.create(this.connectionPool.get(operationContext), new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED);
    }

    @Override
    public void getConnectionAsync(OperationContext operationContext, SingleResultCallback<AsyncConnection> callback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync(operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.connectionFactory.createAsync((InternalConnection)result, new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return -1;
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private class LoadBalancedServerProtocolExecutor
    extends AbstractProtocolExecutor {
        private LoadBalancedServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            try {
                return protocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock)).execute(connection);
            }
            catch (MongoWriteConcernWithResponseException e) {
                return (T)e.getResponse();
            }
            catch (MongoException e) {
                this.handleExecutionException(connection, sessionContext, e);
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext, SingleResultCallback<T> callback) {
            protocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock)).executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
                if (t != null) {
                    if (t instanceof MongoWriteConcernWithResponseException) {
                        callback.onResult(((MongoWriteConcernWithResponseException)t).getResponse(), null);
                    } else {
                        this.handleExecutionException(connection, sessionContext, t);
                        callback.onResult(null, t);
                    }
                } else {
                    callback.onResult(result, null);
                }
            }, LOGGER));
        }

        private void handleExecutionException(InternalConnection connection, SessionContext sessionContext, Throwable t) {
            LoadBalancedServer.this.invalidate(t, connection.getDescription().getServiceId(), connection.getGeneration());
            if (this.shouldMarkSessionDirty(t, sessionContext)) {
                sessionContext.markSessionDirty();
            }
        }
    }
}

