/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.UnixServerAddress;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.SocketSettings;
import com.dre.brewery.depend.mongodb.connection.SslSettings;
import com.dre.brewery.depend.mongodb.internal.connection.BufferProvider;
import com.dre.brewery.depend.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.dre.brewery.depend.mongodb.internal.connection.SocketStream;
import com.dre.brewery.depend.mongodb.internal.connection.Stream;
import com.dre.brewery.depend.mongodb.internal.connection.StreamFactory;
import com.dre.brewery.depend.mongodb.internal.connection.UnixSocketChannelStream;
import com.dre.brewery.depend.mongodb.spi.dns.InetAddressResolver;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class SocketStreamFactory
implements StreamFactory {
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final BufferProvider bufferProvider = PowerOfTwoBufferPool.DEFAULT;

    public SocketStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings settings, SslSettings sslSettings) {
        this.inetAddressResolver = inetAddressResolver;
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        SocketStream stream;
        if (serverAddress instanceof UnixServerAddress) {
            if (this.sslSettings.isEnabled()) {
                throw new MongoClientException("Socket based connections do not support ssl");
            }
            stream = new UnixSocketChannelStream((UnixServerAddress)serverAddress, this.settings, this.sslSettings, this.bufferProvider);
        } else {
            stream = this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, this.getSslContext().getSocketFactory(), this.bufferProvider) : new SocketStream(serverAddress, this.inetAddressResolver, this.settings, this.sslSettings, SocketFactory.getDefault(), this.bufferProvider);
        }
        return stream;
    }

    private SSLContext getSslContext() {
        try {
            return Optional.ofNullable(this.sslSettings.getContext()).orElse(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MongoClientException("Unable to create default SSLContext", e);
        }
    }
}

