/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.connection;

import com.dre.brewery.depend.mongodb.MongoCompressor;
import com.dre.brewery.depend.mongodb.internal.connection.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

class ZlibCompressor
extends Compressor {
    private final int level;

    ZlibCompressor(MongoCompressor mongoCompressor) {
        this.level = mongoCompressor.getPropertyNonNull("LEVEL", -1);
    }

    @Override
    public String getName() {
        return "zlib";
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    InputStream getInputStream(InputStream source) {
        return new InflaterInputStream(source);
    }

    @Override
    OutputStream getOutputStream(OutputStream source) {
        return new DeflaterOutputStream(source, new Deflater(this.level)){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    this.def.end();
                }
            }
        };
    }
}

