/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.FieldNameValidator;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.Collation;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.internal.operation.BaseFindAndModifyOperation;
import com.dre.brewery.depend.mongodb.internal.operation.DocumentHelper;
import com.dre.brewery.depend.mongodb.internal.validator.MappedFieldNameValidator;
import com.dre.brewery.depend.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dre.brewery.depend.mongodb.internal.validator.UpdateFieldNameValidator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public class FindAndUpdateOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final BsonDocument update;
    private final List<BsonDocument> updatePipeline;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;
    private List<BsonDocument> arrayFilters;

    public FindAndUpdateOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder, BsonDocument update) {
        super(namespace, writeConcern, retryWrites, decoder);
        this.update = Assertions.notNull("update", update);
        this.updatePipeline = null;
    }

    public FindAndUpdateOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder, List<BsonDocument> update) {
        super(namespace, writeConcern, retryWrites, decoder);
        this.updatePipeline = update;
        this.update = null;
    }

    @Nullable
    public BsonDocument getUpdate() {
        return this.update;
    }

    @Nullable
    public List<BsonDocument> getUpdatePipeline() {
        return this.updatePipeline;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndUpdateOperation<T> returnOriginal(boolean returnOriginal) {
        this.returnOriginal = returnOriginal;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndUpdateOperation<T> upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndUpdateOperation<T> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public FindAndUpdateOperation<T> arrayFilters(@Nullable List<BsonDocument> arrayFilters) {
        this.arrayFilters = arrayFilters;
        return this;
    }

    public List<BsonDocument> getArrayFilters() {
        return this.arrayFilters;
    }

    @Override
    public FindAndUpdateOperation<T> filter(@Nullable BsonDocument filter) {
        super.filter(filter);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> projection(@Nullable BsonDocument projection) {
        super.projection(projection);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> sort(@Nullable BsonDocument sort) {
        super.sort(sort);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> hint(@Nullable BsonDocument hint) {
        super.hint(hint);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> hintString(@Nullable String hint) {
        super.hintString(hint);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> collation(@Nullable Collation collation) {
        super.collation(collation);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> comment(@Nullable BsonValue comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public FindAndUpdateOperation<T> let(@Nullable BsonDocument variables) {
        super.let(variables);
        return this;
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        return new MappedFieldNameValidator(NoOpFieldNameValidator.INSTANCE, Collections.singletonMap("update", new UpdateFieldNameValidator()));
    }

    @Override
    protected void specializeCommand(BsonDocument commandDocument, ConnectionDescription connectionDescription) {
        commandDocument.put("new", new BsonBoolean(!this.isReturnOriginal()));
        DocumentHelper.putIfTrue(commandDocument, "upsert", this.isUpsert());
        if (this.getUpdatePipeline() != null) {
            commandDocument.put("update", new BsonArray(this.getUpdatePipeline()));
        } else {
            DocumentHelper.putIfNotNull(commandDocument, "update", this.getUpdate());
        }
        if (this.bypassDocumentValidation != null) {
            commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
        }
        if (this.arrayFilters != null) {
            commandDocument.put("arrayFilters", new BsonArray(this.arrayFilters));
        }
    }
}

