/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonJavaScript;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.ExplainVerbosity;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.Collation;
import com.dre.brewery.depend.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncReadBinding;
import com.dre.brewery.depend.mongodb.internal.binding.ReadBinding;
import com.dre.brewery.depend.mongodb.internal.connection.CommandHelper;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.dre.brewery.depend.mongodb.internal.operation.CommandOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.CommandReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultDocumentCodec;
import com.dre.brewery.depend.mongodb.internal.operation.DocumentHelper;
import com.dre.brewery.depend.mongodb.internal.operation.ExplainHelper;
import com.dre.brewery.depend.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.MapReduceBatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.MapReduceHelper;
import com.dre.brewery.depend.mongodb.internal.operation.MapReduceInlineResultsAsyncCursor;
import com.dre.brewery.depend.mongodb.internal.operation.MapReduceInlineResultsCursor;
import com.dre.brewery.depend.mongodb.internal.operation.OperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.OperationReadConcernHelper;
import com.dre.brewery.depend.mongodb.internal.operation.ReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.SingleBatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperationHelper;
import com.dre.brewery.depend.mongodb.lang.Nullable;

public class MapReduceWithInlineResultsOperation<T>
implements AsyncReadOperation<MapReduceAsyncBatchCursor<T>>,
ReadOperation<MapReduceBatchCursor<T>> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final Decoder<T> decoder;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private Collation collation;

    public MapReduceWithInlineResultsOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceWithInlineResultsOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceWithInlineResultsOperation<T> scope(@Nullable BsonDocument scope) {
        this.scope = scope;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceWithInlineResultsOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceWithInlineResultsOperation<T> sort(@Nullable BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceWithInlineResultsOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceWithInlineResultsOperation<T> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceWithInlineResultsOperation<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceWithInlineResultsOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public MapReduceBatchCursor<T> execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "results"), this.transformer(), false);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<MapReduceAsyncBatchCursor<T>> callback) {
        SingleResultCallback<MapReduceAsyncBatchCursor<T>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "results"), this.asyncTransformer(), false, errHandlingCallback);
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = this.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), command);
            return ExplainHelper.asExplainCommand(command, explainVerbosity);
        }, new BsonDocumentCodec());
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, MapReduceBatchCursor<T>> transformer() {
        return (result, source, connection) -> new MapReduceInlineResultsCursor(new SingleBatchCursor(BsonDocumentWrapperHelper.toList(result, "results"), 0, connection.getDescription().getServerAddress()), MapReduceHelper.createStatistics(result));
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, MapReduceAsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> new MapReduceInlineResultsAsyncCursor(new AsyncSingleBatchCursor(BsonDocumentWrapperHelper.toList(result, "results"), 0), MapReduceHelper.createStatistics(result));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument commandDocument = new BsonDocument("mapReduce", new BsonString(this.namespace.getCollectionName())).append("map", this.getMapFunction()).append("reduce", this.getReduceFunction()).append("out", new BsonDocument("inline", new BsonInt32(1)));
            DocumentHelper.putIfNotNull(commandDocument, "query", this.getFilter());
            DocumentHelper.putIfNotNull(commandDocument, "sort", this.getSort());
            DocumentHelper.putIfNotNull(commandDocument, "finalize", this.getFinalizeFunction());
            DocumentHelper.putIfNotNull(commandDocument, "scope", this.getScope());
            DocumentHelper.putIfTrue(commandDocument, "verbose", this.isVerbose());
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), commandDocument);
            DocumentHelper.putIfNotZero(commandDocument, "limit", this.getLimit());
            DocumentHelper.putIfTrue(commandDocument, "jsMode", this.isJsMode());
            if (this.collation != null) {
                commandDocument.put("collation", this.collation.asDocument());
            }
            return commandDocument;
        };
    }
}

