/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.ServerCursor;
import com.dre.brewery.depend.mongodb.internal.operation.BatchCursor;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

class SingleBatchCursor<T>
implements BatchCursor<T> {
    private final List<T> batch;
    private final ServerAddress serverAddress;
    private final int batchSize;
    private boolean hasNext;

    static <R> SingleBatchCursor<R> createEmptySingleBatchCursor(ServerAddress serverAddress, int batchSize) {
        return new SingleBatchCursor(Collections.emptyList(), batchSize, serverAddress);
    }

    SingleBatchCursor(List<T> batch, int batchSize, ServerAddress serverAddress) {
        this.batch = batch;
        this.serverAddress = serverAddress;
        this.batchSize = batchSize;
        this.hasNext = !batch.isEmpty();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public List<T> next() {
        if (this.hasNext) {
            this.hasNext = false;
            return this.batch;
        }
        throw new NoSuchElementException();
    }

    @Override
    public int available() {
        return this.hasNext ? 1 : 0;
    }

    @Override
    public void setBatchSize(int batchSize) {
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public List<T> tryNext() {
        return this.hasNext ? this.next() : null;
    }

    @Override
    public ServerCursor getServerCursor() {
        return null;
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public void close() {
    }
}

