/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.selector;

import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.connection.ClusterDescription;
import com.dre.brewery.depend.mongodb.connection.ServerConnectionState;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.dre.brewery.depend.mongodb.selector.ServerSelector;
import java.util.List;

public class ReadPreferenceWithFallbackServerSelector
implements ServerSelector {
    private final ReadPreference preferredReadPreference;
    private final int minWireVersion;
    private final ReadPreference fallbackReadPreference;
    private ReadPreference appliedReadPreference;

    public ReadPreferenceWithFallbackServerSelector(ReadPreference preferredReadPreference, int minWireVersion, ReadPreference fallbackReadPreference) {
        this.preferredReadPreference = preferredReadPreference;
        this.minWireVersion = minWireVersion;
        this.fallbackReadPreference = fallbackReadPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (this.clusterContainsOlderServers(clusterDescription)) {
            this.appliedReadPreference = this.fallbackReadPreference;
            return new ReadPreferenceServerSelector(this.fallbackReadPreference).select(clusterDescription);
        }
        this.appliedReadPreference = this.preferredReadPreference;
        return new ReadPreferenceServerSelector(this.preferredReadPreference).select(clusterDescription);
    }

    public ReadPreference getAppliedReadPreference() {
        return this.appliedReadPreference;
    }

    private boolean clusterContainsOlderServers(ClusterDescription clusterDescription) {
        return clusterDescription.getServerDescriptions().stream().filter(serverDescription -> serverDescription.getState() == ServerConnectionState.CONNECTED).anyMatch(serverDescription -> serverDescription.getMaxWireVersion() < this.minWireVersion);
    }

    public String toString() {
        return "ReadPreferenceWithFallbackServerSelector{preferredReadPreference=" + this.preferredReadPreference + ", fallbackReadPreference=" + this.fallbackReadPreference + ", minWireVersionForPreferred=" + this.minWireVersion + '}';
    }
}

