/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.validator;

import com.dre.brewery.depend.bson.FieldNameValidator;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.internal.validator.NoOpFieldNameValidator;

public final class UpdateFieldNameValidator
implements FieldNameValidator {
    private boolean encounteredField = false;

    @Override
    public boolean validate(String fieldName) {
        this.encounteredField = true;
        return fieldName.startsWith("$");
    }

    @Override
    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(fieldName.startsWith("$"));
        return String.format("All update operators must start with '$', but '%s' does not", fieldName);
    }

    @Override
    public FieldNameValidator getValidatorForField(String fieldName) {
        return NoOpFieldNameValidator.INSTANCE;
    }

    @Override
    public void start() {
        this.encounteredField = false;
    }

    @Override
    public void end() {
        if (!this.encounteredField) {
            throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
        }
    }
}

