/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.integration.Hook;
import com.dre.brewery.integration.barrel.WGBarrel;
import com.dre.brewery.integration.barrel.WGBarrel5;
import com.dre.brewery.integration.barrel.WGBarrel6;
import com.dre.brewery.integration.barrel.WGBarrel7;
import com.dre.brewery.utility.Logging;
import org.bukkit.plugin.Plugin;

public class WorldGuarkHook
extends Hook {
    public static final WorldGuarkHook WORLDGUARD = new WorldGuarkHook("WorldGuard", config.isUseWorldGuard());
    private WGBarrel wgBarrel;

    public WorldGuarkHook(String name, boolean enabled) {
        super(name, enabled);
        if (!this.isEnabled()) {
            return;
        }
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            Logging.errorLog("Failed loading WorldGuard Integration! Opening Barrels will NOT work!");
            Logging.errorLog("Brewery was tested with version 5.8, 6.1 and 7.0 of WorldGuard!");
            Logging.errorLog("Disable the WorldGuard support in the config and do /brew reload");
            return;
        }
        String wgv = plugin.getDescription().getVersion();
        this.wgBarrel = wgv.startsWith("6.") ? new WGBarrel6() : (wgv.startsWith("5.") ? new WGBarrel5() : new WGBarrel7());
    }

    public WGBarrel getWgBarrel() {
        return this.wgBarrel;
    }

    public void setWgBarrel(WGBarrel wgBarrel) {
        this.wgBarrel = wgBarrel;
    }
}

