/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.BSealer;
import com.dre.brewery.Barrel;
import com.dre.brewery.BarrelAsset;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.DistortChat;
import com.dre.brewery.Wakeup;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.MaterialUtil;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.PermissionUtil;
import com.dre.brewery.utility.releases.ReleaseChecker;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerListener
implements Listener {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final Config config = ConfigManager.getConfig(Config.class);
    private static final Lang lang = ConfigManager.getConfig(Lang.class);

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        PlayerListener.handlePlayerInteract(event);
    }

    public static void handlePlayerInteract(PlayerInteractEvent event) {
        Material heldItem;
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Material type = clickedBlock.getType();
        if (type == Material.HOPPER) {
            ItemStack item;
            if (config.isBrewHopperDump() && event.getPlayer().isSneaking() && (VERSION.isOrEarlier(MinecraftVersion.V1_9) || event.getHand() == EquipmentSlot.HAND) && Brew.isBrew(item = event.getItem())) {
                event.setCancelled(true);
                BUtil.setItemInHand(event, Material.GLASS_BOTTLE, false);
                if (VERSION.isOrLater(MinecraftVersion.V1_11)) {
                    clickedBlock.getWorld().playSound(clickedBlock.getLocation(), Sound.ITEM_BOTTLE_EMPTY, 1.0f, 1.0f);
                }
            }
            return;
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_14) && BSealer.isBSealer(clickedBlock)) {
            if (player.isSneaking()) {
                event.setUseInteractedBlock(Event.Result.DENY);
                return;
            }
            event.setCancelled(true);
            if (config.isEnableSealingTable()) {
                BSealer sealer = new BSealer(player);
                event.getPlayer().openInventory(sealer.getInventory());
            } else {
                lang.sendEntry((CommandSender)player, "Error_SealingTableDisabled", new Object[0]);
            }
            return;
        }
        Material material = heldItem = event.getItem() != null ? event.getItem().getType() : null;
        if (player.isSneaking() && type != Material.BARREL && !BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, heldItem)) {
            return;
        }
        if (MaterialUtil.isWaterCauldron(type) && !player.isSneaking()) {
            BCauldron.clickCauldron(event);
            return;
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_14) && type == Material.BARREL) {
            if (!player.hasPermission("brewery.openbarrel.mc")) {
                event.setCancelled(true);
                lang.sendEntry((CommandSender)player, "Error_NoPermissions", new Object[0]);
            }
            return;
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_9) && event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (clickedBlock.getType().name().toUpperCase().contains("CUT_COPPER") && player.isSneaking()) {
            return;
        }
        Barrel barrel = null;
        if (BarrelAsset.isBarrelAsset(BarrelAsset.PLANKS, type)) {
            if (config.isOpenLargeBarrelEverywhere()) {
                barrel = Barrel.getByWood(clickedBlock);
            }
        } else if (BarrelAsset.isBarrelAsset(BarrelAsset.STAIRS, type)) {
            barrel = Barrel.getByWood(clickedBlock);
            if (barrel != null && !config.isOpenLargeBarrelEverywhere() && barrel.isLarge()) {
                barrel = null;
            }
        } else if (BarrelAsset.isBarrelAsset(BarrelAsset.FENCE, type) || BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, type)) {
            barrel = Barrel.getBySpigot(clickedBlock);
        }
        if (barrel != null) {
            event.setCancelled(true);
            if (!barrel.hasPermsOpen(player, event)) {
                return;
            }
            barrel.open(player);
            if (VERSION.isOrLater(MinecraftVersion.V1_14)) {
                Material hand = event.getMaterial();
                if ((hand == Material.POTION || hand.isEdible()) && !BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, type)) {
                    PlayerInventory inv = player.getInventory();
                    int held = inv.getHeldItemSlot();
                    int useSlot = -1;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack item = inv.getItem(i);
                        if (item == null || item.getType() == Material.AIR) {
                            useSlot = i;
                            break;
                        }
                        if (useSlot != -1 || item.getType() == hand) continue;
                        useSlot = i;
                    }
                    if (useSlot != -1) {
                        inv.setHeldItemSlot(useSlot);
                        BreweryPlugin.getScheduler().runTaskLater(() -> player.getInventory().setHeldItemSlot(held), 2L);
                    }
                }
                barrel.playOpeningSound();
            }
        }
    }

    @EventHandler
    public void onClickAir(PlayerInteractEvent event) {
        if (Wakeup.checkPlayer == null) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR && !event.hasItem() && event.getPlayer() == Wakeup.checkPlayer) {
            Wakeup.tpNext();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        BPlayer bplayer;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.getType() == Material.POTION) {
            Brew brew = Brew.get(item);
            if (brew != null) {
                if (!BPlayer.drink(brew, player, item.getItemMeta(), event)) {
                    event.setCancelled(true);
                    return;
                }
                if (VERSION.isOrLater(MinecraftVersion.V1_9)) {
                    if (player.getGameMode() != GameMode.CREATIVE) {
                        event.setItem(new ItemStack(Material.POTION));
                    } else {
                        event.setCancelled(true);
                    }
                }
            }
        } else if (BUtil.getMaterialMap(config.getDrainItems()).containsKey(item.getType()) && (bplayer = BPlayer.get((OfflinePlayer)player)) != null) {
            bplayer.drainByItem(player, item.getType());
            if (config.isShowStatusOnDrink()) {
                bplayer.showDrunkeness(player);
            }
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        BPlayer bPlayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bPlayer != null) {
            if (bPlayer.getDrunkeness() > 20) {
                bPlayer.setData(bPlayer.getDrunkeness() - 20, 0);
            } else {
                BPlayer.remove((OfflinePlayer)event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (BPlayer.hasPlayer((OfflinePlayer)event.getPlayer())) {
            BPlayer.playerMove(event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        DistortChat.playerChat(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommandPreProcess(PlayerCommandPreprocessEvent event) {
        DistortChat.playerCommand(event);
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        Player player = event.getPlayer();
        BPlayer bplayer = BPlayer.get((OfflinePlayer)player);
        if (bplayer == null) {
            return;
        }
        if (player.hasPermission("brewery.bypass.logindeny")) {
            if (bplayer.getDrunkeness() > 100) {
                bplayer.setData(100, 0);
            }
            return;
        }
        switch (bplayer.canJoin()) {
            case 2: {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, lang.getEntry("Player_LoginDeny", new Object[0]));
                break;
            }
            case 3: {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, lang.getEntry("Player_LoginDenyLong", new Object[0]));
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        BPlayer bplayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bplayer != null) {
            bplayer.join(event.getPlayer());
        }
        ReleaseChecker.getInstance().notify((CommandSender)event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        BPlayer bplayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bplayer != null) {
            bplayer.disconnecting();
        }
        PermissionUtil.logout((CommandSender)event.getPlayer());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        BPlayer bplayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bplayer != null) {
            bplayer.disconnecting();
        }
        PermissionUtil.logout((CommandSender)event.getPlayer());
    }
}

