/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import com.dre.brewery.lore.basE91;
import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base91EncoderStream
extends FilterOutputStream {
    private final basE91 encoder = new basE91();
    private byte[] buf = new byte[32];
    private byte[] encBuf = new byte[48];
    private int writer = 0;
    private int encoded = 0;

    public Base91EncoderStream(OutputStream out) {
        super(out);
    }

    private void encFlush() throws IOException {
        this.encoded = this.encoder.encode(this.buf, this.writer, this.encBuf);
        this.out.write(this.encBuf, 0, this.encoded);
        this.writer = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.buf[this.writer++] = (byte)b;
        if (this.writer >= this.buf.length) {
            this.encFlush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (len < 0 || off < 0 || off + len > b.length || off > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buf.length - this.writer >= len) {
            System.arraycopy(b, off, this.buf, this.writer, len);
            this.writer += len;
            if (this.writer >= this.buf.length) {
                this.encFlush();
            }
            return;
        }
        if (off == 0 && this.buf.length >= len) {
            this.encFlush();
            this.encoded = this.encoder.encode(b, len, this.encBuf);
            this.out.write(this.encBuf, 0, this.encoded);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(b, off, len);
        while (true) {
            this.writer += in.read(this.buf, this.writer, this.buf.length - this.writer);
            if (this.writer < this.buf.length) break;
            this.encFlush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.writer > 0) {
            this.encFlush();
        }
        this.encoded = this.encoder.encEnd(this.encBuf);
        if (this.encoded > 0) {
            this.out.write(this.encBuf, 0, this.encoded);
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.encoder.encReset();
        this.buf = null;
        this.encBuf = null;
    }
}

