/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.inventory.meta.ItemMeta;

public class LoreSaveStream
extends ByteArrayOutputStream {
    public static final String IDENTIFIER = "\u00a7%";
    private ItemMeta meta;
    private int line;
    private boolean flushed = false;

    public LoreSaveStream(ItemMeta meta) {
        this(meta, -1);
    }

    public LoreSaveStream(ItemMeta meta, int line) {
        super(128);
        this.meta = meta;
        this.line = line;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.size() <= 0) {
            return;
        }
        if (this.flushed || this.meta == null) {
            return;
        }
        this.flushed = true;
        String s = this.toString();
        StringBuilder loreLineBuilder = new StringBuilder(s.length() * 2 + 6);
        loreLineBuilder.append(IDENTIFIER);
        for (char c : s.toCharArray()) {
            loreLineBuilder.append('\u00a7').append(c);
        }
        ArrayList<String> lore = this.meta.hasLore() ? this.meta.getLore() : new ArrayList<String>();
        int prev = 0;
        Iterator iterator = lore.iterator();
        while (iterator.hasNext()) {
            if (((String)iterator.next()).startsWith(IDENTIFIER)) {
                iterator.remove();
                break;
            }
            ++prev;
        }
        if (this.line < 0) {
            this.line = prev >= 0 ? prev : lore.size();
        }
        while (lore.size() < this.line) {
            lore.add("");
        }
        lore.add(this.line, loreLineBuilder.toString());
        this.meta.setLore(lore);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.meta = null;
    }
}

