/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import com.dre.brewery.lore.SeedInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public class XORScrambleStream
extends FilterOutputStream {
    private final long seed;
    private SeedInputStream xorStream;
    private boolean running;

    public XORScrambleStream(OutputStream out, long seed) {
        super(out);
        this.seed = seed;
    }

    public void start() throws IOException {
        this.running = true;
        if (this.xorStream == null) {
            short id = 0;
            while (id == 0) {
                id = (short)new Random().nextInt();
            }
            this.xorStream = new SeedInputStream(this.seed ^ (long)id);
            this.out.write((byte)(id >> 8));
            this.out.write((byte)id);
            this.write((int)(this.seed >> 48) & 0xFF);
        }
    }

    public void stop() {
        this.running = false;
    }

    public void startUnscrambled() throws IOException, IllegalStateException {
        if (this.xorStream != null) {
            throw new IllegalStateException("The Scrambler was started in scrambling mode before");
        }
        int id = 0;
        this.out.write((byte)(id >> 8));
        this.out.write((byte)id);
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.running) {
            this.out.write(b);
            return;
        }
        this.out.write(b ^ this.xorStream.read());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.running) {
            this.out.write(b, off, len);
            return;
        }
        byte[] xored = new byte[len];
        this.xorStream.read(xored);
        int j = off;
        int i = 0;
        while (i < len) {
            int n = i++;
            xored[n] = (byte)(xored[n] ^ b[j++]);
        }
        this.out.write(xored);
    }

    @Override
    public void close() throws IOException {
        this.running = false;
        this.xorStream = null;
        super.close();
    }
}

