/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.configuration.sector.capsule.ConfigCauldronIngredient;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.PotionColor;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.StringParser;
import com.dre.brewery.utility.Tuple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;

public class BCauldronRecipe {
    public static List<BCauldronRecipe> recipes = new ArrayList<BCauldronRecipe>();
    public static int numConfigRecipes;
    public static List<RecipeItem> acceptedCustom;
    public static Set<Material> acceptedSimple;
    public static Set<Material> acceptedMaterials;
    private final String id;
    private String name;
    private List<RecipeItem> ingredients;
    private PotionColor color;
    private List<Tuple<Integer, Color>> particleColor = new ArrayList<Tuple<Integer, Color>>();
    private List<String> lore;
    private int cmData;
    private boolean saveInData;

    public BCauldronRecipe(String id, String name) {
        this.id = id;
        this.name = name;
        this.color = PotionColor.CYAN;
    }

    @Nullable
    public static BCauldronRecipe fromConfig(String id, ConfigCauldronIngredient cfgCauldronIngredient) {
        List<Tuple<Integer, String>> lore;
        String name = cfgCauldronIngredient.getName();
        if (name == null) {
            Logging.errorLog("Missing name for Cauldron-Recipe: " + id);
            return null;
        }
        name = BUtil.color(name);
        BCauldronRecipe recipe = new BCauldronRecipe(id, name);
        recipe.ingredients = BRecipe.loadIngredients(BUtil.getListSafely(cfgCauldronIngredient.getIngredients()), id);
        if (recipe.ingredients == null || recipe.ingredients.isEmpty()) {
            Logging.errorLog("No ingredients for Cauldron-Recipe: " + recipe.name);
            return null;
        }
        String col = cfgCauldronIngredient.getColor();
        recipe.color = col != null ? PotionColor.fromString(col) : PotionColor.CYAN;
        if (recipe.color == PotionColor.WATER && !col.equals("WATER")) {
            recipe.color = PotionColor.CYAN;
        }
        ArrayList cookParticles = cfgCauldronIngredient.getCookParticles() != null ? cfgCauldronIngredient.getCookParticles() : new ArrayList();
        for (String entry : cookParticles) {
            int minute;
            String[] split = entry.split("/");
            if (split.length == 1) {
                minute = 10;
            } else if (split.length == 2) {
                minute = BUtil.parseIntOrZero(split[1]);
            } else {
                Logging.errorLog("cookParticle: '" + entry + "' in: " + recipe.name);
                return null;
            }
            if (minute < 1) {
                Logging.errorLog("cookParticle: '" + entry + "' in: " + recipe.name);
                return null;
            }
            PotionColor partCol = PotionColor.fromString(split[0]);
            if (partCol == PotionColor.WATER && !split[0].equals("WATER")) {
                Logging.errorLog("Color of cookParticle: '" + entry + "' in: " + recipe.name);
                return null;
            }
            recipe.particleColor.add(new Tuple<Integer, Color>(minute, partCol.getColor()));
        }
        if (!recipe.particleColor.isEmpty()) {
            recipe.particleColor.sort(Comparator.comparing(Tuple::first));
        }
        if (!(lore = BRecipe.loadQualityStringList(cfgCauldronIngredient.getLore(), StringParser.ParseType.LORE)).isEmpty()) {
            recipe.lore = lore.stream().map(Tuple::second).collect(Collectors.toList());
        }
        recipe.cmData = cfgCauldronIngredient.getCustomModelData() != null ? cfgCauldronIngredient.getCustomModelData() : 0;
        return recipe;
    }

    public float getIngredientMatch(List<Ingredient> items) {
        if (items.size() < this.ingredients.size()) {
            return 0.0f;
        }
        float match = 10.0f;
        block0: for (RecipeItem recipeIng : this.ingredients) {
            for (Ingredient ing : items) {
                if (!recipeIng.matches(ing)) continue;
                double difference = Math.abs(recipeIng.getAmount() - ing.getAmount());
                if (difference >= 1000.0) {
                    return 0.0f;
                }
                double factor = (double)ing.getAmount() * (1.0 - difference / 1000.0);
                double mod = 1.0 + 0.9 * -Math.exp(-0.03 * factor);
                match = (float)((double)match * mod);
                continue block0;
            }
            return 0.0f;
        }
        if (items.size() > this.ingredients.size()) {
            float tooMuch = items.size() - this.ingredients.size();
            double mod = Math.pow(0.1, tooMuch);
            match = (float)((double)match * mod);
        }
        Logging.debugLog("Match for Cauldron Recipe " + this.name + ": " + match);
        return match;
    }

    public void updateAcceptedLists() {
        for (RecipeItem ingredient : this.getIngredients()) {
            if (ingredient.hasMaterials()) {
                acceptedMaterials.addAll(ingredient.getMaterials());
            }
            if (ingredient instanceof SimpleItem) {
                acceptedSimple.add(((SimpleItem)ingredient).getMaterial());
                continue;
            }
            if (acceptedCustom.contains(ingredient)) continue;
            acceptedCustom.add(ingredient);
        }
    }

    public String toString() {
        return "BCauldronRecipe{" + this.name + "}";
    }

    @Nullable
    public static BCauldronRecipe get(String name) {
        for (BCauldronRecipe recipe : recipes) {
            if (!recipe.name.equalsIgnoreCase(name)) continue;
            return recipe;
        }
        return null;
    }

    public static List<BCauldronRecipe> getConfigRecipes() {
        return recipes.subList(0, numConfigRecipes);
    }

    public static List<BCauldronRecipe> getAddedRecipes() {
        return recipes.subList(numConfigRecipes, recipes.size());
    }

    public static List<BCauldronRecipe> getAllRecipes() {
        return recipes;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<RecipeItem> getIngredients() {
        return this.ingredients;
    }

    public PotionColor getColor() {
        return this.color;
    }

    public List<Tuple<Integer, Color>> getParticleColor() {
        return this.particleColor;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public int getCmData() {
        return this.cmData;
    }

    public boolean isSaveInData() {
        return this.saveInData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIngredients(List<RecipeItem> ingredients) {
        this.ingredients = ingredients;
    }

    public void setColor(PotionColor color) {
        this.color = color;
    }

    public void setParticleColor(List<Tuple<Integer, Color>> particleColor) {
        this.particleColor = particleColor;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public void setCmData(int cmData) {
        this.cmData = cmData;
    }

    public void setSaveInData(boolean saveInData) {
        this.saveInData = saveInData;
    }

    public static List<BCauldronRecipe> getRecipes() {
        return recipes;
    }

    public static int getNumConfigRecipes() {
        return numConfigRecipes;
    }

    public static void setNumConfigRecipes(int numConfigRecipes) {
        BCauldronRecipe.numConfigRecipes = numConfigRecipes;
    }

    public static Set<Material> getAcceptedSimple() {
        return acceptedSimple;
    }

    public static Set<Material> getAcceptedMaterials() {
        return acceptedMaterials;
    }

    static {
        acceptedCustom = new ArrayList<RecipeItem>();
        acceptedSimple = new HashSet<Material>();
        acceptedMaterials = new HashSet<Material>();
    }

    public static class Builder {
        private final String id;
        private final String name;
        private final List<RecipeItem> ingredients = new ArrayList<RecipeItem>();
        private PotionColor color = PotionColor.CYAN;
        private final List<Tuple<Integer, Color>> particleColor = new ArrayList<Tuple<Integer, Color>>();
        private final List<String> lore = new ArrayList<String>();
        private int cmData = 0;
        private boolean saveInData = false;

        public Builder(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public Builder ingredient(RecipeItem ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public Builder ingredients(List<RecipeItem> ingredients) {
            this.ingredients.addAll(ingredients);
            return this;
        }

        public Builder color(PotionColor color) {
            this.color = color;
            return this;
        }

        public Builder particleColor(int minute, Color color) {
            this.particleColor.add(new Tuple<Integer, Color>(minute, color));
            return this;
        }

        public Builder lore(String lore) {
            this.lore.add(lore);
            return this;
        }

        public Builder lore(List<String> lore) {
            this.lore.addAll(lore);
            return this;
        }

        public Builder cmData(int cmData) {
            this.cmData = cmData;
            return this;
        }

        public Builder saveInData(boolean saveInData) {
            this.saveInData = saveInData;
            return this;
        }

        public BCauldronRecipe build() {
            BCauldronRecipe recipe = new BCauldronRecipe(this.id, this.name);
            recipe.ingredients = this.ingredients;
            recipe.color = this.color;
            recipe.particleColor = this.particleColor;
            recipe.lore = this.lore;
            recipe.cmData = this.cmData;
            recipe.saveInData = this.saveInData;
            return recipe;
        }
    }
}

