/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.Logging;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomItem
extends RecipeItem
implements Ingredient {
    private Material mat;
    private String name;
    private List<String> lore;
    private int customModelData = 0;

    public CustomItem() {
    }

    public CustomItem(Material mat) {
        this.mat = mat;
    }

    public CustomItem(Material mat, String name, List<String> lore) {
        this.mat = mat;
        this.name = name;
        this.lore = lore;
    }

    public CustomItem(Material mat, String name, List<String> lore, int customModelData) {
        this.mat = mat;
        this.name = name;
        this.lore = lore;
        this.customModelData = customModelData;
    }

    public CustomItem(ItemStack item) {
        this.mat = item.getType();
        if (!item.hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        if (itemMeta.hasDisplayName()) {
            this.name = itemMeta.getDisplayName();
        }
        if (itemMeta.hasLore()) {
            this.lore = itemMeta.getLore();
        }
    }

    @Override
    public boolean hasMaterials() {
        return this.mat != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasCustomModelData() {
        return this.customModelData != 0;
    }

    @Override
    public List<Material> getMaterials() {
        ArrayList<Material> l = new ArrayList<Material>(1);
        l.add(this.mat);
        return l;
    }

    @Nullable
    public Material getMaterial() {
        return this.mat;
    }

    protected void setMat(Material mat) {
        this.mat = mat;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore;
    }

    protected void setLore(List<String> lore) {
        this.lore = lore;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    protected void setCustomModelData(int customModelData) {
        this.customModelData = customModelData;
    }

    @Override
    @NotNull
    public Ingredient toIngredient(ItemStack forItem) {
        return (CustomItem)this.getMutableCopy();
    }

    @Override
    @NotNull
    public Ingredient toIngredientGeneric() {
        return (CustomItem)this.getMutableCopy();
    }

    @Override
    public boolean matches(Ingredient ingredient) {
        if (this.isSimilar(ingredient)) {
            return true;
        }
        if (ingredient instanceof RecipeItem) {
            RecipeItem rItem = (RecipeItem)((Object)ingredient);
            if (rItem instanceof SimpleItem) {
                return this.hasMaterials() && !this.hasLore() && !this.hasName() && this.getMaterial() == ((SimpleItem)rItem).getMaterial();
            }
            if (rItem instanceof CustomItem) {
                CustomItem other = (CustomItem)rItem;
                if ((this.mat == null || this.mat == other.mat) && (!this.hasName() || other.name != null && this.name.equalsIgnoreCase(other.name))) {
                    if (this.hasCustomModelData() && this.customModelData != other.customModelData) {
                        return false;
                    }
                    return !this.hasLore() || this.lore == other.lore || other.hasLore() && this.matchLore(other.lore);
                }
            }
        }
        return false;
    }

    @Override
    public boolean matches(ItemStack item) {
        if (this.mat != null && item.getType() != this.mat) {
            return false;
        }
        if (this.name == null && !this.hasLore()) {
            return true;
        }
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (!(this.name == null || meta.hasDisplayName() && this.name.equalsIgnoreCase(meta.getDisplayName()))) {
            return false;
        }
        if (this.hasLore()) {
            if (!meta.hasLore()) {
                return false;
            }
            return this.matchLore(meta.getLore());
        }
        if (this.customModelData != 0) {
            return meta.hasCustomModelData() && meta.getCustomModelData() == this.customModelData;
        }
        return true;
    }

    public boolean matchLore(List<String> usedLore) {
        if (this.lore == null) {
            return true;
        }
        int lastIndex = 0;
        boolean foundFirst = false;
        for (String line : this.lore) {
            do {
                if (lastIndex == usedLore.size()) {
                    return false;
                }
                String usedLine = usedLore.get(lastIndex);
                if (line.equalsIgnoreCase(usedLine) || line.equalsIgnoreCase(ChatColor.stripColor((String)usedLine))) {
                    foundFirst = true;
                } else if (foundFirst) {
                    return false;
                }
                ++lastIndex;
            } while (!foundFirst);
        }
        return true;
    }

    @Override
    public boolean isSimilar(Ingredient item) {
        if (this == item) {
            return true;
        }
        if (item instanceof CustomItem) {
            CustomItem ci = (CustomItem)item;
            return this.mat == ci.mat && Objects.equals(this.name, ci.name) && Objects.equals(this.lore, ci.lore) && this.customModelData == ci.customModelData;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof CustomItem) {
            return this.isSimilar((CustomItem)obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mat, this.name, this.lore, this.customModelData);
    }

    @Override
    public String toString() {
        return "CustomItem{id=" + this.getConfigId() + ", mat=" + (this.mat != null ? this.mat.name().toLowerCase() : "null") + ", name='" + this.name + "', loresize: " + (this.lore != null ? this.lore.size() : 0) + ", modelData=" + this.customModelData + "}";
    }

    @Override
    public String getDebugID() {
        return this.getConfigId();
    }

    @Override
    public void saveTo(DataOutputStream out) throws IOException {
        out.writeUTF("CI");
        if (this.mat != null) {
            out.writeBoolean(true);
            out.writeUTF(this.mat.name());
        } else {
            out.writeBoolean(false);
        }
        if (this.name != null) {
            out.writeBoolean(true);
            out.writeUTF(this.name);
        } else {
            out.writeBoolean(false);
        }
        if (this.lore != null) {
            int size = Math.min(this.lore.size(), Short.MAX_VALUE);
            out.writeShort(size);
            for (int i = 0; i < size; ++i) {
                out.writeUTF(this.lore.get(i));
            }
        } else {
            out.writeShort(0);
        }
        if (this.customModelData != 0) {
            out.writeBoolean(true);
            out.writeInt(this.customModelData);
        } else {
            out.writeBoolean(false);
        }
    }

    public static CustomItem loadFrom(ItemLoader loader) {
        try {
            short size;
            DataInputStream in = loader.getInputStream();
            CustomItem item = new CustomItem();
            if (in.readBoolean()) {
                item.mat = Material.getMaterial((String)in.readUTF());
            }
            if (in.readBoolean()) {
                item.name = in.readUTF();
            }
            if ((size = in.readShort()) > 0) {
                item.lore = new ArrayList<String>(size);
                for (short i = 0; i < size; i = (short)(i + 1)) {
                    item.lore.add(in.readUTF());
                }
            }
            if (in.readBoolean()) {
                item.customModelData = in.readInt();
            }
            return item;
        }
        catch (IOException e) {
            Logging.errorLog("Failed to load CustomItem", e);
            return null;
        }
    }

    public static void registerItemLoader(BreweryPlugin breweryPlugin) {
        breweryPlugin.registerForItemLoader("CI", CustomItem::loadFrom);
    }
}

