/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.Logging;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginItem
extends RecipeItem
implements Ingredient {
    private static final Map<String, Supplier<PluginItem>> constructors = new HashMap<String, Supplier<PluginItem>>();
    private String plugin;
    private String itemId;

    public PluginItem() {
    }

    public PluginItem(String plugin, String itemId) {
        this.plugin = plugin;
        this.itemId = itemId;
    }

    @Override
    public boolean hasMaterials() {
        return false;
    }

    @Override
    public List<Material> getMaterials() {
        return null;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getItemId() {
        return this.itemId;
    }

    protected void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    protected void setItemId(String itemId) {
        this.itemId = itemId;
    }

    protected void onConstruct() {
    }

    @Override
    public boolean matches(Ingredient ingredient) {
        return this.isSimilar(ingredient);
    }

    @Override
    @NotNull
    public Ingredient toIngredient(ItemStack forItem) {
        return (PluginItem)this.getMutableCopy();
    }

    @Override
    @NotNull
    public Ingredient toIngredientGeneric() {
        return (PluginItem)this.getMutableCopy();
    }

    @Override
    public boolean isSimilar(Ingredient item) {
        if (item instanceof PluginItem) {
            return Objects.equals(this.plugin, ((PluginItem)item).plugin) && Objects.equals(this.itemId, ((PluginItem)item).itemId);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PluginItem item = (PluginItem)o;
        return Objects.equals(this.plugin, item.plugin) && Objects.equals(this.itemId, item.itemId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.plugin, this.itemId);
    }

    @Override
    public String getDebugID() {
        if (this.plugin == null) {
            return this.itemId;
        }
        return this.plugin + ":" + this.itemId;
    }

    @Override
    public void saveTo(DataOutputStream out) throws IOException {
        out.writeUTF("PI");
        out.writeUTF(this.plugin);
        out.writeUTF(this.itemId);
    }

    public static PluginItem loadFrom(ItemLoader loader) {
        try {
            DataInputStream in = loader.getInputStream();
            String plugin = in.readUTF();
            String itemId = in.readUTF();
            PluginItem item = PluginItem.fromConfig(plugin, itemId);
            if (item == null) {
                item = new PluginItem(plugin, itemId){

                    @Override
                    public boolean matches(ItemStack item) {
                        return false;
                    }
                };
            }
            return item;
        }
        catch (IOException e) {
            Logging.errorLog("Failed to load PluginItem from Ingredients", e);
            return null;
        }
    }

    public static void registerItemLoader(BreweryPlugin breweryPlugin) {
        breweryPlugin.registerForItemLoader("PI", PluginItem::loadFrom);
    }

    @Nullable
    public static PluginItem fromConfig(String plugin, String itemId) {
        if (constructors.containsKey(plugin = plugin.toLowerCase())) {
            PluginItem item = constructors.get(plugin).get();
            item.setPlugin(plugin);
            item.setItemId(itemId);
            item.onConstruct();
            return item;
        }
        return null;
    }

    public static void registerForConfig(String pluginId, Supplier<PluginItem> constructor) {
        constructors.put(pluginId.toLowerCase(), constructor);
    }

    public static void unRegisterForConfig(String pluginId) {
        constructors.remove(pluginId.toLowerCase());
    }
}

