/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.sector.capsule.ConfiguredDataManager;
import com.dre.brewery.integration.bstats.BreweryStats;
import com.dre.brewery.storage.BData;
import com.dre.brewery.storage.DataManagerType;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.storage.impls.FlatFileStorage;
import com.dre.brewery.storage.impls.MongoDBStorage;
import com.dre.brewery.storage.impls.MySQLStorage;
import com.dre.brewery.storage.impls.SQLiteStorage;
import com.dre.brewery.storage.interfaces.ExternallyAutoSavable;
import com.dre.brewery.storage.interfaces.SerializableThing;
import com.dre.brewery.storage.records.BreweryMiscData;
import com.dre.brewery.utility.Logging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public abstract class DataManager {
    protected static BreweryPlugin plugin = BreweryPlugin.getInstance();
    protected static long lastAutoSave = System.currentTimeMillis();
    protected static Set<ExternallyAutoSavable> autoSavabales = new HashSet<ExternallyAutoSavable>();
    private final DataManagerType type;

    protected DataManager(DataManagerType type) throws StorageInitException {
        this.type = type;
    }

    public abstract boolean createTable(String var1, int var2);

    public abstract boolean dropTable(String var1);

    public abstract <T extends SerializableThing> T getGeneric(String var1, String var2, Class<T> var3);

    public abstract <T extends SerializableThing> List<T> getAllGeneric(String var1, Class<T> var2);

    public abstract <T extends SerializableThing> void saveAllGeneric(List<T> var1, String var2, @Nullable Class<T> var3);

    public abstract <T extends SerializableThing> void saveGeneric(T var1, String var2);

    public abstract void deleteGeneric(String var1, String var2);

    public abstract CompletableFuture<Barrel> getBarrel(UUID var1);

    public abstract CompletableFuture<List<Barrel>> getAllBarrels();

    public abstract void saveAllBarrels(Collection<Barrel> var1);

    public abstract void saveBarrel(Barrel var1);

    public abstract void deleteBarrel(UUID var1);

    public abstract BCauldron getCauldron(UUID var1);

    public abstract Collection<BCauldron> getAllCauldrons();

    public abstract void saveAllCauldrons(Collection<BCauldron> var1);

    public abstract void saveCauldron(BCauldron var1);

    public abstract void deleteCauldron(UUID var1);

    public abstract BPlayer getPlayer(UUID var1);

    public abstract Collection<BPlayer> getAllPlayers();

    public abstract void saveAllPlayers(Collection<BPlayer> var1);

    public abstract void savePlayer(BPlayer var1);

    public abstract void deletePlayer(UUID var1);

    public abstract Wakeup getWakeup(UUID var1);

    public abstract Collection<Wakeup> getAllWakeups();

    public abstract void saveAllWakeups(Collection<Wakeup> var1);

    public abstract void saveWakeup(Wakeup var1);

    public abstract void deleteWakeup(UUID var1);

    public abstract BreweryMiscData getBreweryMiscData();

    public abstract void saveBreweryMiscData(BreweryMiscData var1);

    protected void closeConnection() {
    }

    public void tryAutoSave() {
        long interval = (long)ConfigManager.getConfig(Config.class).getAutosave() * 60000L;
        if (System.currentTimeMillis() - lastAutoSave > interval) {
            this.saveAll(true);
            lastAutoSave = System.currentTimeMillis();
            Logging.debugLog("Auto saved all data!");
        }
    }

    public void exit(boolean save, boolean async) {
        this.exit(save, async, null);
    }

    public void exit(boolean save, boolean async, Runnable callback) {
        if (save) {
            this.saveAll(async, () -> {
                this.closeConnection();
                Logging.log("Closed connection from&7:&a " + this.getType().getFormattedName());
                if (callback != null) {
                    callback.run();
                }
            });
        } else {
            this.closeConnection();
            Logging.log("Closed connection from&7:&a " + this.getType().getFormattedName());
            if (callback != null) {
                callback.run();
            }
        }
    }

    public void saveAll(boolean async) {
        this.saveAll(async, null);
    }

    public void saveAll(boolean async, Runnable callback) {
        List<Barrel> barrels = Barrel.getAllBarrels();
        Collection<BCauldron> cauldrons = BCauldron.getBcauldrons().values();
        Collection<BPlayer> bPlayers = BPlayer.getPlayers().values();
        List<Wakeup> wakeups = Wakeup.getWakeups();
        if (async) {
            BreweryPlugin.getScheduler().runTaskAsynchronously(() -> {
                this.doSave(barrels, cauldrons, bPlayers, wakeups);
                if (callback != null) {
                    callback.run();
                }
            });
        } else {
            this.doSave(barrels, cauldrons, bPlayers, wakeups);
            if (callback != null) {
                callback.run();
            }
        }
    }

    private void doSave(Collection<Barrel> barrels, Collection<BCauldron> cauldrons, Collection<BPlayer> players, Collection<Wakeup> wakeups) {
        this.saveBreweryMiscData(DataManager.getLoadedMiscData());
        this.saveAllBarrels(barrels);
        this.saveAllCauldrons(cauldrons);
        this.saveAllPlayers(players);
        this.saveAllWakeups(wakeups);
        for (ExternallyAutoSavable autoSaveAble : autoSavabales) {
            try {
                autoSaveAble.onAutoSave(this);
            }
            catch (Throwable e) {
                Logging.errorLog("An external auto-savable class threw an exception. This is most likely an addon not saving properly.", e);
            }
        }
        Logging.debugLog("Saved all data!");
    }

    public static DataManager createDataManager(ConfiguredDataManager record) throws StorageInitException {
        DataManager dataManager;
        switch (record.getType()) {
            default: {
                throw new MatchException(null, null);
            }
            case FLATFILE: {
                DataManager dataManager2 = new FlatFileStorage(record);
                break;
            }
            case MYSQL: {
                DataManager dataManager2 = new MySQLStorage(record);
                break;
            }
            case SQLITE: {
                DataManager dataManager2 = new SQLiteStorage(record);
                break;
            }
            case MONGODB: {
                DataManager dataManager2 = dataManager = new MongoDBStorage(record);
            }
        }
        if (BData.checkForLegacyData()) {
            long start = System.currentTimeMillis();
            Logging.log("&5Brewery is loading data from a legacy format!");
            BData.readData();
            BData.finalizeLegacyDataMigration();
            dataManager.saveAll(false);
            Logging.log("&5Finished migrating legacy data! Took&7: &a" + (System.currentTimeMillis() - start) + "ms&5! Join our discord if you need assistance: &ahttps://discord.gg/3FkNaNDnta");
            Logging.warningLog("BreweryX can only load legacy data from worlds that exist. If you're trying to migrate old cauldrons, barrels, etc. And the worlds they're in don't exist, you'll need to migrate manually.");
        }
        for (ExternallyAutoSavable autoSavable : autoSavabales) {
            dataManager.createTable(autoSavable.table(), autoSavable.tableMaxIdLength());
        }
        Logging.log("DataManager created&7:&a " + record.getType().getFormattedName());
        return dataManager;
    }

    public void registerAutoSavable(ExternallyAutoSavable autoSavable) {
        autoSavabales.add(autoSavable);
        this.createTable(autoSavable.table(), autoSavable.tableMaxIdLength());
    }

    public void unregisterAutoSavable(ExternallyAutoSavable autoSavable) {
        autoSavabales.remove(autoSavable);
    }

    public static void loadMiscData(BreweryMiscData miscData) {
        Brew.installTime = miscData.installTime();
        MCBarrel.mcBarrelTime = miscData.mcBarrelTime();
        Brew.loadPrevSeeds(miscData.prevSaveSeeds());
        BreweryStats breweryStats = plugin.getBreweryStats();
        if (miscData.brewsCreated().size() == 7 && miscData.brewsCreatedHash() == miscData.brewsCreated().hashCode()) {
            breweryStats.brewsCreated = miscData.brewsCreated().get(0);
            breweryStats.brewsCreatedCmd = miscData.brewsCreated().get(1);
            breweryStats.exc = miscData.brewsCreated().get(2);
            breweryStats.good = miscData.brewsCreated().get(3);
            breweryStats.norm = miscData.brewsCreated().get(4);
            breweryStats.bad = miscData.brewsCreated().get(5);
            breweryStats.terr = miscData.brewsCreated().get(6);
        }
    }

    public static BreweryMiscData getLoadedMiscData() {
        ArrayList<Integer> brewsCreated = new ArrayList<Integer>(7);
        BreweryStats breweryStats = plugin.getBreweryStats();
        brewsCreated.addAll(List.of(Integer.valueOf(breweryStats.brewsCreated), Integer.valueOf(breweryStats.brewsCreatedCmd), Integer.valueOf(breweryStats.exc), Integer.valueOf(breweryStats.good), Integer.valueOf(breweryStats.norm), Integer.valueOf(breweryStats.bad), Integer.valueOf(breweryStats.terr)));
        return new BreweryMiscData(Brew.installTime, MCBarrel.mcBarrelTime, Brew.getPrevSeeds(), brewsCreated, brewsCreated.hashCode());
    }

    public static Location deserializeLocation(String locationString) {
        return DataManager.deserializeLocation(locationString, false);
    }

    public static String serializeLocation(Location location) {
        return DataManager.serializeLocation(location, false);
    }

    public static Location deserializeLocation(String string, boolean yawPitch) {
        if (string == null) {
            Logging.warningLog("Location is null!");
            return null;
        }
        String locationString = string;
        String worldName = null;
        if (locationString.contains("?=")) {
            String[] split = locationString.split("\\?=");
            locationString = split[0];
            worldName = split[1];
        }
        String[] loc = locationString.split(",");
        UUID worldUUID = null;
        try {
            worldUUID = UUID.fromString(loc[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        World world = null;
        if (worldUUID != null) {
            world = Bukkit.getWorld((UUID)worldUUID);
        }
        if (world == null && worldName != null) {
            world = Bukkit.getWorld((String)worldName);
        }
        if (world == null) {
            Logging.warningLog("World not found! " + loc[0]);
            return null;
        }
        if (yawPitch && loc.length == 6) {
            return new Location(world, (double)Integer.parseInt(loc[1]), (double)Integer.parseInt(loc[2]), (double)Integer.parseInt(loc[3]), Float.parseFloat(loc[4]), Float.parseFloat(loc[5]));
        }
        return new Location(world, (double)Integer.parseInt(loc[1]), (double)Integer.parseInt(loc[2]), (double)Integer.parseInt(loc[3]));
    }

    public static String serializeLocation(Location location, boolean yawPitch) {
        if (location.getWorld() == null) {
            Logging.errorLog("Location must have a world! " + String.valueOf(location));
            return null;
        }
        String locationString = yawPitch ? String.valueOf(location.getWorld().getUID()) + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + "," + location.getYaw() + "," + location.getPitch() : String.valueOf(location.getWorld().getUID()) + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
        locationString = locationString + "?=" + location.getWorld().getName();
        return locationString;
    }

    public DataManagerType getType() {
        return this.type;
    }
}

