/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.impls;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BIngredients;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.configuration.sector.capsule.ConfiguredDataManager;
import com.dre.brewery.depend.google.gson.Gson;
import com.dre.brewery.depend.google.gson.JsonElement;
import com.dre.brewery.depend.google.gson.JsonObject;
import com.dre.brewery.depend.google.gson.reflect.TypeToken;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.storage.interfaces.SerializableThing;
import com.dre.brewery.storage.records.BreweryMiscData;
import com.dre.brewery.storage.serialization.BukkitSerialization;
import com.dre.brewery.storage.serialization.SQLDataSerializer;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BoundingBox;
import com.dre.brewery.utility.FutureUtil;
import com.dre.brewery.utility.Logging;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FlatFileStorage
extends DataManager {
    private final File rawFile;
    private final YamlConfiguration dataFile;
    private SQLDataSerializer serializer;

    public FlatFileStorage(ConfiguredDataManager record) throws StorageInitException {
        super(record.getType());
        String fileName = record.getDatabase() + ".yml";
        this.rawFile = new File(plugin.getDataFolder(), fileName);
        if (!this.rawFile.exists()) {
            try {
                this.rawFile.createNewFile();
            }
            catch (IOException e) {
                throw new StorageInitException("Failed to create file! " + fileName, e);
            }
        }
        this.dataFile = YamlConfiguration.loadConfiguration((File)this.rawFile);
    }

    private void save() {
        try {
            this.dataFile.save(this.rawFile);
        }
        catch (IOException e) {
            Logging.errorLog("Failed to save to FlatFile!", e);
        }
    }

    private SQLDataSerializer getLazySerializerInstance() {
        if (this.serializer == null) {
            this.serializer = new SQLDataSerializer();
        }
        return this.serializer;
    }

    @Override
    public boolean createTable(String name, int maxIdLength) {
        if (this.dataFile.contains(name)) {
            return false;
        }
        this.dataFile.createSection(name);
        this.save();
        return true;
    }

    @Override
    public boolean dropTable(String name) {
        this.dataFile.set(name, null);
        this.save();
        return true;
    }

    @Override
    public <T extends SerializableThing> T getGeneric(String id, String table, Class<T> type) {
        String path = table + "." + id;
        ConfigurationSection section = this.dataFile.getConfigurationSection(path);
        if (section == null) {
            return null;
        }
        Map map = section.getValues(false);
        Gson gson = this.getLazySerializerInstance().getGson();
        String json = gson.toJson(map);
        return (T)((SerializableThing)gson.fromJson(json, type));
    }

    @Override
    public <T extends SerializableThing> List<T> getAllGeneric(String table, Class<T> type) {
        ConfigurationSection section = this.dataFile.getConfigurationSection(table);
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<T> things = new ArrayList<T>();
        for (String key : section.getKeys(false)) {
            things.add(this.getGeneric(key, table, type));
        }
        return things;
    }

    @Override
    public <T extends SerializableThing> void saveAllGeneric(List<T> serializableThings, String table, @Nullable Class<T> type) {
        ConfigurationSection section = this.dataFile.getConfigurationSection(table);
        if (section != null) {
            section.getKeys(false).forEach(key -> this.dataFile.set(table + "." + key, null));
        } else {
            this.dataFile.createSection(table);
        }
        for (SerializableThing thing : serializableThings) {
            this.saveGeneric(thing, table);
        }
        this.save();
    }

    @Override
    public <T extends SerializableThing> void saveGeneric(T serializableThing, String table) {
        String path = table + "." + serializableThing.getId();
        Gson gson = this.getLazySerializerInstance().getGson();
        JsonObject jsonObject = gson.toJsonTree(serializableThing).getAsJsonObject();
        Type mapType = new TypeToken<Map<String, Object>>(this){}.getType();
        Map map = (Map)gson.fromJson((JsonElement)jsonObject, mapType);
        for (Map.Entry entry : map.entrySet()) {
            this.dataFile.set(path + "." + (String)entry.getKey(), entry.getValue());
        }
        this.save();
    }

    @Override
    public void deleteGeneric(String id, String table) {
        this.dataFile.set(table + "." + id, null);
        this.save();
    }

    @Override
    public CompletableFuture<Barrel> getBarrel(UUID id) {
        String path = "barrels." + String.valueOf(id);
        Location spigotLoc = FlatFileStorage.deserializeLocation(this.dataFile.getString(path + ".spigot"));
        if (spigotLoc == null) {
            return CompletableFuture.completedFuture(null);
        }
        int[] bounds = Arrays.stream(this.dataFile.getString(path + ".bounds").split(",")).mapToInt(Integer::parseInt).toArray();
        BoundingBox boundingBox = BoundingBox.fromPoints(bounds);
        float time = (float)this.dataFile.getDouble(path + ".time", 0.0);
        byte sign = (byte)this.dataFile.getInt(path + ".sign", 0);
        ItemStack[] items = BukkitSerialization.itemStackArrayFromBase64(this.dataFile.getString(path + ".items", null));
        return Barrel.computeSmall(spigotLoc).thenApplyAsync(small -> new Barrel(spigotLoc.getBlock(), sign, boundingBox, items, time, id, (boolean)small));
    }

    @Override
    public CompletableFuture<List<Barrel>> getAllBarrels() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("barrels");
        if (section == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList barrels = new ArrayList();
        for (String key : section.getKeys(false)) {
            CompletableFuture<Barrel> barrel = this.getBarrel(BUtil.uuidFromString(key));
            if (barrel == null) continue;
            barrels.add(barrel);
        }
        return FutureUtil.mergeFutures(barrels);
    }

    @Override
    public void saveAllBarrels(Collection<Barrel> barrels) {
        this.dataFile.set("barrels", null);
        for (Barrel barrel : barrels) {
            this.saveBarrel(barrel);
        }
    }

    @Override
    public void saveBarrel(Barrel barrel) {
        if (barrel.getBounds() == null) {
            return;
        }
        String path = "barrels." + String.valueOf(barrel.getId());
        this.dataFile.set(path + ".spigot", (Object)FlatFileStorage.serializeLocation(barrel.getSpigot().getLocation()));
        this.dataFile.set(path + ".bounds", (Object)barrel.getBounds().serialize());
        this.dataFile.set(path + ".time", (Object)Float.valueOf(barrel.getTime()));
        this.dataFile.set(path + ".sign", (Object)barrel.getSignoffset());
        this.dataFile.set(path + ".items", (Object)BukkitSerialization.itemStackArrayToBase64(barrel.getInventory().getContents()));
        this.save();
    }

    @Override
    public void deleteBarrel(UUID id) {
        this.dataFile.set("barrels." + String.valueOf(id), null);
        this.save();
    }

    @Override
    public BCauldron getCauldron(UUID id) {
        String path = "cauldrons." + String.valueOf(id);
        Location loc = FlatFileStorage.deserializeLocation(this.dataFile.getString(path + ".block"));
        if (loc == null) {
            return null;
        }
        BIngredients ingredients = BIngredients.deserializeIngredients(this.dataFile.getString(path + ".ingredients"));
        int state = this.dataFile.getInt(path + ".state", 0);
        return new BCauldron(loc.getBlock(), ingredients, state, id);
    }

    @Override
    public Collection<BCauldron> getAllCauldrons() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("cauldrons");
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<BCauldron> cauldrons = new ArrayList<BCauldron>();
        for (String key : section.getKeys(false)) {
            BCauldron cauldron = this.getCauldron(BUtil.uuidFromString(key));
            if (cauldron == null) continue;
            cauldrons.add(cauldron);
        }
        return cauldrons;
    }

    @Override
    public void saveAllCauldrons(Collection<BCauldron> cauldrons) {
        this.dataFile.set("cauldrons", null);
        for (BCauldron cauldron : cauldrons) {
            this.saveCauldron(cauldron);
        }
    }

    @Override
    public void saveCauldron(BCauldron cauldron) {
        String path = "cauldrons." + String.valueOf(cauldron.getId());
        this.dataFile.set(path + ".block", (Object)FlatFileStorage.serializeLocation(cauldron.getBlock().getLocation()));
        this.dataFile.set(path + ".ingredients", (Object)cauldron.getIngredients().serializeIngredients());
        this.dataFile.set(path + ".state", (Object)cauldron.getState());
        this.save();
    }

    @Override
    public void deleteCauldron(UUID id) {
        this.dataFile.set("cauldrons." + String.valueOf(id), null);
        this.save();
    }

    @Override
    public BPlayer getPlayer(UUID playerUUID) {
        String path = "players." + String.valueOf(playerUUID);
        int quality = this.dataFile.getInt(path + ".quality", 0);
        int drunkenness = this.dataFile.getInt(path + ".drunkenness", 0);
        int offlineDrunkenness = this.dataFile.getInt(path + ".offlineDrunkenness", 0);
        return new BPlayer(playerUUID, quality, drunkenness, offlineDrunkenness);
    }

    @Override
    public Collection<BPlayer> getAllPlayers() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("players");
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<BPlayer> players = new ArrayList<BPlayer>();
        for (String key : section.getKeys(false)) {
            BPlayer player = this.getPlayer(BUtil.uuidFromString(key));
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public void saveAllPlayers(Collection<BPlayer> players) {
        this.dataFile.set("players", null);
        for (BPlayer player : players) {
            this.savePlayer(player);
        }
    }

    @Override
    public void savePlayer(BPlayer player) {
        String path = "players." + player.getUuid();
        this.dataFile.set(path + ".quality", (Object)player.getQuality());
        this.dataFile.set(path + ".drunkenness", (Object)player.getDrunkeness());
        this.dataFile.set(path + ".offlineDrunkenness", (Object)player.getOfflineDrunkeness());
        this.save();
    }

    @Override
    public void deletePlayer(UUID playerUUID) {
        this.dataFile.set("players." + String.valueOf(playerUUID), null);
        this.save();
    }

    @Override
    public Wakeup getWakeup(UUID id) {
        String path = "wakeups." + String.valueOf(id);
        Location wakeupLocation = FlatFileStorage.deserializeLocation(this.dataFile.getString(path + ".location"), true);
        if (wakeupLocation == null) {
            return null;
        }
        return new Wakeup(wakeupLocation, id);
    }

    @Override
    public Collection<Wakeup> getAllWakeups() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("wakeups");
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<Wakeup> wakeups = new ArrayList<Wakeup>();
        for (String key : section.getKeys(false)) {
            Wakeup wakeup = this.getWakeup(BUtil.uuidFromString(key));
            if (wakeup == null) continue;
            wakeups.add(wakeup);
        }
        return wakeups;
    }

    @Override
    public void saveAllWakeups(Collection<Wakeup> wakeups) {
        this.dataFile.set("wakeups", null);
        for (Wakeup wakeup : wakeups) {
            this.saveWakeup(wakeup);
        }
    }

    @Override
    public void saveWakeup(Wakeup wakeup) {
        String path = "wakeups." + String.valueOf(wakeup.getId());
        this.dataFile.set(path + ".location", (Object)FlatFileStorage.serializeLocation(wakeup.getLoc(), true));
        this.save();
    }

    @Override
    public void deleteWakeup(UUID id) {
        this.dataFile.set("wakeups." + String.valueOf(id), null);
        this.save();
    }

    @Override
    public BreweryMiscData getBreweryMiscData() {
        return new BreweryMiscData(this.dataFile.getLong("misc.installTime", System.currentTimeMillis()), this.dataFile.getLong("misc.mcBarrelTime", 0L), this.dataFile.getLongList("misc.previousSaveSeeds"), this.dataFile.getIntegerList("misc.brewsCreated"), this.dataFile.getInt("misc.brewsCreatedHash", 0));
    }

    @Override
    public void saveBreweryMiscData(BreweryMiscData data) {
        this.dataFile.set("misc.installTime", (Object)data.installTime());
        this.dataFile.set("misc.mcBarrelTime", (Object)data.mcBarrelTime());
        this.dataFile.set("misc.previousSaveSeeds", data.prevSaveSeeds());
        this.dataFile.set("misc.brewsCreated", data.brewsCreated());
        this.dataFile.set("misc.brewsCreatedHash", (Object)data.brewsCreatedHash());
        this.save();
    }
}

