/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.Tuple;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitConstants {
    public static PotionEffectType HUNGER = BukkitConstants.potionEffectType("hunger");
    public static PotionEffectType NAUSEA = BukkitConstants.potionEffectType("nausea");
    public static PotionEffectType BLINDNESS = BukkitConstants.potionEffectType("blindness");
    public static PotionEffectType SLOWNESS = BukkitConstants.potionEffectType("slowness");
    public static PotionEffectType REGENERATION = BukkitConstants.potionEffectType("regeneration");
    public static PotionEffectType POISON = BukkitConstants.potionEffectType("poison");
    public static PotionEffectType WEAKNESS = BukkitConstants.potionEffectType("weakness");
    public static PotionEffectType FIRE_RESISTANCE = BukkitConstants.potionEffectType("fire_resistance");
    public static PotionEffectType INSTANT_HEALTH = BukkitConstants.potionEffectType("instant_health");
    public static PotionEffectType INSTANT_DAMAGE = BukkitConstants.potionEffectType("instant_damage");
    public static PotionEffectType WATER_BREATHING = BukkitConstants.potionEffectType("water_breathing");
    public static PotionEffectType NIGHT_VISION = BukkitConstants.potionEffectType("night_vision");
    public static PotionEffectType SPEED = BukkitConstants.potionEffectType("speed");
    public static PotionEffectType HASTE = BukkitConstants.potionEffectType("haste");
    public static Particle INSTANT_EFFECT = BukkitConstants.particle("instant_effect");
    public static Particle SPLASH = BukkitConstants.particle("splash");
    public static Particle ENTITY_EFFECT = BukkitConstants.particle("entity_effect");
    public static Particle LARGE_SMOKE = BukkitConstants.particle("large_smoke");
    public static Particle DUST = BukkitConstants.particle("dust");
    public static PotionType POTION_REGENERATION = BukkitConstants.potionType("regeneration");
    public static PotionType POTION_SWIFTNESS = BukkitConstants.potionType("swiftness");
    public static PotionType POTION_FIRE_RESISTANCE = BukkitConstants.potionType("fire_resistance");
    public static PotionType POTION_POISON = BukkitConstants.potionType("poison");
    public static PotionType POTION_HEALING = BukkitConstants.potionType("healing");
    public static PotionType POTION_NIGHT_VISION = BukkitConstants.potionType("night_vision");
    public static PotionType POTION_WEAKNESS = BukkitConstants.potionType("weakness");
    public static PotionType POTION_STRENGTH = BukkitConstants.potionType("strength");
    public static PotionType POTION_SLOWNESS = BukkitConstants.potionType("slowness");
    public static PotionType POTION_WATER_BREATHING = BukkitConstants.potionType("water_breathing");
    public static PotionType POTION_HARMING = BukkitConstants.potionType("harming");
    public static PotionType POTION_INVISIBILITY = BukkitConstants.potionType("invisibility");
    public static Material SHORT_GRASS = BukkitConstants.renamedMaterial("grass", new Tuple<MinecraftVersion, String>(MinecraftVersion.V1_20_4, "short_grass"));
    private static final Map<String, Keyed> MAPPED_VALUES = new HashMap<String, Keyed>();

    private BukkitConstants() {
    }

    public static Particle particle(String key) {
        return (Particle)Registry.PARTICLE_TYPE.get(NamespacedKey.minecraft((String)key));
    }

    public static PotionEffectType potionEffectType(String key) {
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_21)) {
            return (PotionEffectType)BukkitConstants.getOrThrow(Registry.EFFECT, key);
        }
        return BukkitConstants.throwIfNull(key, k -> PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)k)));
    }

    public static PotionType potionType(String key) {
        return (PotionType)BukkitConstants.getOrThrow(Registry.POTION, key);
    }

    @Nullable
    public static PotionEffectType nullablePotionEffectType(String key) {
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_21)) {
            return (PotionEffectType)Registry.EFFECT.get(NamespacedKey.minecraft((String)key));
        }
        return PotionEffectType.getByKey((NamespacedKey)NamespacedKey.minecraft((String)key));
    }

    public static Material renamedMaterial(String defaultValue, Tuple<MinecraftVersion, String> ... names) {
        MinecraftVersion activeVersion = BreweryPlugin.getMCVersion();
        for (Tuple<MinecraftVersion, String> pair : names) {
            MinecraftVersion version = pair.a();
            String name = pair.b();
            if (!activeVersion.isOrLater(version)) continue;
            return Material.getMaterial((String)name.toUpperCase());
        }
        return Material.getMaterial((String)defaultValue.toUpperCase());
    }

    private static <T extends Keyed> T getOrThrow(Registry<T> registry, String key) {
        Keyed value = registry.get(NamespacedKey.minecraft((String)key));
        if (value == null) {
            throw new IllegalArgumentException("No value found in registry for key: " + key);
        }
        return (T)value;
    }

    private static <T> T throwIfNull(String key, KeyLookup<T> function) {
        T value = function.throwIfNull(key);
        if (value == null) {
            throw new IllegalArgumentException("No value found for key: " + key);
        }
        return value;
    }

    @Nullable
    public static <T extends Keyed> T getMappedValue(String key, Class<T> type) {
        Keyed keyed = MAPPED_VALUES.get(key);
        if (keyed == null) {
            return null;
        }
        if (!type.isAssignableFrom(keyed.getClass())) {
            return null;
        }
        return (T)((Keyed)type.cast(keyed));
    }

    public static <T extends Keyed> Collection<T> getMappedValues(Class<T> type) {
        ArrayList<Keyed> list = new ArrayList<Keyed>();
        for (Keyed keyed : MAPPED_VALUES.values()) {
            if (!type.isAssignableFrom(keyed.getClass())) continue;
            list.add((Keyed)type.cast(keyed));
        }
        return list;
    }

    @Nullable
    public static Keyed getMappedValue(String key) {
        return MAPPED_VALUES.get(key);
    }

    public static Collection<Keyed> getMappedValues() {
        return MAPPED_VALUES.values();
    }

    static {
        try {
            for (Field field : BukkitConstants.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Keyed.class.isAssignableFrom(field.getType())) continue;
                Keyed obj = (Keyed)field.get(null);
                MAPPED_VALUES.put(obj.getKey().getKey(), obj);
            }
        }
        catch (IllegalAccessException e) {
            Logging.errorLog("BukkitConstants failed to initialize mapped values", e);
        }
    }

    private static interface KeyLookup<T> {
        public T throwIfNull(String var1);
    }

    public static class ParticleSpellWrapper
    extends BukkitConstantWrapper {
        public ParticleSpellWrapper() {
            super(MinecraftVersion.V1_21_10);
        }

        @Nullable
        public Object toInstance(@NotNull Color color, float size) {
            if (!SERVER_VERSION.isOrLater(this.requiredVersion)) {
                return null;
            }
            return new Particle.Spell(color, size);
        }
    }

    public static abstract class BukkitConstantWrapper {
        protected static final MinecraftVersion SERVER_VERSION = BreweryPlugin.getMCVersion();
        protected final MinecraftVersion requiredVersion;

        public MinecraftVersion getRequiredVersion() {
            return this.requiredVersion;
        }

        public BukkitConstantWrapper(MinecraftVersion requiredVersion) {
            this.requiredVersion = requiredVersion;
        }
    }
}

