/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.utility.NBTUtil;
import com.google.common.base.Preconditions;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;

public enum MinecraftVersion {
    V1_8("1.8"),
    V1_9("1.9"),
    V1_10("1.10"),
    V1_11("1.11"),
    V1_12("1.12"),
    V1_13("1.13"),
    V1_14("1.14"),
    V1_15("1.15"),
    V1_16("1.16"),
    V1_17("1.17"),
    V1_18("1.18"),
    V1_19("1.19"),
    V1_20("1.20"),
    V1_20_4("1.20.4", "1.20.3"),
    V1_21("1.21", "1.20.5", "1.20.6"),
    V1_21_10("1.21.10", "1.21.9"),
    UNKNOWN("Unknown");

    private static final boolean isFolia;
    private static final boolean useNBT;
    private final String[] versions;

    private MinecraftVersion(String ... version) {
        this.versions = version;
    }

    public static MinecraftVersion get(String major, String minor, @Nullable String patch) {
        String withPatch = major + "." + minor + "." + patch;
        String withoutPatch = major + "." + minor;
        for (MinecraftVersion minecraftVersion : MinecraftVersion.values()) {
            for (String versionString : minecraftVersion.versions) {
                if (!versionString.equals(withPatch)) continue;
                return minecraftVersion;
            }
        }
        for (MinecraftVersion minecraftVersion : MinecraftVersion.values()) {
            for (String versionString : minecraftVersion.versions) {
                if (!versionString.equals(withoutPatch)) continue;
                return minecraftVersion;
            }
        }
        return UNKNOWN;
    }

    public static MinecraftVersion getIt() {
        String rawVersion = Bukkit.getVersion();
        String rawVersionParsed = rawVersion.substring(rawVersion.indexOf("(MC: ") + 5, rawVersion.indexOf(")"));
        String[] versionSplit = rawVersionParsed.split("\\.");
        Preconditions.checkState((versionSplit.length == 3 || versionSplit.length == 2 ? 1 : 0) != 0, (Object)("Unexpected Minecraft version format: " + rawVersionParsed));
        return MinecraftVersion.get(versionSplit[0], versionSplit[1], versionSplit[2]);
    }

    public boolean isOrLater(MinecraftVersion version) {
        return this.ordinal() >= version.ordinal();
    }

    public boolean isOrEarlier(MinecraftVersion version) {
        return this.ordinal() <= version.ordinal();
    }

    public String getVersion() {
        return this.versions[0];
    }

    private static boolean checkFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public String[] getVersions() {
        return this.versions;
    }

    public static boolean isFolia() {
        return isFolia;
    }

    public static boolean isUseNBT() {
        return useNBT;
    }

    static {
        isFolia = MinecraftVersion.checkFolia();
        useNBT = NBTUtil.initNbt();
    }
}

