/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility.releases.impl;

import com.dre.brewery.depend.google.gson.JsonElement;
import com.dre.brewery.depend.google.gson.JsonObject;
import com.dre.brewery.depend.google.gson.JsonParser;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.releases.ReleaseChecker;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;

public class GithubSnapshotsReleaseChecker
extends ReleaseChecker {
    private static final String CONST_URL = "https://api.github.com/repos/%s/%s/releases";
    private static final String CONST_RELEASE_URL = "https://github.com/%s/%s/releases/tag/%s";
    private static final String CONST_JSON_FIELD = "tag_name";
    private final String link;
    private final String owner;
    private final String repo;

    public GithubSnapshotsReleaseChecker(String owner, String repo) {
        this.link = String.format(CONST_URL, owner, repo);
        this.owner = owner;
        this.repo = repo;
    }

    @Override
    public CompletableFuture<String> resolveLatest() {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.link)).GET().build();
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                JsonObject jsonResponse = JsonParser.parseString(response.body()).getAsJsonArray().asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).toList().get(0);
                this.resolvedLatestVersion = jsonResponse.get(CONST_JSON_FIELD).getAsString();
                return this.resolvedLatestVersion;
            }
            catch (IOException | InterruptedException e) {
                Logging.warningLog("Failed to resolve latest BreweryX version from GitHub. (No connection?)");
                this.resolvedLatestVersion = "UNRESOLVED";
                return "UNRESOLVED";
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> checkForUpdate() {
        return this.resolveLatest().thenApply(v -> {
            if (v.equals("UNRESOLVED")) {
                return false;
            }
            return this.isUpdateAvailable();
        });
    }

    @Override
    public String getDownloadURL() {
        return String.format(CONST_RELEASE_URL, this.owner, this.repo, this.resolvedLatestVersion);
    }
}

