/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility.releases.impl;

import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.releases.ReleaseChecker;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;

public class SpigotReleaseChecker
extends ReleaseChecker {
    private static final String CONST_URL = "https://api.spigotmc.org/legacy/update.php?resource=%s/~";
    private static final String CONST_RELEASE_URL = "https://www.spigotmc.org/resources/%s";
    private final String link;
    private final int resourceId;

    public SpigotReleaseChecker(int resourceId) {
        this.link = String.format(CONST_URL, resourceId);
        this.resourceId = resourceId;
    }

    @Override
    public CompletableFuture<String> resolveLatest() {
        return CompletableFuture.supplyAsync(() -> {
            try (Scanner scanner = new Scanner(new URL(this.link).openStream());){
                if (!scanner.hasNext()) return this.failedToResolve();
                String string = this.resolvedLatestVersion = scanner.next();
                return string;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.failedToResolve();
        });
    }

    @Override
    public CompletableFuture<Boolean> checkForUpdate() {
        return this.resolveLatest().thenApply(ignored -> this.isUpdateAvailable());
    }

    public String failedToResolve() {
        Logging.warningLog("Failed to resolve latest BreweryX version from SpigotMC. (No connection?)");
        this.resolvedLatestVersion = "UNRESOLVED";
        return "UNRESOLVED";
    }

    @Override
    public String getDownloadURL() {
        return String.format(CONST_RELEASE_URL, this.resourceId);
    }
}

