/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer;

import com.xxmicloxx.NoteBlockAPI.model.Song;
import com.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.bukkit.Metrics;
import cz.studiodamage.NoteBlockMusicPlayer.charts.SimplePie;
import cz.studiodamage.NoteBlockMusicPlayer.commands.GlobalPlayerCommandExecutor;
import cz.studiodamage.NoteBlockMusicPlayer.commands.PluginCommandExecutor;
import cz.studiodamage.NoteBlockMusicPlayer.commands.PositionPlayerCommandExecutor;
import cz.studiodamage.NoteBlockMusicPlayer.commands.RadioCommandExecutor;
import cz.studiodamage.NoteBlockMusicPlayer.listeners.PlayerListener;
import cz.studiodamage.NoteBlockMusicPlayer.listeners.SongListener;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Config;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.objects.NoteBlockMusicPlayerPlaceholderExpansion;
import cz.studiodamage.NoteBlockMusicPlayer.objects.PlaceholderAPIMessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.objects.PlayerVolume;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Playlist;
import cz.studiodamage.NoteBlockMusicPlayer.objects.SongWithMetadata;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.DecentHologramsFactory;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramConfig;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramFactory;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramLibSupport;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HolographicDisplaysFactory;
import cz.studiodamage.NoteBlockMusicPlayer.player.GlobalRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.ServerRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.WorldRadio;
import cz.studiodamage.NoteBlockMusicPlayer.utils.PermissionsUtils;
import cz.studiodamage.NoteBlockMusicPlayer.utils.Updater;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class NoteBlockMusicPlayer
extends JavaPlugin {
    private static NoteBlockMusicPlayer instance;
    public static final String CONSOLE_PREFIX = "[NoteBlockMusicPlayer] ";
    private static final HologramLibSupport[] compatibleHologramLibs;
    public Logger logger;
    public YamlConfiguration config_language;
    HashMap<String, String> configNames = new HashMap();
    public HashMap<Config, YamlConfiguration> configs = new HashMap();
    public HashMap<String, Playlist> playlists;
    public HashMap<String, SongWithMetadata> songs;
    public HashMap<String, HologramConfig> hologram_list;
    private HologramFactory hologramFactory = null;
    private MessageProcessor messageProcessor;
    public boolean use10OctaveRange = false;
    private RadioManager radioManager = new RadioManager();

    public void onEnable() {
        if (!this.checkDependencies()) {
            return;
        }
        instance = this;
        this.logger = this.getServer().getLogger();
        try {
            this.checkConfigs();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        Metrics metrics = new Metrics(this, 386);
        metrics.addCustomChart(new SimplePie("language", () -> this.configs.get((Object)Config.Global).getString("language")));
        metrics.addCustomChart(new SimplePie("hologram", () -> this.isHologramLibAvailable() ? "Yes" : "No"));
        this.loadSongs();
        this.playlists = Playlist.load(this.configs.get((Object)Config.Playlists));
        this.hologram_list = HologramConfig.load((FileConfiguration)this.configs.get((Object)Config.Holograms));
        this.radioManager.setRadios(PositionRadio.class, PositionRadio.load((FileConfiguration)this.configs.get((Object)Config.PositionRadio)));
        this.radioManager.setRadios(WorldRadio.class, WorldRadio.load((FileConfiguration)this.configs.get((Object)Config.WorldRadio)));
        this.radioManager.setRadios(ServerRadio.class, ServerRadio.load((FileConfiguration)this.configs.get((Object)Config.ServerRadio)));
        GlobalRadio.checkEnable();
        this.radioManager.applyPriorities();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SongListener(), (Plugin)this);
        PermissionsUtils.createRadioPermissions(this.radioManager.getRadiosOfType(PositionRadio.class).values(), this.radioManager.getRadiosOfType(WorldRadio.class).values(), this.radioManager.getRadiosOfType(ServerRadio.class).values());
        this.logger.info("[NoteBlockMusicPlayer] Plugin NoteBlockMusicPlayer (v" + this.getDescription().getVersion() + ") is now enable.");
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            try {
                if (Updater.checkUpdate("37295", this.getDescription().getVersion())) {
                    Bukkit.getLogger().info(String.format("[%s] New update available!", this.getDescription().getName()));
                }
            }
            catch (IOException e) {
                Bukkit.getLogger().info(String.format("[%s] Cannot receive update from Spigot resource page!", this.getDescription().getName()));
            }
        }, 200L, 1728000L);
    }

    public void onDisable() {
        this.getLogger().info("[NoteBlockMusicPlayer] Plugin NoteBlockMusicPlayer (v" + this.getDescription().getVersion() + ") is now disable.");
    }

    public static NoteBlockMusicPlayer getInstance() {
        return instance;
    }

    private boolean checkDependencies() {
        Plugin noteBlockApiPlugin = Bukkit.getPluginManager().getPlugin("NoteBlockAPI");
        if (noteBlockApiPlugin == null || !noteBlockApiPlugin.isEnabled()) {
            this.getLogger().severe("[NoteBlockMusicPlayer] *** NoteBlockAPI plugin is not installed or enabled. ***");
            this.getLogger().severe("[NoteBlockMusicPlayer] *** The plugin will be disabled. ***");
            this.setEnabled(false);
            return false;
        }
        if ((double)Updater.getVersionNumber(noteBlockApiPlugin.getDescription().getVersion()) < 0.010205) {
            this.getLogger().severe("[NoteBlockMusicPlayer] *** At least NoteBlockAPI 1.2.5 is required for NoteBlockMusicPlayer to work! ***");
            this.getLogger().severe("[NoteBlockMusicPlayer] *** The plugin will be disabled. ***");
            this.setEnabled(false);
            return false;
        }
        for (HologramLibSupport libSupport : compatibleHologramLibs) {
            if (!Bukkit.getPluginManager().isPluginEnabled(libSupport.getLibName())) continue;
            this.getLogger().info("[NoteBlockMusicPlayer] Found " + libSupport.getLibName());
            this.hologramFactory = libSupport.getFactorySupplier().get();
            libSupport.getInitializer().accept((Plugin)this);
            break;
        }
        if (this.hologramFactory == null) {
            this.getLogger().severe("[NoteBlockMusicPlayer] *** No supported hologram lib found. Holograms feature is disabled. ***");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.messageProcessor = new PlaceholderAPIMessageProcessor();
            new NoteBlockMusicPlayerPlaceholderExpansion().register();
            this.getLogger().info("[NoteBlockMusicPlayer] Found PlaceholderAPI");
        } else {
            this.messageProcessor = new MessageProcessor();
        }
        return true;
    }

    private void registerCommands() {
        this.registerCommand("positionradio", new PositionPlayerCommandExecutor());
        this.registerCommand("worldradio", new GlobalPlayerCommandExecutor());
        this.registerCommand("serverradio", new GlobalPlayerCommandExecutor());
        this.registerCommand("noteblockmusicplayer", new PluginCommandExecutor());
        this.registerCommand("radio", new RadioCommandExecutor());
    }

    private <T extends CommandExecutor & TabCompleter> void registerCommand(String commandName, T executor) {
        PluginCommand command = this.getCommand(commandName);
        if (command == null) {
            throw new IllegalArgumentException();
        }
        command.setExecutor(executor);
        command.setTabCompleter((TabCompleter)executor);
    }

    public void about(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "Plugin NoteBlockMusicPlayer " + instance.getDescription().getVersion() + " created by koca2000.");
        String usageText = Language.COMMAND_ABOUT.getText();
        if (!usageText.isEmpty()) {
            sender.sendMessage(usageText);
        }
    }

    public void checkConfigs() throws InvalidConfigurationException {
        boolean bl;
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            this.logger.severe("[NoteBlockMusicPlayer] Can not create plugin's data directory");
        }
        this.configNames.clear();
        this.configs.clear();
        File file_config = new File(this.getDataFolder(), "config.yml");
        if (!file_config.exists()) {
            this.getLogger().info("[NoteBlockMusicPlayer] config.yml not found, creating!");
            Config.saveDefaultConfig(new Config[]{Config.Global}, "config.yml");
        }
        try {
            YamlConfiguration config_global = new YamlConfiguration();
            config_global.load(file_config);
            this.configs.put(Config.Global, config_global);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (Config type : Config.values()) {
            if (type == Config.Global || type == Config.PlayerVolumes) continue;
            if (type == Config.Songs) {
                this.configNames.put(type.name(), type.getDefaultYML());
                continue;
            }
            this.configNames.put(type.name(), this.configs.get((Object)Config.Global).getString("config_" + type.name(), type.getDefaultYML()));
        }
        for (Map.Entry entry : this.configNames.entrySet()) {
            this.configs.put(Config.valueOf((String)entry.getKey()), Config.getConfig(new File(this.getDataFolder(), (String)entry.getValue()), Config.valueOf((String)entry.getKey())));
        }
        String lang = this.configs.getOrDefault((Object)Config.Global, new YamlConfiguration()).getString("language");
        if (lang == null || lang.isEmpty()) {
            lang = "en";
        }
        boolean bl2 = false;
        File file_lang = null;
        while (!bl) {
            file_lang = new File(this.getDataFolder(), "messages_" + lang + ".yml");
            if (!file_lang.exists()) {
                if (lang.equalsIgnoreCase("en")) {
                    this.getLogger().info("[NoteBlockMusicPlayer] messages_" + lang + ".yml not found, creating!");
                    Language.createDefaultYML();
                    bl = true;
                    continue;
                }
                this.getLogger().info("[NoteBlockMusicPlayer] messages_" + lang + ".yml not found, changing to english!");
                lang = "en";
                continue;
            }
            bl = true;
        }
        this.config_language = new YamlConfiguration();
        try {
            this.config_language.load(file_lang);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PlayerVolume.setDefaultVolume(this.configs.get((Object)Config.Global).getInt("defaultPlayerVolume", 100));
        PlayerVolume.setVolumePersistent(this.configs.get((Object)Config.Global).getBoolean("savePlayerVolumes", false));
        this.use10OctaveRange = this.configs.get((Object)Config.Global).getBoolean("use10OctaveRange", false);
        PlayerVolume.load();
    }

    public void savePlaylists() {
        try {
            this.configs.get((Object)Config.Playlists).save(new File(this.getDataFolder(), this.configNames.get(Config.Playlists.name())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() throws InvalidConfigurationException {
        this.checkConfigs();
        this.loadSongs();
        Playlist.reload();
    }

    private void loadSongs() {
        this.songs = new HashMap();
        File folder = new File(NoteBlockMusicPlayer.getInstance().getDataFolder(), "songs/");
        if (!folder.exists() && !folder.mkdir()) {
            this.logger.severe("[NoteBlockMusicPlayer] Can not create 'songs' directory");
            return;
        }
        FileConfiguration cfg = (FileConfiguration)this.configs.get((Object)Config.Songs);
        this.loadSongsFromDir(folder);
        try {
            cfg.save(new File(this.getDataFolder(), this.configNames.get(Config.Songs.name())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadSongsFromDir(File dir) {
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        FileConfiguration cfg = (FileConfiguration)this.configs.get((Object)Config.Songs);
        String dirPath = dir.getPath().replace(new File(NoteBlockMusicPlayer.getInstance().getDataFolder(), "songs/").getPath(), "");
        if (!dirPath.equals("")) {
            dirPath = dirPath.substring(1).replaceAll(File.pathSeparator, "/") + "/";
        }
        for (File file : listOfFiles) {
            if (file.isFile()) {
                Song s;
                String name = "";
                String extension = "";
                int i = file.getName().lastIndexOf(46);
                if (i > 0) {
                    name = dirPath + file.getName().substring(0, i);
                    extension = file.getName().substring(i + 1);
                }
                if (!extension.equalsIgnoreCase("nbs") || (s = NBSDecoder.parse((File)file)) == null) continue;
                SongWithMetadata songWithMetadata = new SongWithMetadata(s, name, s.getTitle(), s.getAuthor());
                if (cfg.contains("songs." + songWithMetadata.getFileName())) {
                    songWithMetadata.setCustomTitle(cfg.getString("songs." + songWithMetadata.getFileName() + ".title", songWithMetadata.getCustomTitle()));
                    songWithMetadata.setCustomArtist(cfg.getString("songs." + songWithMetadata.getFileName() + ".author", songWithMetadata.getCustomArtist()));
                } else {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("title", songWithMetadata.getCustomTitle());
                    params.put("author", songWithMetadata.getCustomArtist());
                    cfg.set("songs." + songWithMetadata.getFileName(), params);
                }
                this.songs.put(name, songWithMetadata);
                continue;
            }
            this.loadSongsFromDir(file);
        }
    }

    public boolean isHologramLibAvailable() {
        return this.hologramFactory != null;
    }

    @Nullable
    public HologramFactory getHologramFactory() {
        return this.hologramFactory;
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public RadioManager getRadioManager() {
        return this.radioManager;
    }

    static {
        compatibleHologramLibs = new HologramLibSupport[]{new HologramLibSupport("DecentHolograms", DecentHologramsFactory::new, DecentHologramsFactory::initialize), new HologramLibSupport("HolographicDisplays", HolographicDisplaysFactory::new, p -> {})};
    }
}

