/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer;

import cz.studiodamage.NoteBlockMusicPlayer.RadioDefinition;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.ServerRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.WorldRadio;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class RadioManager {
    private final Map<Class<? extends Radio>, Map<String, ? extends Radio>> radios = new HashMap<Class<? extends Radio>, Map<String, ? extends Radio>>();
    private final SortedSet<RadioDefinition> radioDefinitions = new TreeSet<RadioDefinition>(new RadioDefinition.Comparator());

    public RadioManager() {
        this.registerRadioDefinition(PositionRadio.class, 1, false);
        this.registerRadioDefinition(WorldRadio.class, 2, true);
        this.registerRadioDefinition(ServerRadio.class, 3, true);
    }

    public <T extends Radio> void setRadios(Class<T> radioClass, Map<String, T> radioMap) {
        this.radios.computeIfPresent(radioClass, (key, oldMap) -> radioMap);
    }

    public void applyPriorities() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.applyPriorities(player);
        }
    }

    public List<Radio> applyPriorities(Player player) {
        ArrayList<Radio> inRadios = new ArrayList<Radio>();
        int currentPriority = Integer.MIN_VALUE;
        boolean isInRadioFromPreviousPriority = false;
        boolean isInRadioFromCurrentPriority = false;
        for (RadioDefinition definition : this.radioDefinitions) {
            List<Radio> inRadiosOfDefinition;
            if (currentPriority != definition.getPriority()) {
                isInRadioFromPreviousPriority |= isInRadioFromCurrentPriority;
                isInRadioFromCurrentPriority = false;
                currentPriority = definition.getPriority();
            }
            isInRadioFromCurrentPriority |= !(inRadiosOfDefinition = this.applyPrioritiesForDefinition(player, definition, isInRadioFromPreviousPriority, isInRadioFromCurrentPriority)).isEmpty();
            inRadios.addAll(inRadiosOfDefinition);
        }
        return inRadios;
    }

    private List<Radio> applyPrioritiesForDefinition(Player player, RadioDefinition definition, boolean isInRadioFromPreviousPriority, boolean isInRadioFromCurrentPriority) {
        ArrayList<Radio> inRadios = new ArrayList<Radio>();
        Map<String, ? extends Radio> radiosOfType = this.radios.get(definition.getRadioClass());
        if (radiosOfType == null) {
            return inRadios;
        }
        boolean isInRadio = isInRadioFromCurrentPriority;
        for (Radio radio : radiosOfType.values()) {
            if (!(isInRadioFromPreviousPriority || isInRadio && definition.isExclusive() || !radio.isHearableFor(player))) {
                radio.addPlayer(player);
                if (!radio.isListening(player)) continue;
                isInRadio = true;
                inRadios.add(radio);
                continue;
            }
            radio.removePlayer(player);
        }
        return inRadios;
    }

    public <T extends Radio> T getRadio(Class<T> radioClass, String name) {
        Map<String, ? extends Radio> map = this.radios.get(radioClass);
        if (map == null) {
            return null;
        }
        return (T)map.get(name);
    }

    public <T extends Radio> Map<String, T> getRadiosOfType(Class<T> radioClass) {
        Map<String, ? extends Radio> map = this.radios.get(radioClass);
        if (map == null) {
            return new HashMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public Iterable<Radio> getAllRadios() {
        return () -> this.radios.values().stream().flatMap(m -> m.values().stream()).map(r -> r).iterator();
    }

    private void registerRadioDefinition(Class<? extends Radio> radioClass, int priority, boolean isExclusive) {
        this.radioDefinitions.add(new RadioDefinition(radioClass, priority, isExclusive));
        this.radios.put(radioClass, new HashMap());
    }
}

