/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.commands;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.commands.CommandExecutorType;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Config;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.player.GlobalRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.player.ServerRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.WorldRadio;
import cz.studiodamage.NoteBlockMusicPlayer.utils.SongUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GlobalPlayerCommandExecutor
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String arg2, @NotNull String[] args) {
        Radio.RadioType type;
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        switch (cmd.getName()) {
            case "worldradio": {
                type = Radio.RadioType.WORLD_RADIO;
                break;
            }
            case "serverradio": {
                type = Radio.RadioType.SERVER_RADIO;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        CommandExecutorType executor = CommandExecutorType.UNKNOWN;
        if (sender instanceof ConsoleCommandSender) {
            executor = CommandExecutorType.CONSOLE;
        }
        if (sender instanceof Player) {
            executor = CommandExecutorType.PLAYER;
        }
        if (executor != CommandExecutorType.UNKNOWN) {
            if (args.length > 0) {
                switch (args[0]) {
                    case "enable": {
                        this.EnableDisable(true, args, executor, sender, type);
                        break;
                    }
                    case "reload": {
                        Player p;
                        if (executor == CommandExecutorType.PLAYER && (!(p = (Player)sender).hasPermission("worldradio.admin") && type == Radio.RadioType.WORLD_RADIO || !p.hasPermission("serverradio.admin") && type == Radio.RadioType.SERVER_RADIO)) {
                            messageProcessor.sendMessage((CommandSender)p, Language.COMMAND_PERMISSIONS);
                            break;
                        }
                        boolean reload = GlobalPlayerCommandExecutor.Reload(type);
                        messageProcessor.sendMessage(sender, reload ? Language.COMMAND_RADIO_RELOAD_SUCCESS : Language.COMMAND_RADIO_RELOAD_FAILED, MessagePlaceholder.builder().with(Radio.getTypePlaceholder(type)).get());
                        break;
                    }
                    case "skip": {
                        Player p;
                        if (executor == CommandExecutorType.PLAYER && (!(p = (Player)sender).hasPermission("worldradio.skip") && type == Radio.RadioType.WORLD_RADIO || !p.hasPermission("serverradio.skip") && type == Radio.RadioType.SERVER_RADIO)) {
                            messageProcessor.sendMessage((CommandSender)p, Language.COMMAND_PERMISSIONS);
                            break;
                        }
                        if (args.length > 1) {
                            Map<String, ? extends GlobalRadio> list = this.getGlobalRadiosByType(type);
                            GlobalRadio radio = list.get(args[1]);
                            if (radio != null) {
                                if (radio.isLoaded()) {
                                    String songTitle = SongUtils.getTitleOrFallback(radio.getSongPlayer().getSong());
                                    radio.playNextSong();
                                    messageProcessor.sendMessage(sender, Language.COMMAND_SKIP_SONG, MessagePlaceholder.builder().of("%song_title%", songTitle).of("%radio%", radio.getName()).with(Radio.getTypePlaceholder(type)).get());
                                    break;
                                }
                                messageProcessor.sendMessage(sender, Language.COMMAND_SKIP_SONG_NOT_LOADED, MessagePlaceholder.builder().of("%radio%", radio.getName()).with(Radio.getTypePlaceholder(radio)).get());
                                break;
                            }
                            messageProcessor.sendMessage(sender, Language.COMMAND_RADIO_NOTFOUND, MessagePlaceholder.builder().of("%radio%", args[1]).with(Radio.getTypePlaceholder(type)).get());
                            break;
                        }
                        messageProcessor.sendMessage(sender, Language.COMMAND_SKIP_HINT, MessagePlaceholder.builder().of("%radio_type%", type.getCommandPart()).get());
                        break;
                    }
                    case "disable": {
                        this.EnableDisable(false, args, executor, sender, type);
                        break;
                    }
                    default: {
                        this.Help(sender, type);
                    }
                }
            } else {
                NoteBlockMusicPlayer.getInstance().about(sender);
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] args) {
        ArrayList<String> hints;
        block9: {
            RadioManager radioManager;
            block8: {
                radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
                hints = new ArrayList<String>();
                if (args.length != 1) break block8;
                String[] commands = new String[]{"enable", "disable", "skip", "reload", "help"};
                if (!args[0].equals("")) {
                    for (String string : commands) {
                        if (!string.startsWith(args[0].toLowerCase())) continue;
                        hints.add(string);
                    }
                } else {
                    Collections.addAll(hints, commands);
                }
                break block9;
            }
            if (args.length != 2 || !args[0].equalsIgnoreCase("enable") && !args[0].equalsIgnoreCase("disable") && !args[0].equalsIgnoreCase("skip")) break block9;
            Collection<Object> radios = new ArrayList();
            Radio.RadioType type = null;
            if (command.getName().equalsIgnoreCase("worldradio")) {
                radios = radioManager.getRadiosOfType(WorldRadio.class).values();
                type = Radio.RadioType.WORLD_RADIO;
            } else if (command.getName().equalsIgnoreCase("serverradio")) {
                radios = radioManager.getRadiosOfType(ServerRadio.class).values();
                type = Radio.RadioType.SERVER_RADIO;
            }
            Player p = null;
            if (commandSender instanceof Player) {
                p = (Player)commandSender;
            }
            for (Radio radio : radios) {
                if (p != null && !p.hasPermission(type.getPermissionNode() + radio.getName()) || !args[1].isEmpty() && !radio.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                hints.add(radio.getName());
            }
        }
        return hints;
    }

    private void EnableDisable(boolean state, String[] args, CommandExecutorType executor, CommandSender sender, Radio.RadioType type) {
        Player p;
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        if (executor == CommandExecutorType.PLAYER && (!(p = (Player)sender).hasPermission("worldradio.enable") && type == Radio.RadioType.WORLD_RADIO || !p.hasPermission("serverradio.enable") && type == Radio.RadioType.SERVER_RADIO)) {
            messageProcessor.sendMessage((CommandSender)p, Language.COMMAND_PERMISSIONS);
            return;
        }
        if (args.length <= 1) {
            messageProcessor.sendMessage(sender, Language.COMMAND_STATE_HINT, MessagePlaceholder.builder().with(Radio.getTypePlaceholder(type)).get());
            return;
        }
        boolean found = false;
        Collection<? extends GlobalRadio> list = this.getGlobalRadiosByType(type).values();
        ArrayList<GlobalRadio> others = new ArrayList<GlobalRadio>();
        World world = null;
        for (GlobalRadio globalRadio : list) {
            if (globalRadio.getName().equalsIgnoreCase(args[1])) {
                found = true;
                if (globalRadio instanceof WorldRadio) {
                    WorldRadio wrl = (WorldRadio)globalRadio;
                    world = wrl.getWorld();
                }
                if (!globalRadio.isLoaded()) {
                    messageProcessor.sendMessage(sender, Language.COMMAND_STATE_NOT_LOADED, MessagePlaceholder.builder().of("%radio%", globalRadio.getName()).with(Radio.getTypePlaceholder(globalRadio)).get());
                    return;
                }
                globalRadio.setEnable(state);
                messageProcessor.sendMessage(sender, state ? Language.COMMAND_STATE_ENABLE : Language.COMMAND_STATE_DISABLE, MessagePlaceholder.builder().of("%radio%", globalRadio.getName()).with(Radio.getTypePlaceholder(globalRadio)).get());
                continue;
            }
            if (!globalRadio.isEnable()) continue;
            others.add(globalRadio);
        }
        if (!found) {
            messageProcessor.sendMessage(sender, Language.COMMAND_RADIO_NOTFOUND, MessagePlaceholder.builder().of("%radio%", args[1]).with(Radio.getTypePlaceholder(type)).get());
            return;
        }
        if (!state) {
            for (GlobalRadio globalRadio : others) {
                if (world == null) {
                    globalRadio.setEnable(false);
                    continue;
                }
                if (!world.equals((Object)((WorldRadio)globalRadio).getWorld())) continue;
                globalRadio.setEnable(false);
            }
        }
        radioManager.applyPriorities();
    }

    public static boolean Reload(Radio.RadioType type) {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        try {
            if (type == Radio.RadioType.WORLD_RADIO) {
                for (GlobalRadio globalRadio : radioManager.getRadiosOfType(WorldRadio.class).values()) {
                    globalRadio.destroy();
                }
                NoteBlockMusicPlayer.getInstance().checkConfigs();
                radioManager.setRadios(WorldRadio.class, WorldRadio.load((FileConfiguration)NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.WorldRadio)));
            }
            if (type == Radio.RadioType.SERVER_RADIO) {
                for (GlobalRadio globalRadio : radioManager.getRadiosOfType(ServerRadio.class).values()) {
                    globalRadio.destroy();
                }
                NoteBlockMusicPlayer.getInstance().checkConfigs();
                radioManager.setRadios(ServerRadio.class, ServerRadio.load((FileConfiguration)NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.ServerRadio)));
            }
            GlobalRadio.checkEnable();
            radioManager.applyPriorities();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void Help(CommandSender sender, Radio.RadioType type) {
        sender.sendMessage(ChatColor.GOLD + "Commands for Position Radios:");
        sender.sendMessage(ChatColor.GOLD + "/" + type.getCommandPart() + "radio <enable/disable> <name of radio> - enable/disable given radio");
        sender.sendMessage(ChatColor.GOLD + "/" + type.getCommandPart() + "radio skip <name of radio> - skip actual song in radio");
        sender.sendMessage(ChatColor.GOLD + "/" + type.getCommandPart() + "radio reload - turn off and reloads from config all " + type.getCommandPart() + " radios");
        sender.sendMessage(ChatColor.GOLD + "/" + type.getCommandPart() + "radio help - shows this help");
    }

    private Map<String, ? extends GlobalRadio> getGlobalRadiosByType(Radio.RadioType type) {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        switch (type) {
            case WORLD_RADIO: {
                return radioManager.getRadiosOfType(WorldRadio.class);
            }
            case SERVER_RADIO: {
                return radioManager.getRadiosOfType(ServerRadio.class);
            }
        }
        throw new IllegalArgumentException();
    }
}

