/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.commands;

import com.xxmicloxx.NoteBlockAPI.model.Song;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.commands.CommandExecutorType;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Config;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Playlist;
import cz.studiodamage.NoteBlockMusicPlayer.objects.hologram.HologramConfig;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import cz.studiodamage.NoteBlockMusicPlayer.utils.SongUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PluginCommandExecutor
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command arg1, @NotNull String arg2, String[] args) {
        block58: {
            block60: {
                block59: {
                    NoteBlockMusicPlayer nbmp = NoteBlockMusicPlayer.getInstance();
                    MessageProcessor messageProcessor = nbmp.getMessageProcessor();
                    RadioManager radioManager = nbmp.getRadioManager();
                    CommandExecutorType executor = CommandExecutorType.UNKNOWN;
                    if (sender instanceof ConsoleCommandSender) {
                        executor = CommandExecutorType.CONSOLE;
                    }
                    if (sender instanceof Player) {
                        executor = CommandExecutorType.PLAYER;
                    }
                    if (executor == CommandExecutorType.UNKNOWN) break block58;
                    if (args.length <= 0) break block59;
                    block9 : switch (args[0]) {
                        case "reload": {
                            if (executor == CommandExecutorType.PLAYER && !sender.hasPermission("nbmp.admin")) {
                                this.sendNoPermsMessage(sender);
                                return true;
                            }
                            try {
                                nbmp.reload();
                                messageProcessor.sendMessage(sender, Language.COMMAND_GLOBAL_RELOAD_SUCCESS);
                            }
                            catch (InvalidConfigurationException e1) {
                                e1.printStackTrace();
                                messageProcessor.sendMessage(sender, Language.COMMAND_GLOBAL_RELOAD_FAILED);
                            }
                            break;
                        }
                        case "hologram": {
                            if (args.length > 1 && "reload".equals(args[1])) {
                                if (nbmp.isHologramLibAvailable()) {
                                    Object p;
                                    if (executor == CommandExecutorType.PLAYER && !(p = (Player)sender).hasPermission("nbmp.hologram.admin")) {
                                        this.sendNoPermsMessage(sender);
                                        break;
                                    }
                                    try {
                                        nbmp.checkConfigs();
                                        nbmp.hologram_list = HologramConfig.load((FileConfiguration)nbmp.configs.get((Object)Config.Holograms));
                                        for (PositionRadio posrad : radioManager.getRadiosOfType(PositionRadio.class).values()) {
                                            posrad.destroyHolograms();
                                            posrad.createHolograms();
                                        }
                                        messageProcessor.sendMessage(sender, Language.COMMAND_HOLOGRAM_RELOAD_SUCCESS);
                                    }
                                    catch (InvalidConfigurationException e) {
                                        messageProcessor.sendMessage(sender, Language.COMMAND_HOLOGRAM_RELOAD_FAILED);
                                        e.printStackTrace();
                                    }
                                    break;
                                }
                                messageProcessor.sendMessage(sender, Language.COMMAND_HOLOGRAM_DISABLE);
                                break;
                            }
                            break block60;
                        }
                        case "playlist": {
                            if (args.length > 1) {
                                switch (args[1]) {
                                    case "create": {
                                        if (executor == CommandExecutorType.PLAYER && !sender.hasPermission("nbmp.playlist.create")) {
                                            this.sendNoPermsMessage(sender);
                                            break block9;
                                        }
                                        if (args.length > 2) {
                                            if (!NoteBlockMusicPlayer.getInstance().playlists.containsKey(args[2])) {
                                                Playlist.create(args[2]);
                                                messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_CREATE, MessagePlaceholder.builder().of("%playlist%", args[2]).get());
                                                break block9;
                                            }
                                            messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_EXISTS, MessagePlaceholder.builder().of("%playlist%", args[2]).get());
                                            break block9;
                                        }
                                        messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_CREATE_HINT);
                                        break block9;
                                    }
                                    case "reload": {
                                        Player p;
                                        if (executor == CommandExecutorType.PLAYER && !(p = (Player)sender).hasPermission("nbmp.playlist.admin")) {
                                            this.sendNoPermsMessage(sender);
                                            break block9;
                                        }
                                        boolean reload = Playlist.reload();
                                        if (reload) {
                                            messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_RELOAD_SUCCESS);
                                            break block9;
                                        }
                                        messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_RELOAD_FAILED);
                                        break block9;
                                    }
                                    case "remove": {
                                        if (executor == CommandExecutorType.PLAYER && !sender.hasPermission("nbmp.playlist.add")) {
                                            this.sendNoPermsMessage(sender);
                                            break block9;
                                        }
                                        if (args.length > 3) {
                                            if (nbmp.playlists.containsKey(args[2])) {
                                                nbmp.playlists.get(args[2]).remove(args[3]);
                                                messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_REMOVE, MessagePlaceholder.builder().of("%playlist%", args[2]).of("%song_title%", args[3]).get());
                                                break block9;
                                            }
                                            messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_NOTFOUND, MessagePlaceholder.builder().of("%playlist%", args[2]).get());
                                            break block9;
                                        }
                                        messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_REMOVE_HINT);
                                        break block9;
                                    }
                                    case "add": {
                                        if (executor == CommandExecutorType.PLAYER && !sender.hasPermission("nbmp.playlist.add")) {
                                            this.sendNoPermsMessage(sender);
                                            break block9;
                                        }
                                        if (args.length > 3) {
                                            if (NoteBlockMusicPlayer.getInstance().playlists.containsKey(args[2])) {
                                                NoteBlockMusicPlayer.getInstance().playlists.get(args[2]).add(args[3]);
                                                messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_ADD, MessagePlaceholder.builder().of("%playlist%", args[2]).of("%song_title%", args[3]).get());
                                                break block9;
                                            }
                                            messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_NOTFOUND, MessagePlaceholder.builder().of("%playlist%", args[2]).get());
                                            break block9;
                                        }
                                        messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_ADD_HINT);
                                        break block9;
                                    }
                                    case "list": {
                                        if (executor == CommandExecutorType.PLAYER && !sender.hasPermission("nbmp.playlist.list")) {
                                            this.sendNoPermsMessage(sender);
                                            break block9;
                                        }
                                        HashMap<String, Playlist> playlists = NoteBlockMusicPlayer.getInstance().playlists;
                                        StringBuilder messageBuilder = new StringBuilder();
                                        for (Map.Entry<String, Playlist> entry : playlists.entrySet()) {
                                            String key = entry.getKey();
                                            messageBuilder.append(", ").append(key);
                                        }
                                        messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_LIST, messageBuilder.toString().replaceFirst(", ", " "));
                                        break block9;
                                    }
                                    case "songs": {
                                        if (executor == CommandExecutorType.PLAYER && !sender.hasPermission("nbmp.playlist.list")) {
                                            this.sendNoPermsMessage(sender);
                                            break block9;
                                        }
                                        if (args.length > 2) {
                                            try {
                                                ArrayList songs = NoteBlockMusicPlayer.getInstance().playlists.get(args[2]).getSongs().getSongList();
                                                StringBuilder messageBuilder = new StringBuilder();
                                                for (Song song : songs) {
                                                    messageBuilder.append(", ").append('\'').append(SongUtils.getTitleOrFallback(song)).append('\'');
                                                }
                                                messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_SONGS, MessagePlaceholder.builder().of("%playlist%", args[2]).get(), messageBuilder.toString().replaceFirst(", ", " "));
                                            }
                                            catch (Exception e) {
                                                messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_NOTFOUND, MessagePlaceholder.builder().of("%playlist%", args[2]).get());
                                            }
                                            break block9;
                                        }
                                        messageProcessor.sendMessage(sender, Language.COMMAND_PLAYLIST_SONGS_HINT);
                                        break block9;
                                    }
                                }
                                this.HelpPlaylists(sender);
                                break;
                            }
                            break block60;
                        }
                        default: {
                            this.Help(sender);
                        }
                    }
                    break block60;
                }
                NoteBlockMusicPlayer.getInstance().about(sender);
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String s, String[] args) {
        ArrayList<String> hints = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return hints;
        }
        if (args.length == 1) {
            String[] commands = new String[]{"reload", "help", "hologram", "playlist"};
            if (!args[0].isEmpty()) {
                for (String com : commands) {
                    if (!com.startsWith(args[0].toLowerCase())) continue;
                    hints.add(com);
                }
            } else {
                Collections.addAll(hints, commands);
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("hologram")) {
                String[] commands = new String[]{"reload"};
                if (!args[1].isEmpty()) {
                    for (String com : commands) {
                        if (!com.startsWith(args[1].toLowerCase())) continue;
                        hints.add(com);
                    }
                } else {
                    Collections.addAll(hints, commands);
                }
            } else if (args[0].equalsIgnoreCase("playlist")) {
                String[] commands = new String[]{"reload", "create", "remove", "add", "list", "songs", "help"};
                if (!args[1].isEmpty()) {
                    for (String com : commands) {
                        if (!com.startsWith(args[1].toLowerCase())) continue;
                        hints.add(com);
                    }
                } else {
                    Collections.addAll(hints, commands);
                }
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("playlist") && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("remove") || args[1].equalsIgnoreCase("songs"))) {
            Set<String> commands = NoteBlockMusicPlayer.getInstance().playlists.keySet();
            if (!args[2].equals("")) {
                for (String com : commands) {
                    if (!com.startsWith(args[2].toLowerCase())) continue;
                    hints.add(com);
                }
            } else {
                hints.addAll(commands);
            }
        }
        return hints;
    }

    private void Help(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "Commands for NoteBlockMusicPlayer plugin:");
        sender.sendMessage(ChatColor.GOLD + "/positionradio help - show help for position radios");
        sender.sendMessage(ChatColor.GOLD + "/worldradio help - show help for world radios");
        sender.sendMessage(ChatColor.GOLD + "/serverradio help - show help for server radios");
        sender.sendMessage(ChatColor.GOLD + "/nbmp playlist help - show help for playlists");
        sender.sendMessage(ChatColor.GOLD + "/radio help - show help for player controls");
    }

    private void sendNoPermsMessage(CommandSender sender) {
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        messageProcessor.sendMessage(sender, Language.COMMAND_PERMISSIONS);
    }

    private void HelpPlaylists(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "Commands for Playlists:");
        sender.sendMessage(ChatColor.GOLD + "Use /nbmp playlist reload - reload all playlists from config");
        sender.sendMessage(ChatColor.GOLD + "Use /nbmp playlist create <name of playlist> - creates new playlist");
        sender.sendMessage(ChatColor.GOLD + "Use /nbmp playlist songs <name of playlist> - shows list of songs in playlist");
        sender.sendMessage(ChatColor.GOLD + "Use /nbmp playlist add <name of playlist> <name of song> - add song to playlist");
        sender.sendMessage(ChatColor.GOLD + "Use /nbmp playlist remove <name of playlist> <name of song> - remove song from playlist");
        sender.sendMessage(ChatColor.GOLD + "Use /nbmp playlist list - shows list of playlists");
        sender.sendMessage(ChatColor.GOLD + "Use /nbmp playlist help - shows this help");
    }
}

