/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.commands;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.commands.CommandExecutorType;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Config;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.player.PositionRadio;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import cz.studiodamage.NoteBlockMusicPlayer.utils.SongUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PositionPlayerCommandExecutor
implements TabExecutor {
    public boolean onCommand(CommandSender sender, Command arg1, String arg2, String[] args) {
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        CommandExecutorType executor = CommandExecutorType.UNKNOWN;
        if (sender instanceof ConsoleCommandSender) {
            executor = CommandExecutorType.CONSOLE;
        }
        if (sender instanceof Player) {
            executor = CommandExecutorType.PLAYER;
        }
        if (executor != CommandExecutorType.UNKNOWN) {
            if (args.length > 0) {
                switch (args[0]) {
                    case "enable": {
                        this.EnableDisable(true, args, executor, sender);
                        break;
                    }
                    case "reload": {
                        Player p;
                        if (executor == CommandExecutorType.PLAYER && !(p = (Player)sender).hasPermission("positionradio.admin")) {
                            messageProcessor.sendMessage((CommandSender)p, Language.COMMAND_PERMISSIONS);
                            break;
                        }
                        boolean reload = PositionPlayerCommandExecutor.Reload();
                        messageProcessor.sendMessage(sender, reload ? Language.COMMAND_RADIO_RELOAD_SUCCESS : Language.COMMAND_RADIO_RELOAD_FAILED, MessagePlaceholder.builder().with(Radio.getTypePlaceholder(Radio.RadioType.POSITION_RADIO)).get());
                        break;
                    }
                    case "skip": {
                        Player p;
                        if (executor == CommandExecutorType.PLAYER && !(p = (Player)sender).hasPermission("positionradio.skip")) {
                            messageProcessor.sendMessage((CommandSender)p, Language.COMMAND_PERMISSIONS);
                            break;
                        }
                        if (args.length > 1) {
                            PositionRadio radio = radioManager.getRadio(PositionRadio.class, args[1]);
                            if (radio != null) {
                                if (radio.isLoaded()) {
                                    String songTitle = SongUtils.getTitleOrFallback(radio.getSongPlayer().getSong());
                                    radio.playNextSong();
                                    messageProcessor.sendMessage(sender, Language.COMMAND_SKIP_SONG, MessagePlaceholder.builder().of("%song_title%", songTitle).of("%radio%", radio.getName()).with(Radio.getTypePlaceholder(radio)).get());
                                    break;
                                }
                                messageProcessor.sendMessage(sender, Language.COMMAND_SKIP_SONG_NOT_LOADED, MessagePlaceholder.builder().of("%radio%", radio.getName()).with(Radio.getTypePlaceholder(radio)).get());
                                break;
                            }
                            messageProcessor.sendMessage(sender, Language.COMMAND_RADIO_NOTFOUND, MessagePlaceholder.builder().of("%radio%", args[1]).with(Radio.getTypePlaceholder(Radio.RadioType.POSITION_RADIO)).get());
                            break;
                        }
                        messageProcessor.sendMessage(sender, Language.COMMAND_SKIP_HINT, MessagePlaceholder.builder().with(Radio.getTypePlaceholder(Radio.RadioType.POSITION_RADIO)).get());
                        break;
                    }
                    case "disable": {
                        this.EnableDisable(false, args, executor, sender);
                        break;
                    }
                    default: {
                        this.Help(sender);
                    }
                }
            } else {
                NoteBlockMusicPlayer.getInstance().about(sender);
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] args) {
        ArrayList<String> hints;
        block6: {
            RadioManager radioManager;
            block5: {
                radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
                hints = new ArrayList<String>();
                if (args.length != 1) break block5;
                String[] commands = new String[]{"enable", "disable", "skip", "reload", "help"};
                if (!args[0].equals("")) {
                    for (String com : commands) {
                        if (!com.startsWith(args[0].toLowerCase())) continue;
                        hints.add(com);
                    }
                } else {
                    Collections.addAll(hints, commands);
                }
                break block6;
            }
            if (args.length != 2 || !args[0].equalsIgnoreCase("enable") && !args[0].equalsIgnoreCase("disable") && !args[0].equalsIgnoreCase("skip")) break block6;
            Player p = null;
            if (commandSender instanceof Player) {
                p = (Player)commandSender;
            }
            Radio.RadioType type = Radio.RadioType.POSITION_RADIO;
            for (PositionRadio radio : radioManager.getRadiosOfType(PositionRadio.class).values()) {
                if (p != null && !p.hasPermission(type.getPermissionNode() + radio.getName()) || !args[1].isEmpty() && !radio.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                hints.add(radio.getName());
            }
        }
        return hints;
    }

    private void EnableDisable(boolean state, String[] args, CommandExecutorType executor, CommandSender sender) {
        Player p;
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        if (executor == CommandExecutorType.PLAYER && !(p = (Player)sender).hasPermission("positionradio.enable")) {
            messageProcessor.sendMessage((CommandSender)p, Language.COMMAND_PERMISSIONS);
            return;
        }
        if (args.length > 1) {
            PositionRadio radio = radioManager.getRadio(PositionRadio.class, args[1]);
            if (radio != null) {
                if (radio.isLoaded()) {
                    radio.setEnable(state);
                    messageProcessor.sendMessage(sender, state ? Language.COMMAND_STATE_ENABLE : Language.COMMAND_STATE_DISABLE, MessagePlaceholder.builder().of("%radio%", radio.getName()).with(Radio.getTypePlaceholder(radio)).get());
                } else {
                    messageProcessor.sendMessage(sender, Language.COMMAND_STATE_NOT_LOADED, MessagePlaceholder.builder().of("%radio%", radio.getName()).with(Radio.getTypePlaceholder(radio)).get());
                }
            } else {
                messageProcessor.sendMessage(sender, Language.COMMAND_RADIO_NOTFOUND, MessagePlaceholder.builder().of("%radio%", args[1]).with(Radio.getTypePlaceholder(Radio.RadioType.POSITION_RADIO)).get());
            }
        } else {
            messageProcessor.sendMessage(sender, Language.COMMAND_STATE_HINT, MessagePlaceholder.builder().of("%radio_type%", Radio.RadioType.POSITION_RADIO.getCommandPart()).get());
        }
        radioManager.applyPriorities();
    }

    public static boolean Reload() {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        try {
            for (PositionRadio radio : radioManager.getRadiosOfType(PositionRadio.class).values()) {
                radio.destroy();
            }
            NoteBlockMusicPlayer.getInstance().checkConfigs();
            radioManager.setRadios(PositionRadio.class, PositionRadio.load((FileConfiguration)NoteBlockMusicPlayer.getInstance().configs.get((Object)Config.PositionRadio)));
            radioManager.applyPriorities();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void Help(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "Commands for Position Radios:");
        sender.sendMessage(ChatColor.GOLD + "/positionradio <enable/disable> <name of radio> - enable/disable given radio");
        sender.sendMessage(ChatColor.GOLD + "/positionradio skip <name of radio> - skip actual song in radio");
        sender.sendMessage(ChatColor.GOLD + "/positionradio reload - turn off and reloads from config all position radios");
        sender.sendMessage(ChatColor.GOLD + "/positionradio help - shows this help");
    }
}

