/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.commands;

import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.commands.CommandExecutorType;
import cz.studiodamage.NoteBlockMusicPlayer.objects.Language;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessagePlaceholder;
import cz.studiodamage.NoteBlockMusicPlayer.objects.MessageProcessor;
import cz.studiodamage.NoteBlockMusicPlayer.objects.PlayerVolume;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class RadioCommandExecutor
implements TabExecutor {
    public boolean onCommand(CommandSender sender, Command arg1, String arg2, String[] arg3) {
        CommandExecutorType executor = CommandExecutorType.UNKNOWN;
        if (sender instanceof ConsoleCommandSender) {
            executor = CommandExecutorType.CONSOLE;
        }
        if (sender instanceof Player) {
            executor = CommandExecutorType.PLAYER;
        }
        if (executor != CommandExecutorType.UNKNOWN) {
            if (executor == CommandExecutorType.CONSOLE) {
                sender.sendMessage("[NoteBlockMusicPlayer] You can't use this command");
                return true;
            }
            if (arg3.length > 0) {
                switch (arg3[0]) {
                    case "volume": {
                        if (!sender.hasPermission("radio.volume")) {
                            this.sendNoPermsMessage(sender);
                            return true;
                        }
                        if (arg3.length > 1) {
                            if (!RadioCommandExecutor.isInteger(arg3[1])) break;
                            int volume = Integer.parseInt(arg3[1]);
                            this.changeVolume(sender, volume);
                            break;
                        }
                        NoteBlockMusicPlayer.getInstance().getMessageProcessor().sendMessage(sender, Language.COMMAND_RADIO_VOLUME_ACTUAL, MessagePlaceholder.builder().of("%volume%", String.valueOf(PlayerVolume.getPlayerVolume((Player)sender))).get());
                        break;
                    }
                    case "toggle": {
                        this.mute(sender);
                        break;
                    }
                    default: {
                        this.showHelp(sender);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String s, String[] args) {
        ArrayList<String> hints = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return hints;
        }
        if (args.length == 1) {
            String[] commands = new String[]{"volume", "toggle", "help"};
            if (!args[0].equals("")) {
                for (String com : commands) {
                    if (!com.startsWith(args[0].toLowerCase())) continue;
                    hints.add(com);
                }
            } else {
                Collections.addAll(hints, commands);
            }
        }
        return hints;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "Commands for player controls:");
        sender.sendMessage(ChatColor.GOLD + "Use /radio volume <0-100> - set volume of all radios for you");
        sender.sendMessage(ChatColor.GOLD + "Use /radio toggle - mute or unmute all radios for you");
    }

    private void mute(CommandSender sender) {
        int volume = PlayerVolume.mute((Player)sender);
        NoteBlockMusicPlayer.getInstance().getMessageProcessor().sendMessage(sender, Language.COMMAND_RADIO_VOLUME, MessagePlaceholder.builder().of("%volume%", String.valueOf(volume)).get());
    }

    private void changeVolume(CommandSender sender, int volume) {
        volume = PlayerVolume.changeVolume((Player)sender, volume);
        NoteBlockMusicPlayer.getInstance().getMessageProcessor().sendMessage(sender, Language.COMMAND_RADIO_VOLUME, MessagePlaceholder.builder().of("%volume%", String.valueOf(volume)).get());
    }

    public static boolean isInteger(String s) {
        return RadioCommandExecutor.isInteger(s, 10);
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }

    private void sendNoPermsMessage(CommandSender sender) {
        MessageProcessor messageProcessor = NoteBlockMusicPlayer.getInstance().getMessageProcessor();
        messageProcessor.sendMessage(sender, Language.COMMAND_PERMISSIONS);
    }
}

