/*
 * Decompiled with CFR 0.152.
 */
package cz.studiodamage.NoteBlockMusicPlayer.listeners;

import com.xxmicloxx.NoteBlockAPI.event.PlayerRangeStateChangeEvent;
import cz.studiodamage.NoteBlockMusicPlayer.NoteBlockMusicPlayer;
import cz.studiodamage.NoteBlockMusicPlayer.RadioManager;
import cz.studiodamage.NoteBlockMusicPlayer.objects.PlayerVolume;
import cz.studiodamage.NoteBlockMusicPlayer.player.Radio;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        Radio radio;
        Player player = e.getPlayer();
        PlayerVolume.applyPlayerVolume(player);
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        List<Radio> inRadios = radioManager.applyPriorities(player);
        if (!inRadios.isEmpty() && !(radio = inRadios.get(0)).isActionBarShownOnAdd()) {
            radio.showActionBar(player);
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        for (Radio radio : radioManager.getAllRadios()) {
            radio.removePlayer(e.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerStatePosRadioChange(PlayerRangeStateChangeEvent e) {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        List<Radio> inRadios = radioManager.applyPriorities(e.getPlayer());
        if (e.isInRange()) {
            for (Radio radio : inRadios) {
                if (!radio.getSongPlayer().equals(e.getSongPlayer())) continue;
                radio.showActionBar(e.getPlayer());
            }
        }
    }

    @EventHandler
    public void onPlayerWorldChange(PlayerChangedWorldEvent e) {
        RadioManager radioManager = NoteBlockMusicPlayer.getInstance().getRadioManager();
        List<Radio> inRadios = radioManager.applyPriorities(e.getPlayer());
        for (Radio radio : inRadios) {
            if (radio.isActionBarShownOnAdd()) continue;
            radio.showActionBar(e.getPlayer());
        }
    }
}

